/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.unlock;

import org.exoplatform.ecm.webui.component.admin.unlock.UILockNodeList;
import org.exoplatform.ecm.webui.component.admin.unlock.UIUnLockManager;
import org.exoplatform.ecm.webui.form.UIFormInputSetWithAction;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.services.cms.lock.LockService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={CancelActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={AddPermissionActionListener.class})})
public class UIUnLockForm
extends UIForm
implements UISelectable {
    public static final String GROUPS_OR_USERS = "groupsOrUsers";
    public static final String[] ACTIONS = new String[]{"Save", "Cancel"};

    public UIUnLockForm() throws Exception {
        UIFormInputSetWithAction uiInputAct = new UIFormInputSetWithAction("PermissionButton");
        uiInputAct.addUIFormInput((UIFormInput)new UIFormStringInput(GROUPS_OR_USERS, GROUPS_OR_USERS, null).setEditable(false).addValidator(MandatoryValidator.class, new Object[0]));
        uiInputAct.setActionInfo(GROUPS_OR_USERS, new String[]{"AddPermission"});
        this.addUIComponentInput((UIComponent)uiInputAct);
    }

    public String[] getActions() {
        return ACTIONS;
    }

    public void doSelect(String selectField, Object value) {
        this.getUIStringInput(selectField).setValue((Object)value.toString());
        UIUnLockManager uiManager = (UIUnLockManager)this.getAncestorOfType(UIUnLockManager.class);
        UIPopupWindow uiPopup = (UIPopupWindow)uiManager.getChildById("PermissionPopup");
        uiPopup.setRendered(false);
        uiPopup.setShow(false);
        ((UILockNodeList)uiManager.getChild(UILockNodeList.class)).setRendered(false);
        ((UIUnLockForm)uiManager.getChild(UIUnLockForm.class)).setRendered(true);
    }

    public void update() throws Exception {
        this.getUIStringInput(GROUPS_OR_USERS).setValue((Object)"");
    }

    public static class AddPermissionActionListener
    extends EventListener<UIUnLockForm> {
        public void execute(Event<UIUnLockForm> event) throws Exception {
            UIUnLockManager uiManager = (UIUnLockManager)((UIUnLockForm)((Object)event.getSource())).getAncestorOfType(UIUnLockManager.class);
            String membership = (String)((UIUnLockForm)((Object)event.getSource())).getUIStringInput(UIUnLockForm.GROUPS_OR_USERS).getValue();
            uiManager.initPermissionPopup(membership);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    public static class SaveActionListener
    extends EventListener<UIUnLockForm> {
        public void execute(Event<UIUnLockForm> event) throws Exception {
            UIUnLockForm uiUnLockForm = (UIUnLockForm)((Object)event.getSource());
            UIApplication uiApp = (UIApplication)uiUnLockForm.getAncestorOfType(UIApplication.class);
            UIFormInputSetWithAction permField = (UIFormInputSetWithAction)uiUnLockForm.getChildById("PermissionButton");
            String groupsOrUsers = (String)permField.getUIStringInput(UIUnLockForm.GROUPS_OR_USERS).getValue();
            if (groupsOrUsers == null || groupsOrUsers.trim().length() == 0) {
                uiApp.addMessage(new ApplicationMessage("UIUnLockForm.msg.permission-require", null, 1));
                return;
            }
            UIUnLockManager uiManager = (UIUnLockManager)uiUnLockForm.getAncestorOfType(UIUnLockManager.class);
            LockService lockService = (LockService)uiUnLockForm.getApplicationComponent(LockService.class);
            lockService.addGroupsOrUsersForLock(groupsOrUsers);
            UILockNodeList uiLockList = (UILockNodeList)uiManager.getChild(UILockNodeList.class);
            uiUnLockForm.update();
            uiLockList.refresh(1);
            uiLockList.setRendered(true);
            uiManager.removeChildById("PermissionPopup");
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    public static class CancelActionListener
    extends EventListener<UIUnLockForm> {
        public void execute(Event<UIUnLockForm> event) throws Exception {
            UIUnLockForm uiForm = (UIUnLockForm)((Object)event.getSource());
            UIUnLockManager uiManager = (UIUnLockManager)uiForm.getAncestorOfType(UIUnLockManager.class);
            uiManager.removeChildById("PermissionPopup");
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }
}

