/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.activity;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.activity.BaseUIActivity;
import org.exoplatform.social.webui.activity.UIActivityFactory;
import org.exoplatform.social.webui.composer.PopupContainer;
import org.exoplatform.social.webui.composer.UIComposer;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.UIPortletApplication;

@ComponentConfig(template="classpath:groovy/social/webui/UIActivitiesContainer.gtmpl")
public class UIActivitiesContainer
extends UIContainer {
    private static final Log LOG = ExoLogger.getLogger(UIActivitiesContainer.class);
    public static final String ACTIVITY_STREAM_VISITED_PREFIX_COOKIED = "exo_social_activity_stream_%s_visited_%s";
    private static final String ACTIVITIES_NODE = "activities";
    private List<ExoSocialActivity> activityList;
    private UIComposer.PostContext postContext;
    private Space space;
    private String ownerName;
    private String selectedDisplayMode;
    private long lastVisited = 0L;

    public PopupContainer getPopupContainer() {
        return (PopupContainer)((UIPortletApplication)this.getAncestorOfType(UIPortletApplication.class)).findFirstComponentOfType(PopupContainer.class);
    }

    public UIPopupWindow getPopupWindow() {
        return (UIPopupWindow)((UIPopupWindow)this.getPopupContainer().getChild(UIPopupWindow.class)).setRendered(true);
    }

    public List<ExoSocialActivity> getActivityList() {
        return this.activityList;
    }

    public UIActivitiesContainer setActivityList(List<ExoSocialActivity> activityList) throws Exception {
        this.activityList = activityList;
        this.init();
        return this;
    }

    public void setPostContext(UIComposer.PostContext postContext) {
        this.postContext = postContext;
    }

    public UIComposer.PostContext getPostContext() {
        return this.postContext;
    }

    public Space getSpace() {
        return this.space;
    }

    public void setSpace(Space space) {
        this.space = space;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public String getSelectedDisplayMode() {
        return this.selectedDisplayMode;
    }

    public void setSelectedDisplayMode(String selectedDisplayMode) {
        this.selectedDisplayMode = selectedDisplayMode;
    }

    protected long getCurrentServerTime() {
        return Calendar.getInstance().getTimeInMillis();
    }

    public boolean isOnMyActivities() {
        return Utils.getSelectedNode() != null && Utils.getSelectedNode().startsWith(ACTIVITIES_NODE);
    }

    private void init() throws Exception {
        while (this.getChild(BaseUIActivity.class) != null) {
            this.removeChild(BaseUIActivity.class);
        }
        if (this.activityList == null) {
            return;
        }
        PortalContainer portalContainer = PortalContainer.getInstance();
        UIActivityFactory factory = (UIActivityFactory)((Object)portalContainer.getComponentInstanceOfType(UIActivityFactory.class));
        for (ExoSocialActivity activity : this.activityList) {
            factory.addChild(activity, this);
        }
        this.lastVisited = this.getLastVisited(this.selectedDisplayMode);
    }

    public void addActivity(ExoSocialActivity activity) throws Exception {
        if (this.activityList == null) {
            this.activityList = new ArrayList<ExoSocialActivity>();
        }
        this.activityList.add(0, activity);
        this.init();
    }

    public void removeActivity(ExoSocialActivity removedActivity) {
        for (ExoSocialActivity activity : this.activityList) {
            if (!activity.getId().equals(removedActivity.getId())) continue;
            this.activityList.remove(activity);
            break;
        }
    }

    private long getLastVisited(String mode) {
        long currentVisited = Calendar.getInstance().getTimeInMillis();
        String strValue = Utils.getCookies(this.getCookiesKey(mode));
        if (strValue == null) {
            return currentVisited;
        }
        return Long.parseLong(strValue);
    }

    public String getCookiesKey(String displayMode) {
        return String.format(ACTIVITY_STREAM_VISITED_PREFIX_COOKIED, displayMode, Utils.getViewerRemoteId());
    }
}

