/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.NonUniqueResultException;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.Query;
import org.hibernate.QueryException;
import org.hibernate.Session;
import org.hibernate.engine.query.spi.ParameterMetadata;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.RowSelection;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.TypedValue;
import org.hibernate.internal.util.MarkerObject;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.property.Getter;
import org.hibernate.proxy.HibernateProxyHelper;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.type.SerializableType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public abstract class AbstractQueryImpl
implements Query {
    private static final Object UNSET_PARAMETER = new MarkerObject("<unset parameter>");
    private static final Object UNSET_TYPE = new MarkerObject("<unset type>");
    private final String queryString;
    protected final SessionImplementor session;
    protected final ParameterMetadata parameterMetadata;
    private List values = new ArrayList(4);
    private List types = new ArrayList(4);
    private Map<String, TypedValue> namedParameters = new HashMap<String, TypedValue>(4);
    private Map namedParameterLists = new HashMap(4);
    private Object optionalObject;
    private Serializable optionalId;
    private String optionalEntityName;
    private RowSelection selection;
    private boolean cacheable;
    private String cacheRegion;
    private String comment;
    private FlushMode flushMode;
    private CacheMode cacheMode;
    private FlushMode sessionFlushMode;
    private CacheMode sessionCacheMode;
    private Serializable collectionKey;
    private Boolean readOnly;
    private ResultTransformer resultTransformer;

    public AbstractQueryImpl(String queryString, FlushMode flushMode, SessionImplementor session, ParameterMetadata parameterMetadata) {
        this.session = session;
        this.queryString = queryString;
        this.selection = new RowSelection();
        this.flushMode = flushMode;
        this.cacheMode = null;
        this.parameterMetadata = parameterMetadata;
    }

    public ParameterMetadata getParameterMetadata() {
        return this.parameterMetadata;
    }

    public String toString() {
        return StringHelper.unqualify(this.getClass().getName()) + '(' + this.queryString + ')';
    }

    @Override
    public final String getQueryString() {
        return this.queryString;
    }

    public RowSelection getSelection() {
        return this.selection;
    }

    @Override
    public Query setFlushMode(FlushMode flushMode) {
        this.flushMode = flushMode;
        return this;
    }

    @Override
    public Query setCacheMode(CacheMode cacheMode) {
        this.cacheMode = cacheMode;
        return this;
    }

    public CacheMode getCacheMode() {
        return this.cacheMode;
    }

    @Override
    public Query setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
        return this;
    }

    @Override
    public Query setCacheRegion(String cacheRegion) {
        if (cacheRegion != null) {
            this.cacheRegion = cacheRegion.trim();
        }
        return this;
    }

    @Override
    public Query setComment(String comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public Query setFirstResult(int firstResult) {
        this.selection.setFirstRow(firstResult);
        return this;
    }

    @Override
    public Query setMaxResults(int maxResults) {
        if (maxResults < 0) {
            this.selection.setMaxRows(null);
        } else {
            this.selection.setMaxRows(maxResults);
        }
        return this;
    }

    @Override
    public Query setTimeout(int timeout) {
        this.selection.setTimeout(timeout);
        return this;
    }

    @Override
    public Query setFetchSize(int fetchSize) {
        this.selection.setFetchSize(fetchSize);
        return this;
    }

    @Override
    public Type[] getReturnTypes() throws HibernateException {
        return this.session.getFactory().getReturnTypes(this.queryString);
    }

    @Override
    public String[] getReturnAliases() throws HibernateException {
        return this.session.getFactory().getReturnAliases(this.queryString);
    }

    public Query setCollectionKey(Serializable collectionKey) {
        this.collectionKey = collectionKey;
        return this;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly == null ? this.getSession().getPersistenceContext().isDefaultReadOnly() : this.readOnly.booleanValue();
    }

    @Override
    public Query setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Override
    public Query setResultTransformer(ResultTransformer transformer) {
        this.resultTransformer = transformer;
        return this;
    }

    public void setOptionalEntityName(String optionalEntityName) {
        this.optionalEntityName = optionalEntityName;
    }

    public void setOptionalId(Serializable optionalId) {
        this.optionalId = optionalId;
    }

    public void setOptionalObject(Object optionalObject) {
        this.optionalObject = optionalObject;
    }

    SessionImplementor getSession() {
        return this.session;
    }

    public abstract LockOptions getLockOptions();

    protected Map getNamedParams() {
        return new HashMap<String, TypedValue>(this.namedParameters);
    }

    @Override
    public String[] getNamedParameters() throws HibernateException {
        return ArrayHelper.toStringArray(this.parameterMetadata.getNamedParameterNames());
    }

    public boolean hasNamedParameters() {
        return this.parameterMetadata.getNamedParameterNames().size() > 0;
    }

    protected Map getNamedParameterLists() {
        return this.namedParameterLists;
    }

    protected List getValues() {
        return this.values;
    }

    protected List getTypes() {
        return this.types;
    }

    protected void verifyParameters() throws QueryException {
        this.verifyParameters(false);
    }

    protected void verifyParameters(boolean reserveFirstParameter) throws HibernateException {
        if (this.parameterMetadata.getNamedParameterNames().size() != this.namedParameters.size() + this.namedParameterLists.size()) {
            HashSet missingParams = new HashSet(this.parameterMetadata.getNamedParameterNames());
            missingParams.removeAll(this.namedParameterLists.keySet());
            missingParams.removeAll(this.namedParameters.keySet());
            throw new QueryException("Not all named parameters have been set: " + missingParams, this.getQueryString());
        }
        int positionalValueSpan = 0;
        for (int i = 0; i < this.values.size(); ++i) {
            Object object = this.types.get(i);
            if (this.values.get(i) == UNSET_PARAMETER || object == UNSET_TYPE) {
                if (reserveFirstParameter && i == 0) continue;
                throw new QueryException("Unset positional parameter at position: " + i, this.getQueryString());
            }
            positionalValueSpan += ((Type)object).getColumnSpan(this.session.getFactory());
        }
        if (this.parameterMetadata.getOrdinalParameterCount() != positionalValueSpan) {
            if (reserveFirstParameter && this.parameterMetadata.getOrdinalParameterCount() - 1 != positionalValueSpan) {
                throw new QueryException("Expected positional parameter count: " + (this.parameterMetadata.getOrdinalParameterCount() - 1) + ", actual parameters: " + this.values, this.getQueryString());
            }
            if (!reserveFirstParameter) {
                throw new QueryException("Expected positional parameter count: " + this.parameterMetadata.getOrdinalParameterCount() + ", actual parameters: " + this.values, this.getQueryString());
            }
        }
    }

    @Override
    public Query setParameter(int position, Object val, Type type) {
        if (this.parameterMetadata.getOrdinalParameterCount() == 0) {
            throw new IllegalArgumentException("No positional parameters in query: " + this.getQueryString());
        }
        if (position < 0 || position > this.parameterMetadata.getOrdinalParameterCount() - 1) {
            throw new IllegalArgumentException("Positional parameter does not exist: " + position + " in query: " + this.getQueryString());
        }
        int size = this.values.size();
        if (position < size) {
            this.values.set(position, val);
            this.types.set(position, type);
        } else {
            for (int i = 0; i < position - size; ++i) {
                this.values.add(UNSET_PARAMETER);
                this.types.add(UNSET_TYPE);
            }
            this.values.add(val);
            this.types.add(type);
        }
        return this;
    }

    @Override
    public Query setParameter(String name, Object val, Type type) {
        if (!this.parameterMetadata.getNamedParameterNames().contains(name)) {
            throw new IllegalArgumentException("Parameter " + name + " does not exist as a named parameter in [" + this.getQueryString() + "]");
        }
        this.namedParameters.put(name, new TypedValue(type, val));
        return this;
    }

    @Override
    public Query setParameter(int position, Object val) throws HibernateException {
        if (val == null) {
            this.setParameter(position, val, (Type)StandardBasicTypes.SERIALIZABLE);
        } else {
            this.setParameter(position, val, this.determineType(position, val));
        }
        return this;
    }

    @Override
    public Query setParameter(String name, Object val) throws HibernateException {
        if (val == null) {
            Type type = this.parameterMetadata.getNamedParameterExpectedType(name);
            if (type == null) {
                type = StandardBasicTypes.SERIALIZABLE;
            }
            this.setParameter(name, val, type);
        } else {
            this.setParameter(name, val, this.determineType(name, val));
        }
        return this;
    }

    protected Type determineType(int paramPosition, Object paramValue, Type defaultType) {
        Type type = this.parameterMetadata.getOrdinalParameterExpectedType(paramPosition + 1);
        if (type == null) {
            type = defaultType;
        }
        return type;
    }

    protected Type determineType(int paramPosition, Object paramValue) throws HibernateException {
        Type type = this.parameterMetadata.getOrdinalParameterExpectedType(paramPosition + 1);
        if (type == null) {
            type = this.guessType(paramValue);
        }
        return type;
    }

    protected Type determineType(String paramName, Object paramValue, Type defaultType) {
        Type type = this.parameterMetadata.getNamedParameterExpectedType(paramName);
        if (type == null) {
            type = defaultType;
        }
        return type;
    }

    protected Type determineType(String paramName, Object paramValue) throws HibernateException {
        Type type = this.parameterMetadata.getNamedParameterExpectedType(paramName);
        if (type == null) {
            type = this.guessType(paramValue);
        }
        return type;
    }

    protected Type determineType(String paramName, Class clazz) throws HibernateException {
        Type type = this.parameterMetadata.getNamedParameterExpectedType(paramName);
        if (type == null) {
            type = this.guessType(clazz);
        }
        return type;
    }

    private Type guessType(Object param) throws HibernateException {
        Class clazz = HibernateProxyHelper.getClassWithoutInitializingProxy(param);
        return this.guessType(clazz);
    }

    private Type guessType(Class clazz) throws HibernateException {
        boolean serializable;
        String typename = clazz.getName();
        Type type = this.session.getFactory().getTypeResolver().heuristicType(typename);
        boolean bl = serializable = type != null && type instanceof SerializableType;
        if (type == null || serializable) {
            try {
                this.session.getFactory().getEntityPersister(clazz.getName());
            }
            catch (MappingException me) {
                if (serializable) {
                    return type;
                }
                throw new HibernateException("Could not determine a type for class: " + typename);
            }
            return ((Session)((Object)this.session)).getTypeHelper().entity(clazz);
        }
        return type;
    }

    @Override
    public Query setString(int position, String val) {
        this.setParameter(position, (Object)val, (Type)StandardBasicTypes.STRING);
        return this;
    }

    @Override
    public Query setCharacter(int position, char val) {
        this.setParameter(position, (Object)new Character(val), (Type)StandardBasicTypes.CHARACTER);
        return this;
    }

    @Override
    public Query setBoolean(int position, boolean val) {
        Boolean valueToUse = val;
        Type typeToUse = this.determineType(position, (Object)valueToUse, (Type)StandardBasicTypes.BOOLEAN);
        this.setParameter(position, (Object)valueToUse, typeToUse);
        return this;
    }

    @Override
    public Query setByte(int position, byte val) {
        this.setParameter(position, (Object)val, (Type)StandardBasicTypes.BYTE);
        return this;
    }

    @Override
    public Query setShort(int position, short val) {
        this.setParameter(position, (Object)val, (Type)StandardBasicTypes.SHORT);
        return this;
    }

    @Override
    public Query setInteger(int position, int val) {
        this.setParameter(position, (Object)val, (Type)StandardBasicTypes.INTEGER);
        return this;
    }

    @Override
    public Query setLong(int position, long val) {
        this.setParameter(position, (Object)val, (Type)StandardBasicTypes.LONG);
        return this;
    }

    @Override
    public Query setFloat(int position, float val) {
        this.setParameter(position, (Object)Float.valueOf(val), (Type)StandardBasicTypes.FLOAT);
        return this;
    }

    @Override
    public Query setDouble(int position, double val) {
        this.setParameter(position, (Object)val, (Type)StandardBasicTypes.DOUBLE);
        return this;
    }

    @Override
    public Query setBinary(int position, byte[] val) {
        this.setParameter(position, (Object)val, (Type)StandardBasicTypes.BINARY);
        return this;
    }

    @Override
    public Query setText(int position, String val) {
        this.setParameter(position, (Object)val, (Type)StandardBasicTypes.TEXT);
        return this;
    }

    @Override
    public Query setSerializable(int position, Serializable val) {
        this.setParameter(position, (Object)val, (Type)StandardBasicTypes.SERIALIZABLE);
        return this;
    }

    @Override
    public Query setDate(int position, Date date) {
        this.setParameter(position, (Object)date, (Type)StandardBasicTypes.DATE);
        return this;
    }

    @Override
    public Query setTime(int position, Date date) {
        this.setParameter(position, (Object)date, (Type)StandardBasicTypes.TIME);
        return this;
    }

    @Override
    public Query setTimestamp(int position, Date date) {
        this.setParameter(position, (Object)date, (Type)StandardBasicTypes.TIMESTAMP);
        return this;
    }

    @Override
    public Query setEntity(int position, Object val) {
        this.setParameter(position, val, ((Session)((Object)this.session)).getTypeHelper().entity(this.resolveEntityName(val)));
        return this;
    }

    private String resolveEntityName(Object val) {
        if (val == null) {
            throw new IllegalArgumentException("entity for parameter binding cannot be null");
        }
        return this.session.bestGuessEntityName(val);
    }

    @Override
    public Query setLocale(int position, Locale locale) {
        this.setParameter(position, (Object)locale, (Type)StandardBasicTypes.LOCALE);
        return this;
    }

    @Override
    public Query setCalendar(int position, Calendar calendar) {
        this.setParameter(position, (Object)calendar, (Type)StandardBasicTypes.CALENDAR);
        return this;
    }

    @Override
    public Query setCalendarDate(int position, Calendar calendar) {
        this.setParameter(position, (Object)calendar, (Type)StandardBasicTypes.CALENDAR_DATE);
        return this;
    }

    @Override
    public Query setBinary(String name, byte[] val) {
        this.setParameter(name, (Object)val, (Type)StandardBasicTypes.BINARY);
        return this;
    }

    @Override
    public Query setText(String name, String val) {
        this.setParameter(name, (Object)val, (Type)StandardBasicTypes.TEXT);
        return this;
    }

    @Override
    public Query setBoolean(String name, boolean val) {
        Boolean valueToUse = val;
        Type typeToUse = this.determineType(name, (Object)valueToUse, (Type)StandardBasicTypes.BOOLEAN);
        this.setParameter(name, (Object)valueToUse, typeToUse);
        return this;
    }

    @Override
    public Query setByte(String name, byte val) {
        this.setParameter(name, (Object)val, (Type)StandardBasicTypes.BYTE);
        return this;
    }

    @Override
    public Query setCharacter(String name, char val) {
        this.setParameter(name, (Object)Character.valueOf(val), (Type)StandardBasicTypes.CHARACTER);
        return this;
    }

    @Override
    public Query setDate(String name, Date date) {
        this.setParameter(name, (Object)date, (Type)StandardBasicTypes.DATE);
        return this;
    }

    @Override
    public Query setDouble(String name, double val) {
        this.setParameter(name, (Object)val, (Type)StandardBasicTypes.DOUBLE);
        return this;
    }

    @Override
    public Query setEntity(String name, Object val) {
        this.setParameter(name, val, ((Session)((Object)this.session)).getTypeHelper().entity(this.resolveEntityName(val)));
        return this;
    }

    @Override
    public Query setFloat(String name, float val) {
        this.setParameter(name, (Object)Float.valueOf(val), (Type)StandardBasicTypes.FLOAT);
        return this;
    }

    @Override
    public Query setInteger(String name, int val) {
        this.setParameter(name, (Object)val, (Type)StandardBasicTypes.INTEGER);
        return this;
    }

    @Override
    public Query setLocale(String name, Locale locale) {
        this.setParameter(name, (Object)locale, (Type)StandardBasicTypes.LOCALE);
        return this;
    }

    @Override
    public Query setCalendar(String name, Calendar calendar) {
        this.setParameter(name, (Object)calendar, (Type)StandardBasicTypes.CALENDAR);
        return this;
    }

    @Override
    public Query setCalendarDate(String name, Calendar calendar) {
        this.setParameter(name, (Object)calendar, (Type)StandardBasicTypes.CALENDAR_DATE);
        return this;
    }

    @Override
    public Query setLong(String name, long val) {
        this.setParameter(name, (Object)val, (Type)StandardBasicTypes.LONG);
        return this;
    }

    @Override
    public Query setSerializable(String name, Serializable val) {
        this.setParameter(name, (Object)val, (Type)StandardBasicTypes.SERIALIZABLE);
        return this;
    }

    @Override
    public Query setShort(String name, short val) {
        this.setParameter(name, (Object)val, (Type)StandardBasicTypes.SHORT);
        return this;
    }

    @Override
    public Query setString(String name, String val) {
        this.setParameter(name, (Object)val, (Type)StandardBasicTypes.STRING);
        return this;
    }

    @Override
    public Query setTime(String name, Date date) {
        this.setParameter(name, (Object)date, (Type)StandardBasicTypes.TIME);
        return this;
    }

    @Override
    public Query setTimestamp(String name, Date date) {
        this.setParameter(name, (Object)date, (Type)StandardBasicTypes.TIMESTAMP);
        return this;
    }

    @Override
    public Query setBigDecimal(int position, BigDecimal number) {
        this.setParameter(position, (Object)number, (Type)StandardBasicTypes.BIG_DECIMAL);
        return this;
    }

    @Override
    public Query setBigDecimal(String name, BigDecimal number) {
        this.setParameter(name, (Object)number, (Type)StandardBasicTypes.BIG_DECIMAL);
        return this;
    }

    @Override
    public Query setBigInteger(int position, BigInteger number) {
        this.setParameter(position, (Object)number, (Type)StandardBasicTypes.BIG_INTEGER);
        return this;
    }

    @Override
    public Query setBigInteger(String name, BigInteger number) {
        this.setParameter(name, (Object)number, (Type)StandardBasicTypes.BIG_INTEGER);
        return this;
    }

    @Override
    public Query setParameterList(String name, Collection vals, Type type) throws HibernateException {
        if (!this.parameterMetadata.getNamedParameterNames().contains(name)) {
            throw new IllegalArgumentException("Parameter " + name + " does not exist as a named parameter in [" + this.getQueryString() + "]");
        }
        this.namedParameterLists.put(name, new TypedValue(type, vals));
        return this;
    }

    protected String expandParameterLists(Map namedParamsCopy) {
        String query = this.queryString;
        for (Map.Entry me : this.namedParameterLists.entrySet()) {
            query = this.expandParameterList(query, (String)me.getKey(), (TypedValue)me.getValue(), namedParamsCopy);
        }
        return query;
    }

    private String expandParameterList(String query, String name, TypedValue typedList, Map namedParamsCopy) {
        boolean isEnclosedInParens;
        Collection vals = (Collection)typedList.getValue();
        Type type = typedList.getType();
        boolean isJpaPositionalParam = this.parameterMetadata.getNamedParameterDescriptor(name).isJpaStyle();
        String paramPrefix = isJpaPositionalParam ? "?" : ":";
        String placeholder = new StringBuilder(paramPrefix.length() + name.length()).append(paramPrefix).append(name).toString();
        if (query == null) {
            return query;
        }
        int loc = query.indexOf(placeholder);
        if (loc < 0) {
            return query;
        }
        String beforePlaceholder = query.substring(0, loc);
        String afterPlaceholder = query.substring(loc + placeholder.length());
        boolean bl = isEnclosedInParens = StringHelper.getLastNonWhitespaceCharacter(beforePlaceholder) == '(' && StringHelper.getFirstNonWhitespaceCharacter(afterPlaceholder) == ')';
        if (vals.size() == 1 && isEnclosedInParens) {
            namedParamsCopy.put(name, new TypedValue(type, vals.iterator().next()));
            return query;
        }
        StringBuilder list = new StringBuilder(16);
        Iterator iter = vals.iterator();
        int i = 0;
        while (iter.hasNext()) {
            String alias = (isJpaPositionalParam ? 'x' + name : name) + i++ + '_';
            namedParamsCopy.put(alias, new TypedValue(type, iter.next()));
            list.append(":").append(alias);
            if (!iter.hasNext()) continue;
            list.append(", ");
        }
        return StringHelper.replace(beforePlaceholder, afterPlaceholder, placeholder.toString(), list.toString(), true, true);
    }

    @Override
    public Query setParameterList(String name, Collection vals) throws HibernateException {
        if (vals == null) {
            throw new QueryException("Collection must be not null!");
        }
        if (vals.size() == 0) {
            this.setParameterList(name, vals, null);
        } else {
            this.setParameterList(name, vals, this.determineType(name, vals.iterator().next()));
        }
        return this;
    }

    @Override
    public Query setParameterList(String name, Object[] vals, Type type) throws HibernateException {
        return this.setParameterList(name, Arrays.asList(vals), type);
    }

    @Override
    public Query setParameterList(String name, Object[] vals) throws HibernateException {
        return this.setParameterList(name, Arrays.asList(vals));
    }

    @Override
    public Query setProperties(Map map) throws HibernateException {
        String[] params = this.getNamedParameters();
        for (int i = 0; i < params.length; ++i) {
            String namedParam = params[i];
            Object object = map.get(namedParam);
            if (object == null) continue;
            Class<?> retType = object.getClass();
            if (Collection.class.isAssignableFrom(retType)) {
                this.setParameterList(namedParam, (Collection)object);
                continue;
            }
            if (retType.isArray()) {
                this.setParameterList(namedParam, (Object[])object);
                continue;
            }
            this.setParameter(namedParam, object, this.determineType(namedParam, retType));
        }
        return this;
    }

    @Override
    public Query setProperties(Object bean) throws HibernateException {
        Class<?> clazz = bean.getClass();
        String[] params = this.getNamedParameters();
        for (int i = 0; i < params.length; ++i) {
            String namedParam = params[i];
            try {
                Getter getter = ReflectHelper.getGetter(clazz, namedParam);
                Class retType = getter.getReturnType();
                Object object = getter.get(bean);
                if (Collection.class.isAssignableFrom(retType)) {
                    this.setParameterList(namedParam, (Collection)object);
                    continue;
                }
                if (retType.isArray()) {
                    this.setParameterList(namedParam, (Object[])object);
                    continue;
                }
                this.setParameter(namedParam, object, this.determineType(namedParam, retType));
                continue;
            }
            catch (PropertyNotFoundException pnfe) {
                // empty catch block
            }
        }
        return this;
    }

    @Override
    public Query setParameters(Object[] values, Type[] types) {
        this.values = Arrays.asList(values);
        this.types = Arrays.asList(types);
        return this;
    }

    @Override
    public Object uniqueResult() throws HibernateException {
        return AbstractQueryImpl.uniqueElement(this.list());
    }

    static Object uniqueElement(List list) throws NonUniqueResultException {
        int size = list.size();
        if (size == 0) {
            return null;
        }
        Object first = list.get(0);
        for (int i = 1; i < size; ++i) {
            if (list.get(i) == first) continue;
            throw new NonUniqueResultException(list.size());
        }
        return first;
    }

    protected RowSelection getRowSelection() {
        return this.selection;
    }

    public Type[] typeArray() {
        return ArrayHelper.toTypeArray(this.getTypes());
    }

    public Object[] valueArray() {
        return this.getValues().toArray();
    }

    public QueryParameters getQueryParameters(Map namedParams) {
        Serializable[] serializableArray;
        Type[] typeArray = this.typeArray();
        Object[] objectArray = this.valueArray();
        LockOptions lockOptions = this.getLockOptions();
        RowSelection rowSelection = this.getSelection();
        boolean bl = this.isReadOnly();
        if (this.collectionKey == null) {
            serializableArray = null;
        } else {
            Serializable[] serializableArray2 = new Serializable[1];
            serializableArray = serializableArray2;
            serializableArray2[0] = this.collectionKey;
        }
        return new QueryParameters(typeArray, objectArray, namedParams, lockOptions, rowSelection, true, bl, this.cacheable, this.cacheRegion, this.comment, serializableArray, this.optionalObject, this.optionalEntityName, this.optionalId, this.resultTransformer);
    }

    protected void before() {
        if (this.flushMode != null) {
            this.sessionFlushMode = this.getSession().getFlushMode();
            this.getSession().setFlushMode(this.flushMode);
        }
        if (this.cacheMode != null) {
            this.sessionCacheMode = this.getSession().getCacheMode();
            this.getSession().setCacheMode(this.cacheMode);
        }
    }

    protected void after() {
        if (this.sessionFlushMode != null) {
            this.getSession().setFlushMode(this.sessionFlushMode);
            this.sessionFlushMode = null;
        }
        if (this.sessionCacheMode != null) {
            this.getSession().setCacheMode(this.sessionCacheMode);
            this.sessionCacheMode = null;
        }
    }
}

