/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.impl.container;

import org.gatein.pc.portlet.container.PortletFilter;
import org.gatein.pc.portlet.container.PortletFilterContext;
import org.gatein.pc.portlet.container.managed.LifeCycleStatus;
import org.gatein.pc.portlet.container.managed.ManagedObjectRegistryEventListener;
import org.gatein.pc.portlet.container.managed.ManagedPortletFilter;
import org.gatein.pc.portlet.container.object.PortletFilterObject;
import org.gatein.pc.portlet.impl.container.DependencyNotResolvedException;
import org.gatein.pc.portlet.impl.container.LifeCycle;
import org.gatein.pc.portlet.impl.container.PortletApplicationLifeCycle;
import org.gatein.pc.portlet.impl.container.PortletContainerLifeCycle;

public class PortletFilterLifeCycle
extends LifeCycle
implements ManagedPortletFilter {
    private PortletApplicationLifeCycle portletApplicationLifeCycle;
    final PortletFilterContext portletFilterContext;
    final PortletFilterObject portletFilter;

    PortletFilterLifeCycle(PortletApplicationLifeCycle portletApplicationLifeCycle, PortletFilterContext portletFilterContext, PortletFilterObject portletFilter) {
        this.portletApplicationLifeCycle = portletApplicationLifeCycle;
        this.portletFilterContext = portletFilterContext;
        this.portletFilter = portletFilter;
    }

    @Override
    protected void invokeStart() throws Exception {
        if (this.portletApplicationLifeCycle.getStatus() != LifeCycleStatus.STARTED) {
            throw new DependencyNotResolvedException("The parent application is not started");
        }
        this.portletFilter.start();
    }

    @Override
    protected void startDependents() {
        for (PortletContainerLifeCycle portletContainerLifeCycle : this.portletApplicationLifeCycle.getDependencies(this)) {
            portletContainerLifeCycle.managedStart();
        }
    }

    @Override
    protected void stopDependents() {
        for (PortletContainerLifeCycle portletContainerLifeCycle : this.portletApplicationLifeCycle.getDependencies(this)) {
            portletContainerLifeCycle.managedStop();
        }
    }

    @Override
    protected void invokeStop() {
        this.portletFilter.stop();
    }

    @Override
    public String getId() {
        return this.portletFilter.getId();
    }

    @Override
    public PortletApplicationLifeCycle getManagedPortletApplication() {
        return this.portletApplicationLifeCycle;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.portletFilter.getId() + "]";
    }

    public PortletFilter getPortletFilter() {
        return this.portletFilter;
    }

    @Override
    protected ManagedObjectRegistryEventListener getListener() {
        return this.portletApplicationLifeCycle.getListener();
    }
}

