/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.apache.shindig.gadgets.rewrite.ResponseRewriter;
import org.apache.shindig.gadgets.rewrite.ResponseRewriterRegistry;
import org.apache.shindig.gadgets.rewrite.RewritingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultResponseRewriterRegistry
implements ResponseRewriterRegistry {
    protected final List<ResponseRewriter> rewriters;
    protected final GadgetHtmlParser htmlParser;

    @Inject
    public DefaultResponseRewriterRegistry(List<ResponseRewriter> rewriters, GadgetHtmlParser htmlParser) {
        if (rewriters == null) {
            rewriters = Collections.emptyList();
        }
        this.rewriters = Lists.newLinkedList(rewriters);
        this.htmlParser = htmlParser;
    }

    @Override
    public HttpResponse rewriteHttpResponse(HttpRequest req, HttpResponse resp) throws RewritingException {
        HttpResponseBuilder builder = new HttpResponseBuilder(this.htmlParser, resp);
        for (ResponseRewriter rewriter : this.rewriters) {
            rewriter.rewrite(req, builder);
        }
        return builder.create();
    }
}

