/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.spi.web;

import java.io.IOException;
import java.util.Map;
import juzu.PropertyMap;
import juzu.PropertyType;
import juzu.Response;
import juzu.impl.asset.Asset;
import juzu.impl.bridge.Bridge;
import juzu.impl.bridge.spi.MimeBridge;
import juzu.impl.bridge.spi.web.Handler;
import juzu.impl.bridge.spi.web.WebBridge;
import juzu.impl.bridge.spi.web.WebRenderBridge;
import juzu.impl.bridge.spi.web.WebRequestBridge;
import juzu.impl.request.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WebMimeBridge
extends WebRequestBridge
implements MimeBridge {
    WebMimeBridge(Bridge bridge, Handler handler, WebBridge http, Method<?> target, Map<String, String[]> parameters) {
        super(bridge, handler, http, target, parameters);
    }

    @Override
    boolean send() throws IOException {
        if (super.send()) {
            return true;
        }
        if (this.response instanceof Response.Content) {
            Iterable<String> scripts;
            Response.Content content = (Response.Content)this.response;
            PropertyMap properties = this.response.getProperties();
            Iterable<String> stylesheets = properties.getValues(PropertyType.STYLESHEET);
            if (stylesheets != null) {
                Iterable<Asset> stylesheetValues = this.handler.getBridge().application.getStylesheetManager().resolveAssets(stylesheets);
                properties.setValues(WebBridge.STYLESHEET, stylesheetValues);
            }
            if ((scripts = properties.getValues(PropertyType.SCRIPT)) != null) {
                Iterable<Asset> scriptValues = this.handler.getBridge().application.getScriptManager().resolveAssets(scripts);
                properties.setValues(WebBridge.SCRIPT, scriptValues);
            }
            this.http.send(content, this instanceof WebRenderBridge);
            return true;
        }
        return false;
    }
}

