/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.stages;

import com.google.caja.lexer.FilePosition;
import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.MutableParseTreeNode;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.Visitor;
import com.google.caja.parser.js.ArrayConstructor;
import com.google.caja.parser.js.Declaration;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.FunctionConstructor;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.js.Operation;
import com.google.caja.parser.js.Operator;
import com.google.caja.parser.js.Reference;
import com.google.caja.parser.js.StringLiteral;
import com.google.caja.plugin.Job;
import com.google.caja.plugin.Jobs;
import com.google.caja.plugin.stages.Splitter;
import com.google.caja.util.ContentType;
import com.google.caja.util.Pipeline;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OpenTemplateStage
implements Pipeline.Stage<Jobs> {
    @Override
    public boolean apply(Jobs jobs) {
        for (Job job : jobs.getJobsByType(ContentType.JS, new ContentType[0])) {
            OpenTemplateStage.optimizeOpenTemplate(AncestorChain.instance(job.getRoot()), jobs);
        }
        return jobs.hasNoFatalErrors();
    }

    private static void optimizeOpenTemplate(AncestorChain<?> chain, Jobs jobs) {
        ScopeChecker sc = new ScopeChecker();
        OpenTemplateStage.applyToScope(chain, sc);
        if (sc.variablesInScope.contains("eval") || sc.variablesInScope.contains("Template")) {
            return;
        }
        OpenTemplateStage.applyToScope(chain, new Optimizer(jobs));
        for (AncestorChain<FunctionConstructor> innerScope : sc.innerScopes) {
            OpenTemplateStage.optimizeOpenTemplate(innerScope, jobs);
        }
    }

    private static void applyToScope(AncestorChain<?> chain, Visitor v) {
        if (chain.node instanceof FunctionConstructor) {
            for (ParseTreeNode parseTreeNode : chain.node.children()) {
                parseTreeNode.acceptPreOrder(v, chain);
            }
        } else {
            chain.node.acceptPreOrder(v, chain.parent);
        }
    }

    private static List<StringLiteral> flattenStringConcatenation(Expression e) {
        return OpenTemplateStage.flattenStringsOnto(e, new ArrayList<StringLiteral>());
    }

    private static List<StringLiteral> flattenStringsOnto(Expression e, List<StringLiteral> out) {
        Expression child;
        if (e instanceof StringLiteral) {
            out.add((StringLiteral)e);
            return out;
        }
        if (!(e instanceof Operation)) {
            return null;
        }
        Operation op = (Operation)e;
        if (op.getOperator() != Operator.ADDITION) {
            return null;
        }
        Iterator<? extends Expression> i$ = op.children().iterator();
        while (i$.hasNext() && (out = OpenTemplateStage.flattenStringsOnto(child = i$.next(), out)) != null) {
        }
        return out;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Optimizer
    implements Visitor {
        Jobs jobs;

        Optimizer(Jobs jobs) {
            this.jobs = jobs;
        }

        @Override
        public boolean visit(AncestorChain<?> chain) {
            if (chain.node instanceof FunctionConstructor) {
                return false;
            }
            if (!(chain.node instanceof Operation)) {
                return true;
            }
            Operation evalCall = (Operation)chain.node;
            if (evalCall.getOperator() != Operator.FUNCTION_CALL || evalCall.children().size() != 2) {
                return true;
            }
            Expression evalRef = evalCall.children().get(0);
            if (!(evalRef instanceof Reference) || !"eval".equals(((Reference)evalRef).getIdentifierName())) {
                return true;
            }
            Expression rhs = evalCall.children().get(1);
            if (!(rhs instanceof Operation) || rhs.children().size() != 2 && rhs.children().size() != 3) {
                return false;
            }
            Operation tmplCall = (Operation)rhs;
            if (tmplCall.getOperator() != Operator.FUNCTION_CALL) {
                return false;
            }
            Expression tmplRef = tmplCall.children().get(0);
            if (!(tmplRef instanceof Reference) || !"Template".equals(((Reference)tmplRef).getIdentifierName())) {
                return false;
            }
            List stringLiterals = OpenTemplateStage.flattenStringConcatenation(tmplCall.children().get(1));
            if (stringLiterals == null) {
                return false;
            }
            Splitter splitter = new Splitter(stringLiterals, this.jobs.getMessageQueue());
            splitter.split();
            List<Expression> templateParts = splitter.parts;
            if (templateParts == null) {
                return false;
            }
            FilePosition pos = chain.node.getFilePosition();
            FilePosition startPos = FilePosition.startOf(pos);
            ((MutableParseTreeNode)chain.parent.node).replaceChild(Operation.create(pos, Operator.FUNCTION_CALL, Operation.create(startPos, Operator.CONSTRUCTOR, new Reference(new Identifier(startPos, "StringInterpolation"))), new ArrayConstructor(pos, templateParts)), (ParseTreeNode)chain.node);
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ScopeChecker
    implements Visitor {
        final Set<String> variablesInScope = new HashSet<String>();
        final List<AncestorChain<FunctionConstructor>> innerScopes = new ArrayList<AncestorChain<FunctionConstructor>>();

        private ScopeChecker() {
        }

        @Override
        public boolean visit(AncestorChain<?> chain) {
            if (chain.node instanceof FunctionConstructor) {
                this.innerScopes.add(chain.cast(FunctionConstructor.class));
                return false;
            }
            if (chain.node instanceof Declaration) {
                String name = ((Declaration)chain.node).getIdentifierName();
                this.variablesInScope.add(name);
            }
            return true;
        }
    }
}

