/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.jbosscache;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoMode;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoModeHandler;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoModeListener;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexInfos;
import org.exoplatform.services.jcr.impl.core.query.lucene.MultiIndex;
import org.exoplatform.services.jcr.jbosscache.PrivilegedJBossCacheHelper;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheStatus;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.NodeModified;
import org.jboss.cache.notifications.event.NodeModifiedEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@CacheListener
public class JBossCacheIndexInfos
extends IndexInfos
implements IndexerIoModeListener {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.JBossCacheIndexInfos");
    private static final String INDEX_NAMES = "$names".intern();
    private static final String SYSINDEX_NAMES = "$sysNames".intern();
    private static final String LIST_KEY = "$listOfIndexes".intern();
    protected final Cache<Serializable, Object> cache;
    protected boolean system;
    protected final IndexerIoModeHandler modeHandler;
    private final Fqn namesFqn;

    public JBossCacheIndexInfos(Fqn<String> rootFqn, Cache<Serializable, Object> cache, boolean system, IndexerIoModeHandler modeHandler) {
        this(rootFqn, "indexes", cache, system, modeHandler);
    }

    public JBossCacheIndexInfos(Fqn<String> rootFqn, String fileName, Cache<Serializable, Object> cache, boolean system, IndexerIoModeHandler modeHandler) {
        super(fileName);
        this.cache = cache;
        this.modeHandler = modeHandler;
        modeHandler.addIndexerIoModeListener(this);
        this.namesFqn = Fqn.fromRelativeElements(rootFqn, (Object[])new String[]{system ? SYSINDEX_NAMES : INDEX_NAMES});
        Node cacheRoot = cache.getRoot();
        if (!cacheRoot.hasChild(this.namesFqn)) {
            cache.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
            cacheRoot.addChild(this.namesFqn).setResident(true);
        } else {
            cache.getNode(this.namesFqn).setResident(true);
        }
        if (modeHandler.getMode() == IndexerIoMode.READ_ONLY) {
            cache.addCacheListener((Object)this);
        }
    }

    @Override
    public void onChangeMode(IndexerIoMode mode) {
        if (mode == IndexerIoMode.READ_WRITE) {
            this.cache.removeCacheListener((Object)this);
            try {
                if (!this.multiIndex.isStopped()) {
                    super.read();
                }
            }
            catch (IOException e) {
                LOG.error((Object)"Cannot read the list of indexe names", (Throwable)e);
            }
        } else {
            this.cache.addCacheListener((Object)this);
        }
    }

    @Override
    public void write() throws IOException {
        if (this.isDirty() && this.modeHandler.getMode() == IndexerIoMode.READ_WRITE) {
            super.write();
            if (this.cache.getCacheStatus() == CacheStatus.STARTED) {
                PrivilegedJBossCacheHelper.put(this.cache, this.namesFqn, (Serializable)((Object)LIST_KEY), this.getNames());
            }
        }
    }

    @NodeModified
    public void cacheNodeModified(NodeModifiedEvent event) {
        if (!event.isPre() && event.getFqn().equals((Object)this.namesFqn)) {
            Set set = null;
            Map data = event.getData();
            if (data == null) {
                LOG.warn((Object)"The data map is empty");
            } else {
                set = (Set)data.get(LIST_KEY);
            }
            if (set == null) {
                LOG.warn((Object)"The data cannot be found, we will try to get it from the cache");
                set = (Set)this.cache.get(this.namesFqn, (Object)LIST_KEY);
            }
            this.refreshIndexes(set);
        }
    }

    protected void refreshIndexes(Set<String> set) {
        if (set == null) {
            return;
        }
        this.setNames(set);
        try {
            MultiIndex multiIndex = this.getMultiIndex();
            if (multiIndex != null) {
                multiIndex.refreshIndexList();
            }
        }
        catch (IOException e) {
            LOG.error((Object)("Failed to update indexes! " + e.getMessage()), (Throwable)e);
        }
    }
}

