/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spell;

import java.util.Comparator;
import org.apache.lucene.search.spell.SuggestWord;
import org.apache.lucene.search.spell.SuggestWordScoreComparator;
import org.apache.lucene.util.PriorityQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SuggestWordQueue
extends PriorityQueue<SuggestWord> {
    public static final Comparator<SuggestWord> DEFAULT_COMPARATOR = new SuggestWordScoreComparator();
    private Comparator<SuggestWord> comparator;

    public SuggestWordQueue(int size) {
        this.initialize(size);
        this.comparator = DEFAULT_COMPARATOR;
    }

    public SuggestWordQueue(int size, Comparator<SuggestWord> comparator) {
        this.initialize(size);
        this.comparator = comparator;
    }

    protected final boolean lessThan(SuggestWord wa, SuggestWord wb) {
        int val = this.comparator.compare(wa, wb);
        return val < 0;
    }
}

