/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.dataobject.runtime;

import java.util.List;
import javax.inject.Inject;
import org.chromattic.dataobject.runtime.ChromatticInjector;
import org.chromattic.groovy.ChromatticDelegate;
import org.chromattic.groovy.GroovyUtils;
import org.chromattic.groovy.exceptions.NoSuchSetterException;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.INSTRUCTION_SELECTION)
public class ChromatticTransformer
implements ASTTransformation {
    private final ChromatticDelegate delegate = new ChromatticDelegate();

    public void visit(ASTNode[] nodes, SourceUnit source) {
        List classes = source.getAST().getClasses();
        for (ClassNode classNode : classes) {
            for (FieldNode fieldNode : classNode.getFields()) {
                if (!this.isInjected(fieldNode)) continue;
                if (GroovyUtils.getSetter((ClassNode)classNode, (FieldNode)fieldNode) == null) {
                    GroovyUtils.createSetter((ClassNode)classNode, (FieldNode)fieldNode);
                }
                try {
                    this.delegate.plugInjector(fieldNode, new ClassNode(ChromatticInjector.class));
                }
                catch (NoSuchSetterException ignore) {
                    ignore.printStackTrace();
                }
            }
        }
    }

    private boolean isInjected(FieldNode fieldNode) {
        for (AnnotationNode annotationNode : fieldNode.getAnnotations()) {
            if (!annotationNode.getClassNode().equals((Object)new ClassNode(Inject.class))) continue;
            return true;
        }
        return false;
    }
}

