/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.saml.v1.writers;

import java.net.URI;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamWriter;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.saml.v1.writers.BaseSAML11Writer;
import org.picketlink.identity.federation.core.saml.v1.writers.SAML11AssertionWriter;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLConstants;
import org.picketlink.identity.federation.core.util.StaxUtil;
import org.picketlink.identity.federation.core.util.StringUtil;
import org.picketlink.identity.federation.saml.common.CommonStatusDetailType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11AssertionType;
import org.picketlink.identity.federation.saml.v1.protocol.SAML11ResponseType;
import org.picketlink.identity.federation.saml.v1.protocol.SAML11StatusCodeType;
import org.picketlink.identity.federation.saml.v1.protocol.SAML11StatusType;
import org.w3c.dom.Element;

public class SAML11ResponseWriter
extends BaseSAML11Writer {
    protected String namespace = "urn:oasis:names:tc:SAML:1.0:protocol";
    protected SAML11AssertionWriter assertionWriter;

    public SAML11ResponseWriter(XMLStreamWriter writer) {
        super(writer);
        this.assertionWriter = new SAML11AssertionWriter(writer);
    }

    public void write(SAML11ResponseType response) throws ProcessingException {
        SAML11StatusType status;
        Element sig;
        URI recipient;
        StaxUtil.writeStartElement(this.writer, PROTOCOL_PREFIX, "Response", this.namespace);
        StaxUtil.writeNameSpace(this.writer, PROTOCOL_PREFIX, this.namespace);
        StaxUtil.writeNameSpace(this.writer, ASSERTION_PREFIX, "urn:oasis:names:tc:SAML:1.0:assertion");
        StaxUtil.writeAttribute(this.writer, "ResponseID", response.getID());
        StaxUtil.writeAttribute(this.writer, "MajorVersion", response.getMajorVersion() + "");
        StaxUtil.writeAttribute(this.writer, "MinorVersion", response.getMinorVersion() + "");
        StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.ISSUE_INSTANT.get(), response.getIssueInstant().toString());
        String inResp = response.getInResponseTo();
        if (StringUtil.isNotNull(inResp)) {
            StaxUtil.writeAttribute(this.writer, "InResponseTo", inResp);
        }
        if ((recipient = response.getRecipient()) != null) {
            StaxUtil.writeAttribute(this.writer, "Recipient", recipient.toString());
        }
        if ((sig = response.getSignature()) != null) {
            StaxUtil.writeDOMElement(this.writer, sig);
        }
        if ((status = response.getStatus()) != null) {
            this.write(status);
        }
        List<SAML11AssertionType> assertions = response.get();
        for (SAML11AssertionType assertion : assertions) {
            this.assertionWriter.write(assertion);
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    public void write(SAML11StatusType status) throws ProcessingException {
        CommonStatusDetailType details;
        String statusMsg;
        StaxUtil.writeStartElement(this.writer, PROTOCOL_PREFIX, "Status", this.namespace);
        SAML11StatusCodeType statusCode = status.getStatusCode();
        if (statusCode != null) {
            this.write(statusCode);
        }
        if (StringUtil.isNotNull(statusMsg = status.getStatusMessage())) {
            StaxUtil.writeStartElement(this.writer, PROTOCOL_PREFIX, "StatusMessage", this.namespace);
            StaxUtil.writeCharacters(this.writer, statusMsg);
            StaxUtil.writeEndElement(this.writer);
        }
        if ((details = status.getStatusDetail()) != null) {
            StaxUtil.writeStartElement(this.writer, PROTOCOL_PREFIX, "StatusDetail", this.namespace);
            List<Object> objs = details.getAny();
            for (Object theObj : objs) {
                StaxUtil.writeCharacters(this.writer, theObj.toString());
            }
            StaxUtil.writeEndElement(this.writer);
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    public void write(SAML11StatusCodeType statusCode) throws ProcessingException {
        StaxUtil.writeStartElement(this.writer, PROTOCOL_PREFIX, "StatusCode", this.namespace);
        QName value = statusCode.getValue();
        if (value == null) {
            throw logger.writerNullValueError("Attribute Value");
        }
        StaxUtil.writeAttribute(this.writer, "Value", value);
        SAML11StatusCodeType secondCode = statusCode.getStatusCode();
        if (secondCode != null) {
            this.write(secondCode);
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }
}

