/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jgroups.Event;
import org.jgroups.stack.Protocol;

public class AUTOCONF
extends Protocol {
    final Map<String, Object> config = new HashMap<String, Object>();
    static int num_iterations = 10;
    static int frag_overhead = 1000;

    @Override
    public String getName() {
        return "AUTOCONF";
    }

    @Override
    public void init() throws Exception {
        this.senseNetworkConfiguration();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("configuration is\n" + this.config));
        }
    }

    @Override
    public void start() throws Exception {
        if (this.config != null && this.config.size() > 0) {
            Event config_evt = new Event(56, this.config);
            this.down_prot.down(config_evt);
            this.up_prot.up(config_evt);
        }
    }

    @Override
    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("num_iterations");
        if (str != null) {
            num_iterations = Integer.parseInt(str);
            props.remove("num_iterations");
        }
        if ((str = props.getProperty("frag_overhead")) != null) {
            frag_overhead = Integer.parseInt(str);
            props.remove("frag_overhead");
        }
        if (props.size() > 0) {
            this.log.error((Object)("AUTOCONF.setProperties(): the following properties are not recognized: " + props));
            return false;
        }
        return true;
    }

    void senseNetworkConfiguration() {
        int max_frag_size = this.senseMaxFragSize();
        if (max_frag_size <= 0) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("max_frag_size is invalid: " + max_frag_size));
            }
        } else {
            this.config.put("frag_size", new Integer(max_frag_size));
        }
        this.senseMaxSendBufferSize(this.config);
        this.senseMaxReceiveBufferSize(this.config);
    }

    public static int senseMaxFragSizeStatic() {
        return new AUTOCONF().senseMaxFragSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int senseMaxFragSize() {
        InetAddress local_addr;
        DatagramSocket sock;
        int max_send = 32000;
        int lower = 0;
        int highest_failed = -1;
        try {
            sock = new DatagramSocket();
            local_addr = InetAddress.getLocalHost();
        }
        catch (Exception ex) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)("failed creating DatagramSocket: " + ex));
            }
            return 0;
        }
        try {
            int upper = max_send;
            for (int i = 0; i < num_iterations && lower < upper; ++i) {
                try {
                    byte[] buf = new byte[upper];
                    DatagramPacket packet = new DatagramPacket(buf, buf.length, local_addr, 9);
                    sock.send(packet);
                    lower = Math.max(lower, upper);
                    upper *= 2;
                    if (highest_failed <= -1) continue;
                    upper = Math.min(highest_failed, upper);
                    continue;
                }
                catch (IOException io_ex) {
                    highest_failed = highest_failed > -1 ? Math.min(highest_failed, upper) : upper;
                    upper = (upper + lower) / 2;
                    continue;
                }
                catch (Throwable ex) {
                    if (!this.log.isWarnEnabled()) break;
                    this.log.warn((Object)("exception=" + ex));
                    break;
                }
            }
            lower -= frag_overhead;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("frag_size=" + lower));
            }
            int n = lower;
            return n;
        }
        finally {
            if (sock != null) {
                sock.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void senseMaxSendBufferSize(Map<String, Object> map) {
        int max_size;
        int retval = max_size = 4096;
        if (map != null && map.containsKey("frag_size)")) {
            max_size = (Integer)map.get("frag_size");
        }
        try {
            DatagramSocket sock = new DatagramSocket();
            while (max_size < 1000000) {
                sock.setSendBufferSize(max_size);
                retval = sock.getSendBufferSize();
                if (retval < max_size) {
                    return;
                }
                max_size *= 2;
            }
        }
        catch (Throwable ex) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("failed getting the max send buffer size: " + ex + ". Defaulting to " + retval));
            }
        }
        finally {
            map.put("send_buf_size", new Integer(retval));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void senseMaxReceiveBufferSize(Map<String, Object> map) {
        int max_size;
        int retval = max_size = 4096;
        try {
            DatagramSocket sock = new DatagramSocket();
            while (max_size < 1000000) {
                sock.setReceiveBufferSize(max_size);
                retval = sock.getReceiveBufferSize();
                if (retval < max_size) {
                    return;
                }
                max_size *= 2;
            }
        }
        catch (Throwable ex) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("failed getting the max send buffer size: " + ex + ". Defaulting to " + retval));
            }
        }
        finally {
            map.put("recv_buf_size", new Integer(retval));
        }
    }

    public static void main(String[] args) {
        int frag_size = new AUTOCONF().senseMaxFragSize();
        System.out.println("frag_size: " + frag_size);
    }
}

