/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.authoring.listener;

import java.util.Collection;
import java.util.Iterator;
import javax.jcr.Node;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.wcm.extensions.publication.PublicationManager;
import org.exoplatform.services.wcm.extensions.publication.lifecycle.impl.LifecyclesConfig;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.core.UIComponent;

public class PostUpdateStateEventListener
extends Listener<CmsService, Node> {
    private static final Log LOG = ExoLogger.getLogger((String)PostUpdateStateEventListener.class.getName());
    private PublicationManager publicationManager;

    public PostUpdateStateEventListener(PublicationManager publicationManager) {
        this.publicationManager = publicationManager;
    }

    public void onEvent(Event<CmsService, Node> event) throws Exception {
        block10: {
            String userId;
            Node node = (Node)event.getData();
            try {
                userId = Util.getPortalRequestContext().getRemoteUser();
            }
            catch (Exception e) {
                userId = node.getSession().getUserID();
            }
            String currentState = node.getProperty("publication:currentState").getString();
            if (!"enrolled".equals(currentState)) {
                String nodeLifecycle = node.getProperty("publication:lifecycle").getString();
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("@@@ " + currentState + " @@@@@@@@@@@@@@@@@@@ " + node.getPath()));
                }
                LifecyclesConfig.Lifecycle lifecycle = this.publicationManager.getLifecycle(nodeLifecycle);
                Iterator states = lifecycle.getStates().iterator();
                LifecyclesConfig.State prevState = null;
                while (states.hasNext()) {
                    LifecyclesConfig.State state = (LifecyclesConfig.State)states.next();
                    if (state.getState().equals(currentState)) {
                        this.sendMail(node, state, userId, false, false);
                        if ("published".equals(state.getState()) && prevState != null) {
                            this.sendMail(node, prevState, userId, false, true);
                        }
                        if (states.hasNext()) {
                            LifecyclesConfig.State nextState = (LifecyclesConfig.State)states.next();
                            this.sendMail(node, nextState, userId, true, false);
                            break;
                        }
                    }
                    prevState = state;
                }
                try {
                    UIPortalApplication portalApplication = Util.getUIPortalApplication();
                    PortalRequestContext portalRequestContext = Util.getPortalRequestContext();
                    UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)portalApplication.getChildById("UIWorkingWorkspace");
                    portalRequestContext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
                    portalRequestContext.setFullRender(true);
                }
                catch (Exception e) {
                    if (!LOG.isWarnEnabled()) break block10;
                    LOG.warn((Object)e.getMessage());
                }
            }
        }
    }

    private void sendMail(Node node, LifecyclesConfig.State state, String userId, boolean isNextState, boolean isPublished) throws Exception {
        if (state.getMembership().contains(":")) {
            User currentUser;
            ListAccess userList;
            MembershipHandler msh;
            String group;
            String membershipType;
            block6: {
                String[] membership = state.getMembership().split(":");
                membershipType = membership[0];
                group = membership[1];
                OrganizationService orgService = (OrganizationService)WCMCoreUtils.getService(OrganizationService.class);
                UserHandler userh = orgService.getUserHandler();
                msh = orgService.getMembershipHandler();
                userList = userh.findUsersByGroupId(group);
                currentUser = null;
                try {
                    currentUser = userh.findUserByName(userId);
                }
                catch (Exception e) {
                    if (!LOG.isWarnEnabled()) break block6;
                    LOG.warn((Object)e.getMessage());
                }
            }
            String username = userId;
            if (currentUser != null) {
                username = currentUser.getFirstName() + " " + currentUser.getLastName();
            }
            for (User user : (User[])userList.load(0, userList.getSize())) {
                Collection mss = msh.findMembershipsByUserAndGroup(user.getUserName(), group);
                for (Membership ms : mss) {
                    if (!membershipType.equals(ms.getMembershipType())) continue;
                    String from = "\"" + username + "\" <exocontent@exoplatform.com>";
                    String to = user.getEmail();
                    String editUrl = "http://localhost:8080/ecmdemo/private/classic/siteExplorer/repository/collaboration" + node.getPath();
                    String subject = isPublished ? "[eXo Content] Published : (published) " + node.getName() : (isNextState ? "[eXo Content] Request : (" + state.getState() + ") " + node.getName() : "[eXo Content] Updated : (" + state.getState() + ") " + node.getName());
                    String body = "[ <a href=\"" + editUrl + "\">" + editUrl + "</a> ]<br/>" + "updated by " + username;
                    if (!LOG.isInfoEnabled()) continue;
                    LOG.info((Object)("\n################ SEND MAIL TO USER :: " + user.getUserName() + "\nfrom: " + from + "\nto: " + to + "\nsubject: " + subject + "\nbody: " + body + "\n######################################################"));
                }
            }
        }
    }
}

