/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.integration;

import java.util.LinkedHashMap;
import java.util.Map;
import org.exoplatform.container.component.ComponentPlugin;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.sso.agent.filter.api.SSOInterceptor;
import org.gatein.sso.integration.SSOFilterIntegrator;
import org.gatein.sso.integration.SSOFilterIntegratorPlugin;

public class SSOFilterIntegratorImpl
implements SSOFilterIntegrator {
    private final Map<SSOInterceptor, String> ssoInterceptors = new LinkedHashMap<SSOInterceptor, String>();
    private static final Logger log = LoggerFactory.getLogger(SSOFilterIntegratorImpl.class);

    public void addPlugin(ComponentPlugin plugin) {
        if (plugin instanceof SSOFilterIntegratorPlugin) {
            SSOFilterIntegratorPlugin ssoPlugin = (SSOFilterIntegratorPlugin)plugin;
            if (!ssoPlugin.isEnabled()) {
                return;
            }
            SSOInterceptor ssoInterceptor = ssoPlugin.getFilter();
            this.ssoInterceptors.put(ssoInterceptor, ssoPlugin.getFilterMapping());
            log.debug((Object)("Added new SSOInterceptor " + ssoInterceptor));
        }
    }

    @Override
    public Map<SSOInterceptor, String> getSSOInterceptors() {
        return this.ssoInterceptors;
    }
}

