/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow;

import java.io.IOException;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.dataflow.AbstractValueData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.BooleanPersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.PersistedValueData;

public abstract class BooleanValueData
extends AbstractValueData {
    protected boolean value;

    protected BooleanValueData(int orderNumber, boolean value) {
        super(orderNumber);
        this.value = value;
    }

    protected boolean internalEquals(ValueData another) {
        if (another instanceof BooleanValueData) {
            return ((BooleanValueData)another).value == this.value;
        }
        return false;
    }

    protected byte[] spoolInternalValue() {
        return Boolean.toString(this.value).getBytes();
    }

    public String toString() {
        return Boolean.valueOf(this.value).toString();
    }

    public PersistedValueData createPersistedCopy(int orderNumber) throws IOException {
        return new BooleanPersistedValueData(orderNumber, this.value);
    }

    public TransientValueData createTransientCopy(int orderNumber) throws IOException {
        return new TransientValueData(orderNumber, this.value);
    }

    protected Boolean getBoolean() {
        return this.value;
    }

    protected String getString() {
        return Boolean.toString(this.value);
    }
}

