/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow;

import java.io.IOException;
import java.util.Calendar;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.dataflow.AbstractValueData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.DoublePersistedValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.PersistedValueData;

public abstract class DoubleValueData
extends AbstractValueData {
    protected double value;

    protected DoubleValueData(int orderNumber, double value) {
        super(orderNumber);
        this.value = value;
    }

    protected boolean internalEquals(ValueData another) {
        if (another instanceof DoubleValueData) {
            return ((DoubleValueData)another).value == this.value;
        }
        return false;
    }

    protected byte[] spoolInternalValue() {
        return Double.toString(this.value).getBytes();
    }

    public String toString() {
        return Double.valueOf(this.value).toString();
    }

    public PersistedValueData createPersistedCopy(int orderNumber) throws IOException {
        return new DoublePersistedValueData(orderNumber, this.value);
    }

    public TransientValueData createTransientCopy(int orderNumber) throws IOException {
        return new TransientValueData(orderNumber, this.value);
    }

    protected Long getLong() {
        return (long)this.value;
    }

    protected Double getDouble() {
        return this.value;
    }

    protected String getString() {
        return Double.toString(this.value);
    }

    protected Calendar getDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(new Double(this.value).longValue());
        return calendar;
    }
}

