/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db;

import java.sql.SQLException;
import javax.jcr.RepositoryException;
import javax.sql.DataSource;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCDataContainerConfig;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.GenericCQConnectionFactory;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.OracleMultiDbJDBCConnection;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.OracleSingleDbJDBCConnection;
import org.exoplatform.services.jcr.storage.WorkspaceStorageConnection;

public class DefaultOracleConnectionFactory
extends GenericCQConnectionFactory {
    public DefaultOracleConnectionFactory(DataSource dataSource, JDBCDataContainerConfig containerConfig) {
        super(dataSource, containerConfig);
    }

    public WorkspaceStorageConnection openConnection(boolean readOnly) throws RepositoryException {
        try {
            if (this.containerConfig.useQueryHints) {
                if (this.containerConfig.dbStructureType.isMultiDatabase()) {
                    return new OracleMultiDbJDBCConnection(this.getJdbcConnection(readOnly), readOnly, this.containerConfig);
                }
                return new OracleSingleDbJDBCConnection(this.getJdbcConnection(readOnly), readOnly, this.containerConfig);
            }
            return super.openConnection(readOnly);
        }
        catch (SQLException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public boolean isIDNeededForPaging() {
        return false;
    }
}

