/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.remote;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.point.PointDatasetImpl;
import ucar.nc2.ft.point.remote.RemotePointCollection;
import ucar.nc2.ft.point.remote.RemoteStationCollection;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.DateRange;
import ucar.unidata.geoloc.LatLonRect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointDatasetRemote
extends PointDatasetImpl {
    public PointDatasetRemote(FeatureType wantFeatureType, String uri, List<VariableSimpleIF> vars, LatLonRect bb, DateRange dr) throws IOException {
        super(wantFeatureType);
        this.setBoundingBox(bb);
        this.setDateRange(dr);
        this.dataVariables = new ArrayList<VariableSimpleIF>(vars);
        this.collectionList = new ArrayList(1);
        switch (wantFeatureType) {
            case POINT: {
                this.collectionList.add(new RemotePointCollection(uri, null));
                break;
            }
            case STATION: {
                this.collectionList.add(new RemoteStationCollection(uri));
                break;
            }
            default: {
                throw new UnsupportedOperationException("No implemenattion for " + (Object)((Object)wantFeatureType));
            }
        }
    }

    static String makeQuery(String station, LatLonRect boundingBox, DateRange dateRange) {
        StringBuilder query = new StringBuilder();
        boolean needamp = false;
        if (station != null) {
            query.append(station);
            needamp = true;
        }
        if (boundingBox != null) {
            if (needamp) {
                query.append("&");
            }
            query.append("west=");
            query.append(boundingBox.getLonMin());
            query.append("&east=");
            query.append(boundingBox.getLonMax());
            query.append("&south=");
            query.append(boundingBox.getLatMin());
            query.append("&north=");
            query.append(boundingBox.getLatMax());
            needamp = true;
        }
        if (dateRange != null) {
            DateFormatter df = new DateFormatter();
            if (needamp) {
                query.append("&");
            }
            query.append("time_start=");
            query.append(df.toDateTimeStringISO(dateRange.getStart().getDate()));
            query.append("&time_end=");
            query.append(df.toDateTimeStringISO(dateRange.getEnd().getDate()));
        }
        if (!needamp) {
            query.append("all");
        }
        return query.toString();
    }
}

