/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.application;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.portlet.PortletMode;
import org.exoplatform.commons.utils.ExceptionUtil;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.pom.spi.portlet.Preference;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.portal.webui.application.UIFormInputThemeSelector;
import org.exoplatform.portal.webui.application.UIItemThemeSelector;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputIconSelector;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTabPane;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.input.UICheckBoxInput;
import org.exoplatform.webui.form.validator.ExpressionValidator;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.NotHTMLTagValidator;
import org.exoplatform.webui.form.validator.StringLengthValidator;
import org.exoplatform.webui.organization.UIListPermissionSelector;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.info.PreferenceInfo;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.RenderInvocation;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.state.PropertyChange;

@ComponentConfigs(value={@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/portal/webui/portal/UIPortletForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CloseActionListener.class}, phase=Event.Phase.DECODE)}), @ComponentConfig(id="PortletPermission", type=UIFormInputSet.class, lifecycle=UIContainerLifecycle.class)})
public class UIPortletForm
extends UIFormTabPane {
    private static Log log = ExoLogger.getLogger((String)"portal:UIPortletForm");
    private UIPortlet uiPortlet_;
    private UIComponent backComponent_;
    private static final String FIELD_THEME = "Theme";
    private static final String FIELD_PORTLET_PREF = "PortletPref";

    public UIPortletForm() throws Exception {
        super("UIPortletForm");
        UIFormInputSet uiPortletPrefSet = (UIFormInputSet)new UIFormInputSet(FIELD_PORTLET_PREF).setRendered(false);
        this.addUIFormInput(uiPortletPrefSet);
        UIFormInputSet uiSettingSet = new UIFormInputSet("PortletSetting");
        uiSettingSet.addUIFormInput((UIFormInput)new UIFormInputInfo("displayName", "displayName", null)).addUIFormInput((UIFormInput)new UIFormStringInput("title", "title", null).addValidator(StringLengthValidator.class, new Object[]{3, 60}).addValidator(NotHTMLTagValidator.class, new Object[]{"UIPortletForm.msg.InvalidPortletTitle"})).addUIFormInput((UIFormInput)new UIFormStringInput("width", "width", null).addValidator(ExpressionValidator.class, new Object[]{"(^([1-9]\\d*)(?:px)?$)?", "UIPortletForm.msg.InvalidWidthHeight"})).addUIFormInput((UIFormInput)new UIFormStringInput("height", "height", null).addValidator(ExpressionValidator.class, new Object[]{"(^([1-9]\\d*)(?:px)?$)?", "UIPortletForm.msg.InvalidWidthHeight"})).addUIFormInput((UIFormInput)new UICheckBoxInput("showInfoBar", "showInfoBar", Boolean.valueOf(false))).addUIFormInput((UIFormInput)new UICheckBoxInput("showPortletMode", "showPortletMode", Boolean.valueOf(false))).addUIFormInput((UIFormInput)new UICheckBoxInput("showWindowState", "showWindowState", Boolean.valueOf(false))).addUIFormInput((UIFormInput)new UIFormTextAreaInput("description", "description", null).addValidator(NotHTMLTagValidator.class, new Object[]{"UIPortletForm.msg.InvalidPortletDescription"}));
        this.addUIFormInput(uiSettingSet);
        UIFormInputIconSelector uiIconSelector = new UIFormInputIconSelector("Icon", "icon");
        this.addUIFormInput((UIFormInput)uiIconSelector);
        UIFormInputThemeSelector uiThemeSelector = new UIFormInputThemeSelector(FIELD_THEME, null);
        SkinService skinService = (SkinService)this.getApplicationComponent(SkinService.class);
        ((UIItemThemeSelector)uiThemeSelector.getChild(UIItemThemeSelector.class)).setValues(skinService.getPortletThemes());
        this.addUIFormInput((UIFormInput)uiThemeSelector);
        UIListPermissionSelector uiListPermissionSelector = (UIListPermissionSelector)this.createUIComponent(UIListPermissionSelector.class, null, null);
        uiListPermissionSelector.configure("PortletPermissionSelector", "accessPermissions");
        uiListPermissionSelector.addValidator(UIListPermissionSelector.EmptyIteratorValidator.class, new Object[0]);
        UIFormInputSet uiPermissionSet = (UIFormInputSet)this.createUIComponent(UIFormInputSet.class, "PortletPermission", null);
        uiPermissionSet.addChild((UIComponent)uiListPermissionSelector);
        this.addUIFormInput(uiPermissionSet);
    }

    public UIComponent getBackComponent() {
        return this.backComponent_;
    }

    public void setBackComponent(UIComponent uiComp) {
        this.backComponent_ = uiComp;
    }

    public UIPortlet getUIPortlet() {
        return this.uiPortlet_;
    }

    public boolean hasEditMode() {
        return this.uiPortlet_.getSupportModes().contains("edit");
    }

    public String getEditModeContent() {
        try {
            RenderInvocation portletInvocation;
            PortalRequestContext prcontext = (PortalRequestContext)WebuiRequestContext.getCurrentInstance();
            prcontext.ignoreAJAXUpdateOnPortlets(true);
            RenderInvocation renderInvocation = portletInvocation = this.uiPortlet_.create(RenderInvocation.class, prcontext);
            renderInvocation.setMode(Mode.create((String)PortletMode.EDIT.toString()));
            PortletInvocationResponse portletResponse = this.uiPortlet_.invoke((PortletInvocation)renderInvocation);
            StringWriter writer = new StringWriter();
            this.uiPortlet_.generateRenderMarkup(portletResponse, prcontext).writeTo((Writer)writer);
            return writer.toString();
        }
        catch (Throwable ex) {
            WebuiRequestContext webuiRequest = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            log.error((Object)("The portlet " + this.uiPortlet_.getName() + " could not be loaded. Check if properly deployed."), ExceptionUtil.getRootCause((Throwable)ex));
            return webuiRequest.getApplicationResourceBundle().getString("UIPortlet.message.RuntimeError");
        }
    }

    public boolean setValues(UIPortlet uiPortlet) throws Exception {
        this.uiPortlet_ = uiPortlet;
        Portlet portlet = uiPortlet.getProducedOfferedPortlet();
        if (portlet == null) {
            return false;
        }
        this.invokeGetBindingBean((Object)this.uiPortlet_);
        String icon = uiPortlet.getIcon();
        if (icon == null || icon.length() < 0) {
            icon = "PortletIcon";
        }
        ((UIFormInputIconSelector)this.getChild(UIFormInputIconSelector.class)).setSelectedIcon(icon);
        ((UIItemThemeSelector)((UIFormInputThemeSelector)this.getChild(UIFormInputThemeSelector.class)).getChild(UIItemThemeSelector.class)).setSelectedTheme(uiPortlet.getSuitedTheme(null));
        if (this.hasEditMode()) {
            uiPortlet.setCurrentPortletMode(PortletMode.EDIT);
        } else {
            HashMap<String, String> portletPreferenceMaps = new HashMap<String, String>();
            Set keySet = portlet.getInfo().getPreferences().getKeys();
            for (String key : keySet) {
                PreferenceInfo preferenceInfo = portlet.getInfo().getPreferences().getPreference(key);
                if (preferenceInfo.isReadOnly().booleanValue()) continue;
                String ppValue = preferenceInfo.getDefaultValue().size() > 0 ? (String)preferenceInfo.getDefaultValue().get(0) : "";
                portletPreferenceMaps.put(key, ppValue);
            }
            org.exoplatform.portal.pom.spi.portlet.Portlet pp = uiPortlet.getPreferences();
            if (pp != null) {
                for (Preference pref : pp) {
                    if (pref.isReadOnly()) continue;
                    portletPreferenceMaps.put(pref.getName(), pref.getValues().size() > 0 ? (String)pref.getValues().get(0) : "");
                }
            }
            if (portletPreferenceMaps.size() > 0) {
                Set ppKeySet = portletPreferenceMaps.keySet();
                UIFormInputSet uiPortletPrefSet = (UIFormInputSet)this.getChildById(FIELD_PORTLET_PREF);
                uiPortletPrefSet.getChildren().clear();
                for (String ppKey : ppKeySet) {
                    String ppValue = (String)portletPreferenceMaps.get(ppKey);
                    UIFormStringInput preferenceStringInput = new UIFormStringInput(ppKey, null, ppValue);
                    preferenceStringInput.setLabel(ppKey);
                    preferenceStringInput.addValidator(MandatoryValidator.class, new Object[0]);
                    uiPortletPrefSet.addUIFormInput((UIFormInput)preferenceStringInput);
                }
                uiPortletPrefSet.setRendered(true);
                this.setSelectedTab(FIELD_PORTLET_PREF);
            } else {
                this.setSelectedTab("PortletSetting");
            }
        }
        return true;
    }

    private void savePreferences() throws Exception {
        UIFormInputSet uiPortletPrefSet = (UIFormInputSet)this.getChildById(FIELD_PORTLET_PREF);
        ArrayList uiFormInputs = new ArrayList(3);
        uiPortletPrefSet.findComponentOfType(uiFormInputs, UIFormStringInput.class);
        if (uiFormInputs.size() < 1) {
            return;
        }
        PropertyChange[] propertyChanges = new PropertyChange[uiFormInputs.size()];
        for (int i = 0; i < uiFormInputs.size(); ++i) {
            String name = ((UIFormStringInput)uiFormInputs.get(i)).getName();
            String value = (String)((UIFormStringInput)uiFormInputs.get(i)).getValue();
            propertyChanges[i] = PropertyChange.newUpdate((String)name, (String)value);
        }
        this.uiPortlet_.update(propertyChanges);
    }

    public static class CloseActionListener
    extends EventListener<UIPortletForm> {
        public void execute(Event<UIPortletForm> event) throws Exception {
            UIPortletForm uiPortletForm = (UIPortletForm)((Object)event.getSource());
            UIPortlet uiPortlet = uiPortletForm.getUIPortlet();
            if (uiPortletForm.hasEditMode()) {
                uiPortlet.setCurrentPortletMode(PortletMode.VIEW);
            }
            UIPortalApplication uiPortalApp = Util.getUIPortalApplication();
            PortalRequestContext pcontext = (PortalRequestContext)event.getRequestContext();
            UIMaskWorkspace uiMaskWorkspace = (UIMaskWorkspace)uiPortalApp.getChildById("UIMaskWorkspace");
            uiMaskWorkspace.broadcast(event, Event.Phase.DECODE);
            pcontext.ignoreAJAXUpdateOnPortlets(true);
        }
    }

    public static class SaveActionListener
    extends EventListener<UIPortletForm> {
        public void execute(Event<UIPortletForm> event) throws Exception {
            String width;
            UIPortletForm uiPortletForm = (UIPortletForm)((Object)event.getSource());
            UIPortlet uiPortlet = uiPortletForm.getUIPortlet();
            UIFormInputIconSelector uiIconSelector = (UIFormInputIconSelector)uiPortletForm.getChild(UIFormInputIconSelector.class);
            uiPortletForm.invokeSetBindingBean((Object)uiPortlet);
            if (uiIconSelector.getSelectedIcon().equals("Default")) {
                uiPortlet.setIcon("PortletIcon");
            } else {
                uiPortlet.setIcon(uiIconSelector.getSelectedIcon());
            }
            UIFormInputThemeSelector uiThemeSelector = (UIFormInputThemeSelector)uiPortletForm.getChild(UIFormInputThemeSelector.class);
            uiPortlet.putSuitedTheme(null, ((UIItemThemeSelector)uiThemeSelector.getChild(UIItemThemeSelector.class)).getSelectedTheme());
            uiPortletForm.savePreferences();
            UIMaskWorkspace uiMaskWorkspace = (UIMaskWorkspace)uiPortletForm.getParent();
            PortalRequestContext pcontext = (PortalRequestContext)event.getRequestContext();
            uiMaskWorkspace.createEvent("Close", Event.Phase.DECODE, pcontext).broadcast();
            if (uiPortletForm.hasEditMode()) {
                uiPortlet.setCurrentPortletMode(PortletMode.VIEW);
            }
            if ((width = (String)uiPortletForm.getUIStringInput("width").getValue()) == null || width.length() == 0) {
                uiPortlet.setWidth(null);
            } else {
                if (!width.endsWith("px")) {
                    width = width.concat("px");
                }
                uiPortlet.setWidth(width);
            }
            String height = (String)uiPortletForm.getUIStringInput("height").getValue();
            if (height == null || height.length() == 0) {
                uiPortlet.setHeight(null);
            } else {
                if (!height.endsWith("px")) {
                    height = height.concat("px");
                }
                uiPortlet.setHeight(height);
            }
            pcontext.getJavascriptManager().require("SHARED/portalComposer", "portalComposer").addScripts("portalComposer.toggleSaveButton();");
            UIPortalApplication uiPortalApp = (UIPortalApplication)uiPortlet.getAncestorOfType(UIPortalApplication.class);
            UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)uiPortalApp.getChildById("UIWorkingWorkspace");
            pcontext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
            pcontext.ignoreAJAXUpdateOnPortlets(true);
        }
    }
}

