/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.control.listener;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.portlet.PortletPreferences;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.ext.UIExtensionEventListener;
import org.exoplatform.webui.ext.UIExtensionManager;

public abstract class UIWorkingAreaActionListener<T extends UIComponent>
extends UIExtensionEventListener<T> {
    private static final Log LOG = ExoLogger.getLogger((String)UIWorkingAreaActionListener.class.getName());

    private Node getNodeByPath(String nodePath, UIJCRExplorer uiExplorer, boolean giveTarget) throws Exception {
        nodePath = uiExplorer.getCurrentWorkspace() + ":" + nodePath;
        Matcher matcher = UIWorkingArea.FILE_EXPLORER_URL_SYNTAX.matcher(nodePath);
        String wsName = null;
        if (matcher.find()) {
            wsName = matcher.group(1);
            nodePath = matcher.group(2);
        } else {
            wsName = uiExplorer.getCurrentWorkspace();
        }
        Session session = uiExplorer.getSessionByWorkspace(wsName);
        return uiExplorer.getNodeByPath(nodePath, session, giveTarget);
    }

    private Node getNodeByPath(String nodePath, UIJCRExplorer uiExplorer) throws Exception {
        return this.getNodeByPath(nodePath, uiExplorer, true);
    }

    private boolean inTrash(String nodePath) {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        String trashHomeNodePath = portletPref.getValue("trashHomeNodePath", "");
        if (nodePath.startsWith(trashHomeNodePath)) {
            return true;
        }
        Matcher matcher = UIWorkingArea.FILE_EXPLORER_URL_SYNTAX.matcher(nodePath);
        if (matcher.find()) {
            return matcher.group(2).startsWith(trashHomeNodePath);
        }
        return false;
    }

    public boolean acceptForMultiNode(Event<T> event, String path) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        UIWorkingArea uiWorkingArea = (UIWorkingArea)((UIComponent)event.getSource()).getAncestorOfType(UIWorkingArea.class);
        UIJCRExplorer uiExplorer = (UIJCRExplorer)((UIComponent)event.getSource()).getAncestorOfType(UIJCRExplorer.class);
        WebuiRequestContext requestContext = event.getRequestContext();
        UIApplication uiApp = requestContext.getUIApplication();
        try {
            context.put(UIWorkingArea.class.getName(), (Object)uiWorkingArea);
            context.put(UIJCRExplorer.class.getName(), (Object)uiExplorer);
            context.put(UIApplication.class.getName(), uiApp);
            context.put(Node.class.getName(), this.getNodeByPath(path, uiExplorer));
            context.put(WebuiRequestContext.class.getName(), requestContext);
            UIExtensionManager manager = (UIExtensionManager)((UIComponent)event.getSource()).getApplicationComponent(UIExtensionManager.class);
            return manager.accept(this.getExtensionType(), event.getName(), context);
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"an unexpected error occurs while filter the node", (Throwable)e);
            }
            return false;
        }
    }

    protected Map<String, Object> createContext(Event<T> event) throws Exception {
        HashMap<String, Object> context;
        block4: {
            context = new HashMap<String, Object>();
            UIWorkingArea uiWorkingArea = (UIWorkingArea)((UIComponent)event.getSource()).getAncestorOfType(UIWorkingArea.class);
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((UIComponent)event.getSource()).getAncestorOfType(UIJCRExplorer.class);
            String nodePath = event.getRequestContext().getRequestParameter("objectId");
            if (nodePath == null || nodePath.length() == 0 || nodePath.contains(";")) {
                return null;
            }
            try {
                Node currentNode = this.getNodeByPath(nodePath, uiExplorer, !this.inTrash(nodePath));
                WebuiRequestContext requestContext = event.getRequestContext();
                UIApplication uiApp = requestContext.getUIApplication();
                context.put(UIWorkingArea.class.getName(), (Object)uiWorkingArea);
                context.put(UIJCRExplorer.class.getName(), (Object)uiExplorer);
                context.put(UIApplication.class.getName(), uiApp);
                context.put(Node.class.getName(), currentNode);
                context.put(WebuiRequestContext.class.getName(), requestContext);
            }
            catch (PathNotFoundException pte) {
                throw new MessageException(new ApplicationMessage("UIPopupMenu.msg.path-not-found", null, 1));
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block4;
                LOG.error((Object)"Unexpected problem occurs", (Throwable)e);
            }
        }
        return context;
    }

    public void execute(Event<T> event) throws Exception {
        String nodePath = event.getRequestContext().getRequestParameter("objectId");
        if (nodePath == null || !nodePath.contains(";")) {
            super.execute(event);
            return;
        }
        this.processEvent(event);
    }

    protected String getExtensionType() {
        return "org.exoplatform.ecm.dms.UIWorkingArea";
    }
}

