/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.versions;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.version.Version;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.document.DocumentReaderService;
import org.exoplatform.services.document.diff.AddDelta;
import org.exoplatform.services.document.diff.ChangeDelta;
import org.exoplatform.services.document.diff.DeleteDelta;
import org.exoplatform.services.document.diff.Delta;
import org.exoplatform.services.document.diff.DiffService;
import org.exoplatform.services.document.diff.Revision;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;

@ComponentConfig(template="app:/groovy/webui/component/explorer/versions/UIDiff.gtmpl")
public class UIDiff
extends UIComponent {
    private String baseVersionName_;
    private String baseVersionDate_;
    private String baseVersionWs_;
    private String baseVersionPath_;
    private String versionName_;
    private String versionDate_;
    private String versionWs_;
    private String versionPath_;
    private boolean versionCompareable_ = true;

    public void setVersions(Version baseVersion, Version version) throws Exception {
        this.baseVersionName_ = baseVersion.getName();
        this.baseVersionDate_ = this.formatDate(baseVersion.getCreated());
        this.baseVersionWs_ = baseVersion.getSession().getWorkspace().getName();
        this.baseVersionPath_ = baseVersion.getPath();
        this.versionName_ = version.getName();
        this.versionDate_ = this.formatDate(version.getCreated());
        this.versionWs_ = version.getSession().getWorkspace().getName();
        this.versionPath_ = version.getPath();
    }

    public void setVersions(Version baseVersion, String versionName, Calendar versionCalendar, String versionWs, String versionPath) throws Exception {
        this.baseVersionName_ = baseVersion.getName();
        this.baseVersionDate_ = this.formatDate(baseVersion.getCreated());
        this.baseVersionWs_ = baseVersion.getSession().getWorkspace().getName();
        this.baseVersionPath_ = baseVersion.getPath();
        this.versionName_ = versionName;
        this.versionDate_ = this.formatDate(versionCalendar);
        this.versionWs_ = versionWs;
        this.versionPath_ = versionPath;
    }

    public String getText(Node node) throws Exception {
        Node content;
        if (node.hasNode("jcr:content") && (content = node.getNode("jcr:content")).hasProperty("jcr:mimeType")) {
            String mimeType = content.getProperty("jcr:mimeType").getString();
            if (content.hasProperty("jcr:data")) {
                if (mimeType.startsWith("text")) {
                    return content.getProperty("jcr:data").getString();
                }
                DocumentReaderService readerService = (DocumentReaderService)this.getApplicationComponent(DocumentReaderService.class);
                try {
                    return readerService.getDocumentReader(mimeType).getContentAsText(content.getProperty("jcr:data").getStream());
                }
                catch (Exception e) {
                    this.versionCompareable_ = false;
                }
            }
        }
        return null;
    }

    public String getBaseVersionNum() throws Exception {
        return this.baseVersionName_;
    }

    public String getCurrentVersionNum() throws Exception {
        return this.versionName_;
    }

    public String getBaseVersionDate() throws Exception {
        return this.baseVersionDate_;
    }

    public String getCurrentVersionDate() throws Exception {
        return this.versionDate_;
    }

    private String formatDate(Calendar calendar) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        return dateFormat.format(calendar.getTime());
    }

    public boolean isCompareable() {
        return this.versionCompareable_;
    }

    public List<Delta> getDeltas() throws Exception {
        ArrayList<Delta> deltas = new ArrayList<Delta>();
        String previousText = this.getText(this.getNode(this.versionWs_, this.versionPath_).getNode("jcr:frozenNode"));
        String currentText = this.getText(this.getNode(this.baseVersionWs_, this.baseVersionPath_).getNode("jcr:frozenNode"));
        if (previousText != null && currentText != null) {
            String lineSeparator = DiffService.NL;
            Object[] orig = StringUtils.split((String)previousText, (String)lineSeparator);
            Object[] rev = StringUtils.split((String)currentText, (String)lineSeparator);
            DiffService diffService = (DiffService)this.getApplicationComponent(DiffService.class);
            Revision revision = diffService.diff(orig, rev);
            for (int i = 0; i < revision.size(); ++i) {
                deltas.add(revision.getDelta(i));
            }
        }
        return deltas;
    }

    public boolean isDeleteDelta(Delta delta) {
        return delta instanceof DeleteDelta;
    }

    public boolean isAddDelta(Delta delta) {
        return delta instanceof AddDelta;
    }

    public boolean isChangeDelta(Delta delta) {
        return delta instanceof ChangeDelta;
    }

    private Node getNode(String ws, String path) throws Exception {
        DMSConfiguration dmsConf = (DMSConfiguration)WCMCoreUtils.getService(DMSConfiguration.class);
        String systemWS = dmsConf.getConfig().getSystemWorkspace();
        ManageableRepository repo = WCMCoreUtils.getRepository();
        SessionProvider provider = systemWS.equals(ws) ? WCMCoreUtils.getSystemSessionProvider() : WCMCoreUtils.getUserSessionProvider();
        return (Node)provider.getSession(ws, repo).getItem(path);
    }
}

