/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.jpeg.xmp;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.common.BinaryFileParser;
import org.apache.sanselan.common.byteSources.ByteSource;
import org.apache.sanselan.formats.jpeg.JpegConstants;
import org.apache.sanselan.formats.jpeg.JpegUtils;
import org.apache.sanselan.formats.jpeg.iptc.IPTCParser;

public class JpegRewriter
extends BinaryFileParser
implements JpegConstants {
    private static final int JPEG_BYTE_ORDER = 77;
    private static final SegmentFilter EXIF_SEGMENT_FILTER = new SegmentFilter(){

        public boolean filter(JFIFPieceSegment segment) {
            return segment.isExifSegment();
        }
    };
    private static final SegmentFilter XMP_SEGMENT_FILTER = new SegmentFilter(){

        public boolean filter(JFIFPieceSegment segment) {
            return segment.isXmpSegment();
        }
    };
    private static final SegmentFilter PHOTOSHOP_APP13_SEGMENT_FILTER = new SegmentFilter(){

        public boolean filter(JFIFPieceSegment segment) {
            return segment.isPhotoshopApp13Segment();
        }
    };

    public JpegRewriter() {
        this.setByteOrder(77);
    }

    protected JFIFPieces analyzeJFIF(ByteSource byteSource) throws ImageReadException, IOException {
        final ArrayList pieces = new ArrayList();
        final ArrayList segmentPieces = new ArrayList();
        JpegUtils.Visitor visitor = new JpegUtils.Visitor(){

            public boolean beginSOS() {
                return true;
            }

            public void visitSOS(int marker, byte[] markerBytes, byte[] imageData) {
                pieces.add(new JFIFPieceImageData(markerBytes, imageData));
            }

            public boolean visitSegment(int marker, byte[] markerBytes, int segmentLength, byte[] segmentLengthBytes, byte[] segmentData) throws ImageReadException, IOException {
                JFIFPieceSegment piece = new JFIFPieceSegment(marker, markerBytes, segmentLengthBytes, segmentData);
                pieces.add(piece);
                segmentPieces.add(piece);
                return true;
            }
        };
        new JpegUtils().traverseJFIF(byteSource, visitor);
        return new JFIFPieces(pieces, segmentPieces);
    }

    protected List removeXmpSegments(List segments) {
        return this.filterSegments(segments, XMP_SEGMENT_FILTER);
    }

    protected List removePhotoshopApp13Segments(List segments) {
        return this.filterSegments(segments, PHOTOSHOP_APP13_SEGMENT_FILTER);
    }

    protected List findPhotoshopApp13Segments(List segments) {
        return this.filterSegments(segments, PHOTOSHOP_APP13_SEGMENT_FILTER, true);
    }

    protected List removeExifSegments(List segments) {
        return this.filterSegments(segments, EXIF_SEGMENT_FILTER);
    }

    protected List filterSegments(List segments, SegmentFilter filter) {
        return this.filterSegments(segments, filter, false);
    }

    protected List filterSegments(List segments, SegmentFilter filter, boolean reverse) {
        ArrayList<JFIFPiece> result = new ArrayList<JFIFPiece>();
        for (int i = 0; i < segments.size(); ++i) {
            JFIFPiece piece = (JFIFPiece)segments.get(i);
            if (piece instanceof JFIFPieceSegment) {
                if (!(filter.filter((JFIFPieceSegment)piece) ^ !reverse)) continue;
                result.add(piece);
                continue;
            }
            if (reverse) continue;
            result.add(piece);
        }
        return result;
    }

    protected List insertBeforeFirstAppSegments(List segments, List newSegments) throws ImageWriteException {
        int firstAppIndex = -1;
        for (int i = 0; i < segments.size(); ++i) {
            JFIFPieceSegment segment;
            JFIFPiece piece = (JFIFPiece)segments.get(i);
            if (!(piece instanceof JFIFPieceSegment) || !(segment = (JFIFPieceSegment)piece).isAppSegment() || firstAppIndex != -1) continue;
            firstAppIndex = i;
        }
        ArrayList result = new ArrayList(segments);
        if (firstAppIndex == -1) {
            throw new ImageWriteException("JPEG file has no APP segments.");
        }
        result.addAll(firstAppIndex, newSegments);
        return result;
    }

    protected List insertAfterLastAppSegments(List segments, List newSegments) throws ImageWriteException {
        int lastAppIndex = -1;
        for (int i = 0; i < segments.size(); ++i) {
            JFIFPieceSegment segment;
            JFIFPiece piece = (JFIFPiece)segments.get(i);
            if (!(piece instanceof JFIFPieceSegment) || !(segment = (JFIFPieceSegment)piece).isAppSegment()) continue;
            lastAppIndex = i;
        }
        ArrayList result = new ArrayList(segments);
        if (lastAppIndex == -1) {
            if (segments.size() < 1) {
                throw new ImageWriteException("JPEG file has no APP segments.");
            }
            result.addAll(1, newSegments);
        } else {
            result.addAll(lastAppIndex + 1, newSegments);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeSegments(OutputStream os, List segments) throws ImageWriteException, IOException {
        try {
            os.write(SOI);
            for (int i = 0; i < segments.size(); ++i) {
                JFIFPiece piece = (JFIFPiece)segments.get(i);
                piece.write(os);
            }
            os.close();
            os = null;
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static class JpegSegmentOverflowException
    extends ImageWriteException {
        public JpegSegmentOverflowException(String s) {
            super(s);
        }
    }

    private static interface SegmentFilter {
        public boolean filter(JFIFPieceSegment var1);
    }

    protected static class JFIFPieceImageData
    extends JFIFPiece {
        public final byte[] markerBytes;
        public final byte[] imageData;

        public JFIFPieceImageData(byte[] markerBytes, byte[] imageData) {
            this.markerBytes = markerBytes;
            this.imageData = imageData;
        }

        protected void write(OutputStream os) throws IOException {
            os.write(this.markerBytes);
            os.write(this.imageData);
        }
    }

    protected static class JFIFPieceSegment
    extends JFIFPiece {
        public final int marker;
        public final byte[] markerBytes;
        public final byte[] segmentLengthBytes;
        public final byte[] segmentData;

        public JFIFPieceSegment(int marker, byte[] segmentData) {
            this(marker, JpegRewriter.int2ToByteArray(marker, 77), JpegRewriter.int2ToByteArray(segmentData.length + 2, 77), segmentData);
        }

        public JFIFPieceSegment(int marker, byte[] markerBytes, byte[] segmentLengthBytes, byte[] segmentData) {
            this.marker = marker;
            this.markerBytes = markerBytes;
            this.segmentLengthBytes = segmentLengthBytes;
            this.segmentData = segmentData;
        }

        public String toString() {
            return "[" + this.getClass().getName() + " (0x" + Integer.toHexString(this.marker) + ")]";
        }

        protected void write(OutputStream os) throws IOException {
            os.write(this.markerBytes);
            os.write(this.segmentLengthBytes);
            os.write(this.segmentData);
        }

        public boolean isApp1Segment() {
            return this.marker == 65505;
        }

        public boolean isAppSegment() {
            return this.marker >= 65504 && this.marker <= 65519;
        }

        public boolean isExifSegment() {
            if (this.marker != 65505) {
                return false;
            }
            return BinaryFileParser.byteArrayHasPrefix(this.segmentData, JpegConstants.EXIF_IDENTIFIER_CODE);
        }

        public boolean isPhotoshopApp13Segment() {
            if (this.marker != 65517) {
                return false;
            }
            return new IPTCParser().isPhotoshopJpegSegment(this.segmentData);
        }

        public boolean isXmpSegment() {
            if (this.marker != 65505) {
                return false;
            }
            return BinaryFileParser.byteArrayHasPrefix(this.segmentData, JpegConstants.XMP_IDENTIFIER);
        }
    }

    protected static abstract class JFIFPiece {
        protected JFIFPiece() {
        }

        protected abstract void write(OutputStream var1) throws IOException;

        public String toString() {
            return "[" + this.getClass().getName() + "]";
        }
    }

    protected static class JFIFPieces {
        public final List pieces;
        public final List segmentPieces;

        public JFIFPieces(List pieces, List segmentPieces) {
            this.pieces = pieces;
            this.segmentPieces = segmentPieces;
        }
    }
}

