/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common.xmlprocessor;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exoplatform.social.common.xmlprocessor.model.Node;

public class DOMParser {
    public static final Pattern COMMENTPATTERN = Pattern.compile("<!--.*");
    public static final Pattern TAGSTARTPATTERN = Pattern.compile("<(?i)(\\w+\\b)\\s*(.*)/?>$");
    public static final Pattern TAGCLOSEPATTERN = Pattern.compile("</(?i)(\\w+\\b)\\s*>$");
    public static final Pattern SELFTCLOSETAGPATTERN = Pattern.compile("<.+/\\s*?>");
    public static final Pattern ATTRIBUTESPATTERN = Pattern.compile("(\\w*)\\s*=\\s*(\"([^\"]*)\"|'([^']*)')");

    public static Node createDOMTree(List<String> xmlTokens) {
        return DOMParser.createDOMTree(new Node(), xmlTokens);
    }

    public static Node createDOMTree(Node currentNode, List<String> xmlTokens) {
        for (int i = 0; i < xmlTokens.size(); ++i) {
            Node parsingNode;
            String token = xmlTokens.get(i);
            Matcher startMatcher = TAGSTARTPATTERN.matcher(token);
            Matcher endMatcher = TAGCLOSEPATTERN.matcher(token);
            if (COMMENTPATTERN.matcher(token).find()) {
                parsingNode = new Node();
                parsingNode.setParentNode(currentNode);
                currentNode.addChildNode(parsingNode);
                parsingNode.setTitle(token.substring(4, token.length() - 3));
                continue;
            }
            if (startMatcher.find()) {
                String tag = startMatcher.group(1).toLowerCase();
                if (SELFTCLOSETAGPATTERN.matcher(token).find()) {
                    parsingNode = new Node();
                    parsingNode.setParentNode(currentNode);
                    currentNode.addChildNode(parsingNode);
                    parsingNode.setTitle(tag);
                    String tokenBody = startMatcher.group(2);
                    Matcher attributes = ATTRIBUTESPATTERN.matcher(tokenBody);
                    while (attributes.find()) {
                        String attr = attributes.group(1).toLowerCase();
                        String val = attributes.group(4) == null ? attributes.group(3) : attributes.group(4);
                        parsingNode.addAttribute(attr, val);
                    }
                    continue;
                }
                int findDeep = 0;
                int matchedEnd = 0;
                for (int j = i + 1; j < xmlTokens.size(); ++j) {
                    Matcher startFindMatcher = TAGSTARTPATTERN.matcher(xmlTokens.get(j));
                    Matcher endFindMatcher = TAGCLOSEPATTERN.matcher(xmlTokens.get(j));
                    if (startFindMatcher.find()) {
                        if (SELFTCLOSETAGPATTERN.matcher(xmlTokens.get(j)).find()) continue;
                        ++findDeep;
                        continue;
                    }
                    if (!endFindMatcher.find()) continue;
                    if (endFindMatcher.group(1).toLowerCase().equals(tag) && findDeep == 0) {
                        matchedEnd = j;
                        break;
                    }
                    --findDeep;
                }
                if (matchedEnd > 0) {
                    parsingNode = new Node();
                    parsingNode.setParentNode(currentNode);
                    parsingNode.setTitle(tag);
                    String tokenBody = startMatcher.group(2);
                    Matcher attributes = ATTRIBUTESPATTERN.matcher(tokenBody);
                    while (attributes.find()) {
                        String attr = attributes.group(1).toLowerCase();
                        String val = attributes.group(4) == null ? attributes.group(3) : attributes.group(4);
                        parsingNode.addAttribute(attr, val);
                    }
                    currentNode.addChildNode(parsingNode);
                    DOMParser.createDOMTree(parsingNode, xmlTokens.subList(i + 1, matchedEnd));
                    i = matchedEnd;
                    continue;
                }
                parsingNode = new Node();
                parsingNode.setParentNode(currentNode);
                currentNode.addChildNode(parsingNode);
                parsingNode.setContent(token);
                continue;
            }
            if (endMatcher.find()) {
                parsingNode = new Node();
                parsingNode.setParentNode(currentNode);
                parsingNode.setContent(token);
                currentNode.addChildNode(parsingNode);
                continue;
            }
            parsingNode = new Node();
            parsingNode.setParentNode(currentNode);
            parsingNode.setContent(token);
            currentNode.addChildNode(parsingNode);
        }
        return currentNode;
    }
}

