/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tools {
    private static volatile Map<String, TimeZone> TIME_ZONES = new HashMap<String, TimeZone>();

    public static <E> Set<E> set(E ... elements) throws IllegalArgumentException {
        if (elements == null) {
            throw new IllegalArgumentException("No null element array accepted");
        }
        HashSet<E> set = new HashSet<E>();
        if (elements.length > 0) {
            for (E element : elements) {
                set.add(element);
            }
        }
        return set;
    }

    public static Set<String> parseCommaList(String s) throws IllegalArgumentException {
        if (s == null) {
            throw new IllegalArgumentException("No null string list accepted");
        }
        HashSet<String> set = new HashSet<String>();
        for (String v : s.split(",")) {
            if ((v = v.trim()).length() <= 0) continue;
            set.add(v);
        }
        return set;
    }

    public static Properties asProperties(Map<String, String> map) throws IllegalArgumentException {
        if (map == null) {
            throw new IllegalArgumentException("No null map accepted");
        }
        Properties props = new Properties();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            props.setProperty(entry.getKey(), entry.getValue());
        }
        return props;
    }

    public static Map<String, String> asMap(Properties props) throws IllegalArgumentException {
        if (props == null) {
            throw new IllegalArgumentException("No null properties accepted");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (Object key : props.keySet()) {
            Object value = props.get(key);
            if (!(key instanceof String) || !(value instanceof String)) continue;
            map.put((String)key, (String)value);
        }
        return map;
    }

    public static boolean endsWithIgnoreCase(String s, String end) throws IllegalArgumentException {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        if (end == null) {
            throw new IllegalArgumentException();
        }
        if (s.length() < end.length()) {
            return false;
        }
        String suffix = s.substring(s.length() - end.length());
        return suffix.equalsIgnoreCase(end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TimeZone getTimeZone(String ID) {
        if (ID == null) {
            throw new IllegalArgumentException("ID of the timezone cannot be null");
        }
        if (ID.length() == 0) {
            throw new IllegalArgumentException("ID of the timezone cannot be empty");
        }
        TimeZone tz = TIME_ZONES.get(ID);
        if (tz != null) return tz;
        Class<TimeZone> clazz = TimeZone.class;
        synchronized (TimeZone.class) {
            tz = TIME_ZONES.get(ID);
            if (tz != null) return tz;
            tz = TimeZone.getTimeZone(ID);
            HashMap<String, TimeZone> tzs = new HashMap<String, TimeZone>(TIME_ZONES);
            tzs.put(ID, tz);
            TIME_ZONES = tzs;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return tz;
        }
    }
}

