/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.management.rest.providers;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.gatein.management.rest.content.Child;
import org.gatein.management.rest.content.Link;
import org.gatein.management.rest.content.Operation;
import org.gatein.management.rest.content.Resource;
import org.json.JSONException;
import org.json.JSONWriter;

@Provider
@Produces(value={"application/json"})
public class JsonResourceProvider
implements MessageBodyWriter<Resource> {
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Resource.class.isAssignableFrom(type);
    }

    public long getSize(Resource resource, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Resource resource, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        PrintWriter printWriter = new PrintWriter(entityStream);
        try {
            JSONWriter writer = new JSONWriter((Writer)printWriter);
            writer.object().key("description").value((Object)resource.getDescription());
            writer.key("children").array();
            for (Child child : resource.getChildren()) {
                this.writeChild(child, writer);
            }
            writer.endArray();
            if (resource.getOperations() != null) {
                writer.key("operations").array();
                for (Operation operation : resource.getOperations()) {
                    this.writeOperation(operation, writer);
                }
                writer.endArray();
            }
            writer.endObject();
            printWriter.flush();
        }
        catch (JSONException e) {
            throw new IOException("Exception writing json result.", e);
        }
        finally {
            printWriter.close();
        }
    }

    private void writeOperation(Operation operation, JSONWriter writer) throws IOException, JSONException {
        writer.object().key("operation-name").value((Object)operation.getOperationName());
        writer.key("operation-description").value((Object)operation.getOperationDescription());
        this.writeLink("link", operation.getOperationLink(), writer);
        writer.endObject();
    }

    private void writeChild(Child child, JSONWriter writer) throws IOException, JSONException {
        writer.object().key("name").value((Object)child.getName());
        writer.key("description").value((Object)child.getDescription());
        this.writeLink("link", child.getLink(), writer);
        writer.endObject();
    }

    private void writeLink(String name, Link link, JSONWriter writer) throws IOException, JSONException {
        writer.key(name).object();
        if (link.getRel() != null) {
            writer.key("rel").value((Object)link.getRel());
        }
        writer.key("href").value((Object)link.getHref());
        if (link.getType() != null) {
            writer.key("type").value((Object)link.getType());
        }
        if (link.getMethod() != null) {
            writer.key("method").value((Object)link.getMethod());
        }
        writer.endObject();
    }
}

