/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.upgrade.activities;

import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.query.QueryResult;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ActivitiesUpgradePlugin
extends UpgradeProductPlugin {
    private Log log = ExoLogger.getLogger(((Object)((Object)this)).getClass());
    private RepositoryService repoService_;

    public ActivitiesUpgradePlugin(RepositoryService repoService, InitParams initParams) {
        super(initParams);
        this.repoService_ = repoService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Start " + ((Object)((Object)this)).getClass().getName() + "............."));
        }
        SessionProvider sessionProvider = null;
        try {
            sessionProvider = SessionProvider.createSystemProvider();
            Session session = sessionProvider.getSession("social", this.repoService_.getCurrentRepository());
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)"=====Start migrate data for all activities=====");
            }
            String statement = "SELECT * FROM soc:activity WHERE soc:type = 'contents:spaces'";
            QueryResult result = session.getWorkspace().getQueryManager().createQuery(statement, "sql").execute();
            NodeIterator nodeIter = result.getNodes();
            while (nodeIter.hasNext()) {
                Node node;
                Node viewNode = nodeIter.nextNode();
                Node paramsNode = viewNode.getNode("soc:params");
                String workspace = paramsNode.getProperty("workspace").getString();
                String nodeUUID = paramsNode.getProperty("id").getString();
                Session session2 = sessionProvider.getSession(workspace, this.repoService_.getCurrentRepository());
                try {
                    String nodeUrl = viewNode.getProperty("soc:url").getString();
                    node = (Node)session2.getItem(nodeUrl);
                    if (!node.isNodeType("nt:file")) continue;
                    viewNode.setProperty("soc:type", "files:spaces");
                }
                catch (PathNotFoundException ex) {
                    try {
                        node = session2.getNodeByUUID(nodeUUID);
                        if (!node.isNodeType("nt:file")) continue;
                        if (Utils.isInTrash((Node)node)) {
                            this.removeActivityReferences(viewNode);
                            viewNode.remove();
                            continue;
                        }
                        viewNode.setProperty("soc:type", "files:spaces");
                        viewNode.setProperty("soc:url", node.getPath());
                    }
                    catch (ItemNotFoundException ix) {}
                }
            }
            session.save();
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)"=====Completed the migration data for all activities=====");
            }
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"An unexpected error occurs when migrating activities: ", (Throwable)e);
            }
        }
        finally {
            if (sessionProvider != null) {
                sessionProvider.close();
            }
        }
    }

    private void removeActivityReferences(Node activity) throws Exception {
        String statement = "SELECT * FROM soc:activityref WHERE soc:target = '" + activity.getUUID() + "'";
        QueryResult result = activity.getSession().getWorkspace().getQueryManager().createQuery(statement, "sql").execute();
        NodeIterator nodeIter = result.getNodes();
        while (nodeIter.hasNext()) {
            Node activityRef = nodeIter.nextNode();
            this.updateActivityNumber(activityRef);
            activityRef.remove();
        }
    }

    private void updateActivityNumber(Node activityRef) throws Exception {
        Long currentNumber;
        Node activityRefList = activityRef.getParent().getParent().getParent().getParent();
        if (activityRefList.hasProperty("soc:number") && (currentNumber = Long.valueOf(activityRefList.getProperty("soc:number").getValue().getLong())) > 0L) {
            activityRefList.setProperty("soc:number", currentNumber - 1L);
        }
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return VersionComparator.isAfter((String)newVersion, (String)previousVersion);
    }
}

