/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AbstractPeepholeOptimization;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.Node;

class PeepholeOptimizationsPass
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    private AbstractCompiler compiler;
    private final AbstractPeepholeOptimization[] peepholeOptimizations;

    PeepholeOptimizationsPass(AbstractCompiler compiler, AbstractPeepholeOptimization ... optimizations) {
        this.compiler = compiler;
        this.peepholeOptimizations = optimizations;
    }

    public AbstractCompiler getCompiler() {
        return this.compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal t = new NodeTraversal(this.compiler, this);
        this.beginTraversal(t);
        t.traverse(root);
        this.endTraversal(t);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        Node currentVersionOfNode = n;
        boolean somethingChanged = false;
        do {
            somethingChanged = false;
            for (AbstractPeepholeOptimization optimization : this.peepholeOptimizations) {
                Node newVersionOfNode = optimization.optimizeSubtree(currentVersionOfNode);
                if (newVersionOfNode != currentVersionOfNode) {
                    somethingChanged = true;
                    currentVersionOfNode = newVersionOfNode;
                }
                if (currentVersionOfNode != null) continue;
                return;
            }
        } while (somethingChanged);
    }

    private void beginTraversal(NodeTraversal t) {
        for (AbstractPeepholeOptimization optimization : this.peepholeOptimizations) {
            optimization.beginTraversal(t);
        }
    }

    private void endTraversal(NodeTraversal t) {
        for (AbstractPeepholeOptimization optimization : this.peepholeOptimizations) {
            optimization.endTraversal(t);
        }
    }
}

