/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.cache;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupEventListener;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.cache.MembershipCacheKey;
import org.exoplatform.services.organization.cache.OrganizationCacheHandler;

public class CacheableGroupHandlerImpl
implements GroupHandler {
    private final ExoCache<String, Object> groupCache;
    private final ExoCache membershipCache;
    private final GroupHandler groupHandler;

    public CacheableGroupHandlerImpl(OrganizationCacheHandler organizationCacheHandler, GroupHandler handler) {
        this.groupCache = organizationCacheHandler.getGroupCache();
        this.membershipCache = organizationCacheHandler.getMembershipCache();
        this.groupHandler = handler;
    }

    public void addChild(Group parent, Group child, boolean broadcast) throws Exception {
        this.groupHandler.addChild(parent, child, broadcast);
    }

    public void addGroupEventListener(GroupEventListener listener) {
        this.groupHandler.addGroupEventListener(listener);
    }

    public void removeGroupEventListener(GroupEventListener listener) {
        this.groupHandler.removeGroupEventListener(listener);
    }

    public void createGroup(Group group, boolean broadcast) throws Exception {
        this.groupHandler.createGroup(group, broadcast);
    }

    public Group createGroupInstance() {
        return this.groupHandler.createGroupInstance();
    }

    public Group findGroupById(String groupId) throws Exception {
        Group group = (Group)this.groupCache.get((Serializable)((Object)groupId));
        if (group != null) {
            return group;
        }
        group = this.groupHandler.findGroupById(groupId);
        if (group != null) {
            this.groupCache.put((Serializable)((Object)groupId), (Object)group);
        }
        return group;
    }

    public Collection findGroupByMembership(String userName, String membershipType) throws Exception {
        Collection groups = this.groupHandler.findGroupByMembership(userName, membershipType);
        for (Group group : groups) {
            this.groupCache.put((Serializable)((Object)group.getId()), (Object)groups);
        }
        return groups;
    }

    public Collection findGroups(Group parent) throws Exception {
        Collection groups = this.groupHandler.findGroups(parent);
        for (Group group : groups) {
            this.groupCache.put((Serializable)((Object)group.getId()), (Object)groups);
        }
        return groups;
    }

    public Collection findGroupsOfUser(String user) throws Exception {
        Collection groups = this.groupHandler.findGroupsOfUser(user);
        for (Group group : groups) {
            this.groupCache.put((Serializable)((Object)group.getId()), (Object)groups);
        }
        return groups;
    }

    public Collection getAllGroups() throws Exception {
        Collection groups = this.groupHandler.getAllGroups();
        for (Group group : groups) {
            this.groupCache.put((Serializable)((Object)group.getId()), (Object)groups);
        }
        return groups;
    }

    public Group removeGroup(Group group, boolean broadcast) throws Exception {
        Group gr = this.groupHandler.removeGroup(group, broadcast);
        if (gr != null) {
            this.groupCache.remove((Serializable)((Object)gr.getId()));
            List memberships = this.membershipCache.getCachedObjects();
            for (Membership membership : memberships) {
                if (!membership.getGroupId().equals(gr.getId())) continue;
                this.membershipCache.remove((Serializable)((Object)membership.getId()));
                this.membershipCache.remove((Serializable)new MembershipCacheKey(membership));
            }
        }
        return gr;
    }

    public void saveGroup(Group group, boolean broadcast) throws Exception {
        this.groupHandler.saveGroup(group, broadcast);
        this.groupCache.put((Serializable)((Object)group.getId()), (Object)group);
    }
}

