/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.jdbc.listeners;

import java.util.List;
import org.exoplatform.services.database.DBObjectQuery;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.jdbc.MembershipDAOImpl;
import org.exoplatform.services.organization.jdbc.MembershipImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveMembershipListener
extends Listener<Object, Object> {
    private OrganizationService service_;
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.core.component.organization.jdbc.RemoveMembershipListener");

    public RemoveMembershipListener(OrganizationService service) {
        this.service_ = service;
    }

    public void onEvent(Event<Object, Object> event) throws Exception {
        block6: {
            Object target;
            block7: {
                MembershipHandler membershipHanler;
                block5: {
                    target = event.getData();
                    membershipHanler = this.service_.getMembershipHandler();
                    if (!(target instanceof User)) break block5;
                    User user = (User)target;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Remove all Membership by User: " + user.getUserName()));
                    }
                    membershipHanler.removeMembershipByUser(user.getUserName(), true);
                    break block6;
                }
                if (!(target instanceof Group)) break block7;
                Group group = (Group)target;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Remove all Membership by Group: " + group.getGroupName()));
                }
                List members = (List)membershipHanler.findMembershipsByGroup(group);
                for (Membership member : members) {
                    membershipHanler.removeMembership(member.getId(), true);
                }
                break block6;
            }
            if (!(target instanceof MembershipType)) break block6;
            try {
                MembershipType memberType = (MembershipType)target;
                MembershipDAOImpl mtHandler = (MembershipDAOImpl)this.service_.getMembershipHandler();
                DBObjectQuery query = new DBObjectQuery(MembershipImpl.class);
                query.addEQ("MEMBERSHIP_TYPE", (Object)memberType.getName());
                mtHandler.removeMemberships((DBObjectQuery<MembershipImpl>)query, true);
            }
            catch (Exception e) {
                LOG.error((Object)"Error while removing a Membership", (Throwable)e);
            }
        }
    }
}

