/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.connector.collaboration;

import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.jcr.Node;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import org.exoplatform.services.cms.comments.CommentsService;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.wcm.portal.PortalFolderSchemaHandler;
import org.exoplatform.services.wcm.webcontent.WebContentSchemaHandler;
import org.exoplatform.wcm.connector.BaseConnector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Path(value="/contents/comment/")
public class CommentConnector
extends BaseConnector
implements ResourceContainer {
    CommentsService commentsService;

    public CommentConnector(CommentsService commentsService) {
        this.commentsService = commentsService;
    }

    @POST
    @Path(value="/add")
    public Response addComment(@FormParam(value="jcrPath") String jcrPath, @FormParam(value="comment") String comment) throws Exception {
        if (jcrPath.contains("%20")) {
            jcrPath = URLDecoder.decode(jcrPath, "UTF-8");
        }
        String[] path = jcrPath.split("/");
        String repositoryName = path[1];
        String workspaceName = path[2];
        if ((jcrPath = jcrPath.substring(repositoryName.length() + workspaceName.length() + 2)).charAt(1) == '/') {
            jcrPath.substring(1);
        }
        Node content = this.getContent(workspaceName, jcrPath, null, false);
        this.commentsService.addComment(content, content.getSession().getUserID(), null, null, comment, null);
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
        return Response.ok().header("Last-Modified", (Object)dateFormat.format(new Date())).build();
    }

    @GET
    @Path(value="/all")
    public Response getComments(@QueryParam(value="jcrPath") String jcrPath) throws Exception {
        if (jcrPath.contains("%20")) {
            jcrPath = URLDecoder.decode(jcrPath, "UTF-8");
        }
        String[] path = jcrPath.split("/");
        String repositoryName = path[1];
        String workspaceName = path[2];
        if ((jcrPath = jcrPath.substring(repositoryName.length() + workspaceName.length() + 2)).charAt(1) == '/') {
            jcrPath.substring(1);
        }
        try {
            Node content = this.getContent(workspaceName, jcrPath, null, false);
            List comments = this.commentsService.getComments(content, null);
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element tagsElt = document.createElement("comments");
            for (Node comment : comments) {
                Element tagElt = document.createElement("comment");
                Element commentor = document.createElement("commentor");
                commentor.setTextContent(comment.getProperty("exo:commentor").getString());
                Element commentorEmail = document.createElement("email");
                if (comment.hasProperty("exo:commentorEmail")) {
                    commentorEmail.setTextContent(comment.getProperty("exo:commentorEmail").getString());
                }
                Element date = document.createElement("date");
                date.setTextContent(comment.getProperty("exo:commentDate").getDate().getTime().toLocaleString());
                Element commentElt = document.createElement("content");
                commentElt.setTextContent(comment.getProperty("exo:commentContent").getString());
                tagElt.appendChild(commentor);
                tagElt.appendChild(commentorEmail);
                tagElt.appendChild(date);
                tagElt.appendChild(commentElt);
                tagsElt.appendChild(tagElt);
            }
            document.appendChild(tagsElt);
            SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
            return Response.ok((Object)new DOMSource(document), (String)"text/xml").header("Last-Modified", (Object)dateFormat.format(new Date())).build();
        }
        catch (Exception e) {
            Response.serverError().build();
            SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
            return Response.ok().header("Last-Modified", (Object)dateFormat.format(new Date())).build();
        }
    }

    @Override
    protected Node getRootContentStorage(Node parentNode) throws Exception {
        try {
            PortalFolderSchemaHandler folderSchemaHandler = (PortalFolderSchemaHandler)this.webSchemaConfigService.getWebSchemaHandlerByType(PortalFolderSchemaHandler.class);
            return folderSchemaHandler.getDocumentStorage(parentNode);
        }
        catch (Exception e) {
            WebContentSchemaHandler webContentSchemaHandler = (WebContentSchemaHandler)this.webSchemaConfigService.getWebSchemaHandlerByType(WebContentSchemaHandler.class);
            return webContentSchemaHandler.getDocumentFolder(parentNode);
        }
    }

    @Override
    protected String getContentStorageType() throws Exception {
        return "file";
    }
}

