/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.regex.Pattern;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllTests {
    private static FilenameFilter testClassFilter = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            File test = new File(dir, name);
            return !name.startsWith(".svn") && (test.isDirectory() || name.endsWith("Test.java"));
        }
    };

    public static Test suite() throws IOException, ClassNotFoundException {
        TestSuite suite = new TestSuite("Caja Tests");
        File testRoot = new File("tests");
        int nTests = AllTests.findAllTests(suite, testRoot);
        if (nTests == 0) {
            throw new AssertionFailedError("Found no tests");
        }
        return suite;
    }

    private static Class<? extends TestCase> mapToTestClass(String className) throws ClassNotFoundException {
        return Class.forName(className).asSubclass(TestCase.class);
    }

    private static int findAllTests(TestSuite ts, File ... roots) throws IOException, ClassNotFoundException {
        int count = 0;
        for (File root : roots) {
            for (File child : root.listFiles(testClassFilter)) {
                count += AllTests.findAllTests(ts, child, null);
            }
        }
        return count;
    }

    private static int findAllTests(TestSuite ts, File root, String classpath) throws IOException, ClassNotFoundException {
        if (root.isDirectory()) {
            int count = 0;
            for (File child : root.listFiles(testClassFilter)) {
                count += AllTests.findAllTests(ts, child, (classpath != null ? classpath + "." : "") + root.getName());
            }
            return count;
        }
        String className = classpath + "." + root.getName().replaceFirst("[.]java$", "");
        Class<? extends TestCase> testCase = AllTests.mapToTestClass(className);
        Pattern testFilter = Pattern.compile("(?:" + AllTests.globToPattern(System.getProperty("test.filter", "*")) + ")$", 32);
        if (testCase != null && testFilter.matcher(testCase.getName()).find()) {
            ts.addTestSuite(testCase);
        }
        return 1;
    }

    private static String globToPattern(String glob) {
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        int n = glob.length();
        for (int i = 0; i < n; ++i) {
            char ch = glob.charAt(i);
            if (ch == '*') {
                sb.append(Pattern.quote(glob.substring(pos, i)));
                pos = i + 1;
                if (pos < n && '*' == glob.charAt(pos)) {
                    ++pos;
                    sb.append(".*");
                    continue;
                }
                sb.append("[^.]*");
                continue;
            }
            if (ch != '?') continue;
            sb.append(Pattern.quote(glob.substring(pos, i))).append('.');
            pos = i + 1;
        }
        sb.append(Pattern.quote(glob.substring(pos)));
        return sb.toString();
    }
}

