/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.listeners;

import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.storage.api.IdentityStorage;

public class SocialUserEventListenerImpl
extends UserEventListener {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preSave(User user, boolean isNew) throws Exception {
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        try {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            IdentityStorage ids = (IdentityStorage)container.getComponentInstanceOfType(IdentityStorage.class);
            Identity identity = ids.findIdentity("organization", user.getUserName());
            if (isNew && identity != null) {
                throw new RuntimeException("Unable to create a previously deleted user : " + user.getUserName());
            }
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postSave(User user, boolean isNew) throws Exception {
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        try {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            IdentityManager idm = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
            Identity identity = idm.getOrCreateIdentity("organization", user.getUserName(), true);
            Profile profile = identity.getProfile();
            boolean hasUpdated = false;
            if (!isNew) {
                String uFirstName = user.getFirstName();
                String uLastName = user.getLastName();
                String uFullName = user.getFullName();
                String uEmail = user.getEmail();
                String pFirstName = (String)profile.getProperty("firstName");
                String pLastName = (String)profile.getProperty("lastName");
                String pEmail = (String)profile.getProperty("email");
                if (pFirstName == null || !pFirstName.equals(uFirstName)) {
                    profile.setProperty("firstName", uFirstName);
                    profile.setProperty("fullName", uFullName);
                    hasUpdated = true;
                }
                if (pLastName == null || !pLastName.equals(uLastName)) {
                    profile.setProperty("lastName", uLastName);
                    profile.setProperty("fullName", uFullName);
                    hasUpdated = true;
                }
                if (pEmail == null || !pEmail.equals(uEmail)) {
                    profile.setProperty("email", uEmail);
                    hasUpdated = true;
                }
            }
            if (hasUpdated) {
                idm.updateProfile(profile);
            }
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preDelete(User user) throws Exception {
        RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
        try {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            IdentityManager idm = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
            Identity identity = idm.getOrCreateIdentity("organization", user.getUserName(), true);
            try {
                idm.hardDeleteIdentity(identity);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        finally {
            RequestLifeCycle.end();
        }
    }
}

