/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage.synchronization;

import java.util.List;
import java.util.Map;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.storage.RelationshipStorageException;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.storage.impl.RelationshipStorageImpl;

public class SynchronizedRelationshipStorage
extends RelationshipStorageImpl {
    public SynchronizedRelationshipStorage(IdentityStorage identityStorage) {
        super(identityStorage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Relationship saveRelationship(Relationship relationship) throws RelationshipStorageException {
        boolean created = SynchronizedRelationshipStorage.startSynchronization();
        try {
            Relationship relationship2 = super.saveRelationship(relationship);
            return relationship2;
        }
        finally {
            SynchronizedRelationshipStorage.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRelationship(Relationship relationship) throws RelationshipStorageException {
        boolean created = SynchronizedRelationshipStorage.startSynchronization();
        try {
            super.removeRelationship(relationship);
        }
        finally {
            SynchronizedRelationshipStorage.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Relationship getRelationship(String uuid) throws RelationshipStorageException {
        boolean created = SynchronizedRelationshipStorage.startSynchronization();
        try {
            Relationship relationship = super.getRelationship(uuid);
            return relationship;
        }
        finally {
            SynchronizedRelationshipStorage.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Relationship> getSenderRelationships(Identity sender, Relationship.Type type, List<Identity> listCheckIdentity) throws RelationshipStorageException {
        boolean created = SynchronizedRelationshipStorage.startSynchronization();
        try {
            List<Relationship> list = super.getSenderRelationships(sender, type, listCheckIdentity);
            return list;
        }
        finally {
            SynchronizedRelationshipStorage.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Relationship> getSenderRelationships(String senderId, Relationship.Type type, List<Identity> listCheckIdentity) throws RelationshipStorageException {
        boolean created = SynchronizedRelationshipStorage.startSynchronization();
        try {
            List<Relationship> list = super.getSenderRelationships(senderId, type, listCheckIdentity);
            return list;
        }
        finally {
            SynchronizedRelationshipStorage.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Relationship> getReceiverRelationships(Identity receiver, Relationship.Type type, List<Identity> listCheckIdentity) throws RelationshipStorageException {
        boolean created = SynchronizedRelationshipStorage.startSynchronization();
        try {
            List<Relationship> list = super.getReceiverRelationships(receiver, type, listCheckIdentity);
            return list;
        }
        finally {
            SynchronizedRelationshipStorage.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Relationship getRelationship(Identity identity1, Identity identity2) throws RelationshipStorageException {
        boolean created = SynchronizedRelationshipStorage.startSynchronization();
        try {
            Relationship relationship = super.getRelationship(identity1, identity2);
            return relationship;
        }
        finally {
            SynchronizedRelationshipStorage.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Relationship> getRelationships(Identity identity, Relationship.Type type, List<Identity> listCheckIdentity) throws RelationshipStorageException {
        boolean created = SynchronizedRelationshipStorage.startSynchronization();
        try {
            List<Relationship> list = super.getRelationships(identity, type, listCheckIdentity);
            return list;
        }
        finally {
            SynchronizedRelationshipStorage.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Identity> getRelationships(Identity identity, long offset, long limit) throws RelationshipStorageException {
        boolean created = SynchronizedRelationshipStorage.startSynchronization();
        try {
            List<Identity> list = super.getRelationships(identity, offset, limit);
            return list;
        }
        finally {
            SynchronizedRelationshipStorage.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Identity> getIncomingRelationships(Identity receiver, long offset, long limit) throws RelationshipStorageException {
        boolean created = SynchronizedRelationshipStorage.startSynchronization();
        try {
            List<Identity> list = super.getIncomingRelationships(receiver, offset, limit);
            return list;
        }
        finally {
            SynchronizedRelationshipStorage.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getIncomingRelationshipsCount(Identity receiver) throws RelationshipStorageException {
        boolean created = SynchronizedRelationshipStorage.startSynchronization();
        try {
            int n = super.getIncomingRelationshipsCount(receiver);
            return n;
        }
        finally {
            SynchronizedRelationshipStorage.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Identity> getOutgoingRelationships(Identity sender, long offset, long limit) throws RelationshipStorageException {
        boolean created = SynchronizedRelationshipStorage.startSynchronization();
        try {
            List<Identity> list = super.getOutgoingRelationships(sender, offset, limit);
            return list;
        }
        finally {
            SynchronizedRelationshipStorage.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOutgoingRelationshipsCount(Identity sender) throws RelationshipStorageException {
        boolean created = SynchronizedRelationshipStorage.startSynchronization();
        try {
            int n = super.getOutgoingRelationshipsCount(sender);
            return n;
        }
        finally {
            SynchronizedRelationshipStorage.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRelationshipsCount(Identity identity) throws RelationshipStorageException {
        boolean created = SynchronizedRelationshipStorage.startSynchronization();
        try {
            int n = super.getRelationshipsCount(identity);
            return n;
        }
        finally {
            SynchronizedRelationshipStorage.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Identity> getConnections(Identity identity, long offset, long limit) throws RelationshipStorageException {
        boolean created = SynchronizedRelationshipStorage.startSynchronization();
        try {
            List<Identity> list = super.getConnections(identity, offset, limit);
            return list;
        }
        finally {
            SynchronizedRelationshipStorage.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getConnectionsCount(Identity identity) throws RelationshipStorageException {
        boolean created = SynchronizedRelationshipStorage.startSynchronization();
        try {
            int n = super.getConnectionsCount(identity);
            return n;
        }
        finally {
            SynchronizedRelationshipStorage.stopSynchronization(created);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Identity, Integer> getSuggestions(Identity identity, int offset, int limit) throws RelationshipStorageException {
        boolean created = SynchronizedRelationshipStorage.startSynchronization();
        try {
            Map<Identity, Integer> map = super.getSuggestions(identity, offset, limit);
            return map;
        }
        finally {
            SynchronizedRelationshipStorage.stopSynchronization(created);
        }
    }
}

