/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.admin;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.popup.admin.UIRelationManager;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.services.cms.relations.RelationsService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.exception.MessageException;

@ComponentConfig(lifecycle=UIContainerLifecycle.class, events={@EventConfig(listeners={DeleteActionListener.class}, confirm="UIRelationsAddedList.msg.confirm-delete")})
public class UIRelationsAddedList
extends UIContainer
implements UISelectable {
    private static final Log LOG = ExoLogger.getLogger((String)UIRelationsAddedList.class.getName());
    private static String[] RELATE_BEAN_FIELD = new String[]{"path"};
    private static String[] ACTION = new String[]{"Delete"};

    public UIRelationsAddedList() throws Exception {
        UIGrid uiGrid = (UIGrid)this.addChild(UIGrid.class, null, "RelateAddedList");
        uiGrid.setDisplayedChars(150);
        uiGrid.getUIPageIterator().setId("RelateListIterator");
        uiGrid.configure("path", RELATE_BEAN_FIELD, ACTION);
    }

    public void updateGrid(List<Node> nodes, int currentPage) throws Exception {
        UIGrid uiGrid = (UIGrid)this.getChildById("RelateAddedList");
        if (nodes == null) {
            nodes = new ArrayList<Node>();
        }
        ListAccessImpl nodeList = new ListAccessImpl(Node.class, nodes);
        LazyPageList objPageList = new LazyPageList((ListAccess)nodeList, 10);
        uiGrid.getUIPageIterator().setPageList((PageList)objPageList);
        if (currentPage > uiGrid.getUIPageIterator().getAvailablePage()) {
            uiGrid.getUIPageIterator().setCurrentPage(uiGrid.getUIPageIterator().getAvailablePage());
        } else {
            uiGrid.getUIPageIterator().setCurrentPage(currentPage);
        }
    }

    public void doSelect(String selectField, Object value) throws Exception {
        block3: {
            UIJCRExplorer uiJCRExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
            RelationsService relateService = (RelationsService)this.getApplicationComponent(RelationsService.class);
            String currentFullPath = uiJCRExplorer.getCurrentWorkspace() + ":" + uiJCRExplorer.getCurrentNode().getPath();
            if (value.equals(currentFullPath)) {
                throw new MessageException(new ApplicationMessage("UIRelationsAddedList.msg.can-not-add-itself", null, 1));
            }
            try {
                String wsName = value.toString().substring(0, value.toString().indexOf(":"));
                String path = value.toString().substring(value.toString().indexOf(":") + 1);
                Node currentNode = uiJCRExplorer.getCurrentNode();
                uiJCRExplorer.addLockToken(currentNode);
                relateService.addRelation(currentNode, path, wsName);
                this.updateGrid(relateService.getRelations(currentNode, WCMCoreUtils.getUserSessionProvider()), 1);
                this.setRenderSibling(UIRelationsAddedList.class);
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error((Object)"Unexpected error", (Throwable)e);
            }
        }
    }

    public static class DeleteActionListener
    extends EventListener<UIRelationsAddedList> {
        public void execute(Event<UIRelationsAddedList> event) throws Exception {
            UIRelationsAddedList uiAddedList = (UIRelationsAddedList)((Object)event.getSource());
            UIRelationManager uiManager = (UIRelationManager)uiAddedList.getParent();
            UIApplication uiApp = (UIApplication)uiAddedList.getAncestorOfType(UIApplication.class);
            String nodePath = event.getRequestContext().getRequestParameter("objectId");
            RelationsService relationService = (RelationsService)uiAddedList.getApplicationComponent(RelationsService.class);
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiAddedList.getAncestorOfType(UIJCRExplorer.class);
            Node currentNode = uiExplorer.getCurrentNode();
            uiExplorer.addLockToken(currentNode);
            try {
                relationService.removeRelation(uiExplorer.getCurrentNode(), nodePath);
                UIGrid uiGrid = (UIGrid)uiAddedList.getChildById("RelateAddedList");
                uiAddedList.updateGrid(relationService.getRelations(uiExplorer.getCurrentNode(), WCMCoreUtils.getUserSessionProvider()), uiGrid.getUIPageIterator().getCurrentPage());
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            }
            uiManager.setRenderedChild("UIRelationsAddedList");
        }
    }
}

