/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form.validator;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.exoplatform.commons.serialization.api.annotations.Serialized;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.AbstractApplicationMessage;
import org.exoplatform.web.application.CompoundApplicationMessage;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.validator.MultipleConditionsValidator;
import org.exoplatform.webui.form.validator.UsernameValidator;

@Serialized
public class UserConfigurableValidator
extends MultipleConditionsValidator {
    protected static Log log = ExoLogger.getLogger(UserConfigurableValidator.class);
    public static final String USERNAME = "username";
    public static final String GROUPMEMBERSHIP = "groupmembership";
    public static final String DEFAULT_LOCALIZATION_KEY = "ExpressionValidator.msg.value-invalid";
    public static final String GROUP_MEMBERSHIP_VALIDATION_REGEX = "^(\\p{Lower}[\\p{Lower}\\d\\._]+)(\\s*,\\s*(\\p{Lower}[\\p{Lower}\\d\\._]+))*$";
    public static final String GROUP_MEMBERSHIP_LOCALIZATION_KEY = "UIGroupMembershipForm.msg.Invalid-char";
    private static Map<String, ValidatorConfiguration> configurations = new HashMap<String, ValidatorConfiguration>(3);
    public static final String KEY_PREFIX = "gatein.validators.";
    private final String validatorName;
    private final String localizationKey;

    public UserConfigurableValidator() {
        this(USERNAME, DEFAULT_LOCALIZATION_KEY);
    }

    public UserConfigurableValidator(String configurationName, String messageLocalizationKey) {
        this(configurationName, messageLocalizationKey, true);
    }

    public UserConfigurableValidator(String configurationName, String messageLocalizationKey, Boolean exceptionOnMissingMandatory) {
        this.exceptionOnMissingMandatory = exceptionOnMissingMandatory;
        this.trimValue = true;
        this.localizationKey = messageLocalizationKey != null ? messageLocalizationKey : DEFAULT_LOCALIZATION_KEY;
        this.validatorName = configurationName != null ? configurationName : USERNAME;
    }

    public UserConfigurableValidator(String configurationName) {
        this(configurationName, DEFAULT_LOCALIZATION_KEY);
    }

    @Override
    public void validate(UIFormInput uiInput) throws Exception {
        if (this.exceptionOnMissingMandatory) {
            super.validate(uiInput);
        } else {
            String label = this.getLabelFor(uiInput);
            CompoundApplicationMessage messages = new CompoundApplicationMessage();
            this.validate((String)uiInput.getValue(), label, messages, uiInput);
            if (!messages.isEmpty()) {
                throw new MessageException((AbstractApplicationMessage)messages);
            }
        }
    }

    @Override
    protected void validate(String value, String label, CompoundApplicationMessage messages, UIFormInput uiInput) {
        ValidatorConfiguration configuration = configurations.get(this.validatorName);
        if (value == null) {
            value = "";
        }
        if (configuration == null) {
            if (USERNAME.equals(this.validatorName)) {
                UsernameValidator.validate(value, label, messages, 3, 30);
            } else if (GROUPMEMBERSHIP.equals(this.validatorName) && !Pattern.matches(GROUP_MEMBERSHIP_VALIDATION_REGEX, value)) {
                messages.addMessage(this.localizationKey, new Object[]{label});
            }
        } else {
            if (value.length() < configuration.minLength || value.length() > configuration.maxLength) {
                messages.addMessage("StringLengthValidator.msg.length-invalid", new Object[]{label, configuration.minLength.toString(), configuration.maxLength.toString()});
            }
            if (!Pattern.matches(configuration.pattern, value)) {
                messages.addMessage(this.localizationKey, new Object[]{label, configuration.formatMessage});
            }
        }
    }

    static {
        String gateinConfDir = System.getProperty("gatein.conf.dir");
        File conf = new File(gateinConfDir, "configuration.properties");
        if (conf.exists()) {
            try {
                Properties properties = new Properties();
                properties.load(new FileInputStream(conf));
                int length = KEY_PREFIX.length();
                for (Object objectKey : properties.keySet()) {
                    String propertyKey;
                    String key = (String)objectKey;
                    if (!key.startsWith(KEY_PREFIX) || configurations.containsKey(propertyKey = key.substring(length, key.indexOf(46, length)))) continue;
                    configurations.put(propertyKey, new ValidatorConfiguration(propertyKey, properties));
                }
            }
            catch (IOException e) {
                log.info((Object)e.getLocalizedMessage());
                log.debug((Object)e);
            }
        }
    }

    private static class ValidatorConfiguration {
        private Integer minLength;
        private Integer maxLength;
        private String pattern;
        private String formatMessage;

        private ValidatorConfiguration(String propertyKey, Properties properties) {
            boolean isUser = UserConfigurableValidator.USERNAME.equals(propertyKey);
            String prefixedKey = UserConfigurableValidator.KEY_PREFIX + propertyKey;
            String property = properties.getProperty(prefixedKey + ".length.min");
            this.minLength = property != null ? Integer.valueOf(property) : (isUser ? 3 : 0);
            property = properties.getProperty(prefixedKey + ".length.max");
            this.maxLength = property != null ? Integer.valueOf(property) : (isUser ? 30 : Integer.MAX_VALUE);
            this.pattern = properties.getProperty(prefixedKey + ".regexp", "^[\\p{L}][\\p{L}._\\-\\d]+$");
            this.formatMessage = properties.getProperty(prefixedKey + ".format.message", this.pattern);
        }
    }
}

