/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.connector.fckeditor;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.annotation.security.RolesAllowed;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.ecm.connector.fckeditor.FCKUtils;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.cms.link.NodeFinder;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.portal.PortalFolderSchemaHandler;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.services.wcm.webcontent.WebContentSchemaHandler;
import org.exoplatform.wcm.connector.BaseConnector;
import org.exoplatform.wcm.connector.handler.FCKFileHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Path(value="/wcmDriver/")
public class DriverConnector
extends BaseConnector
implements ResourceContainer {
    public static final String FILE_TYPE_WEBCONTENT = "Web Contents";
    public static final String FILE_TYPE_DMSDOC = "DMS Documents";
    public static final String FILE_TYPE_MEDIAS = "Medias";
    public static final String FILE_TYPE_ALL = "All";
    public static final String FILE_TYPE_IMAGE = "Image";
    public static final String[] MEDIA_MIMETYPE = new String[]{"application", "image", "audio", "video"};
    public static final String[] IMAGE_MIMETYPE = new String[]{"image"};
    private static final Log LOG = ExoLogger.getLogger((String)DriverConnector.class.getName());
    private int limit;
    private int limitCountClient_ = 3;
    private int limitCountServer_ = 30;
    private ResourceBundleService resourceBundleService = null;
    private NodeFinder nodeFinder_ = null;
    private LinkManager linkManager_ = null;
    private String[] resourceBundleNames;
    private ResourceBundle sharedResourceBundle = null;
    private Locale lang = Locale.ENGLISH;

    public DriverConnector(InitParams params) {
        this.limit = Integer.parseInt(params.getValueParam("upload.limit.size").getValue());
        if (params.getValueParam("upload.limit.count.client") != null) {
            this.limitCountClient_ = Integer.parseInt(params.getValueParam("upload.limit.count.client").getValue());
        }
        if (params.getValueParam("upload.limit.count.server") != null) {
            this.limitCountServer_ = Integer.parseInt(params.getValueParam("upload.limit.count.server").getValue());
        }
    }

    public int getLimitSize() {
        return this.limit;
    }

    public int getMaxUploadCount() {
        return this.limitCountClient_;
    }

    @GET
    @Path(value="/getDrivers/")
    @RolesAllowed(value={"users"})
    public Response getDrivers(@QueryParam(value="lang") String lang) throws Exception {
        ConversationState conversationState = ConversationState.getCurrent();
        String userId = conversationState.getIdentity().getUserId();
        List<DriveData> listDriver = this.getDriversByUserId(userId);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        Element rootElement = document.createElement("Connector");
        document.appendChild(rootElement);
        rootElement.setAttribute("isUpload", "false");
        rootElement.appendChild(this.appendDrivers(document, this.generalDrivers(listDriver), "General Drives", lang));
        rootElement.appendChild(this.appendDrivers(document, this.groupDrivers(listDriver), "Group Drives", lang));
        rootElement.appendChild(this.appendDrivers(document, this.personalDrivers(listDriver, userId), "Personal Drives", lang));
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
        return Response.ok((Object)new DOMSource(document), (String)"text/xml").cacheControl(cacheControl).header("Last-Modified", (Object)dateFormat.format(new Date())).build();
    }

    @GET
    @Path(value="/getFoldersAndFiles/")
    @RolesAllowed(value={"users"})
    public Response getFoldersAndFiles(@QueryParam(value="driverName") String driverName, @QueryParam(value="currentFolder") String currentFolder, @QueryParam(value="currentPortal") String currentPortal, @QueryParam(value="repositoryName") String repositoryName, @QueryParam(value="workspaceName") String workspaceName, @QueryParam(value="filterBy") String filterBy) throws Exception {
        try {
            RepositoryService repositoryService = (RepositoryService)WCMCoreUtils.getService(RepositoryService.class);
            ManageDriveService manageDriveService = (ManageDriveService)WCMCoreUtils.getService(ManageDriveService.class);
            SessionProvider sessionProvider = WCMCoreUtils.getUserSessionProvider();
            ManageableRepository manageableRepository = repositoryService.getCurrentRepository();
            DriveData drive = manageDriveService.getDriveByName(Text.escapeIllegalJcrChars((String)driverName));
            workspaceName = drive.getWorkspace();
            Session session = sessionProvider.getSession(workspaceName, manageableRepository);
            String driverHomePath = drive.getHomePath();
            String itemPath = driverHomePath + (currentFolder != null && !"".equals(currentFolder) && !driverHomePath.endsWith("/") ? "/" : "") + currentFolder;
            ConversationState conversationState = ConversationState.getCurrent();
            String userId = conversationState.getIdentity().getUserId();
            itemPath = Utils.getPersonalDrivePath((String)itemPath, (String)userId);
            Node node = (Node)session.getItem(Text.escapeIllegalJcrChars((String)itemPath));
            return this.buildXMLResponseForChildren(node, null, filterBy, session, currentPortal, Text.escapeIllegalJcrChars((String)driverName));
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"Error when perform getFoldersAndFiles: ", (Throwable)e);
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
            return Response.ok().header("Last-Modified", (Object)dateFormat.format(new Date())).build();
        }
    }

    @GET
    @Path(value="/uploadFile/checkUploadAvailable/")
    @RolesAllowed(value={"users"})
    public Response checkUploadAvailable() throws Exception {
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
        String msg = this.fileUploadHandler.getUploadingFileCount() < (long)this.limitCountServer_ ? "uploadAvailable" : "uploadNotAvailable";
        return Response.ok((Object)this.createDOMResponse(msg), (String)"text/xml").cacheControl(cacheControl).header("Last-Modified", (Object)dateFormat.format(new Date())).build();
    }

    @POST
    @Path(value="/uploadFile/upload/")
    @RolesAllowed(value={"users"})
    public Response uploadFile(@Context HttpServletRequest servletRequest, @QueryParam(value="uploadId") String uploadId) throws Exception {
        return this.fileUploadHandler.upload(servletRequest, uploadId, this.limit);
    }

    @GET
    @Path(value="/uploadFile/checkExistence/")
    @RolesAllowed(value={"users"})
    public Response checkExistence(@QueryParam(value="repositoryName") String repositoryName, @QueryParam(value="workspaceName") String workspaceName, @QueryParam(value="driverName") String driverName, @QueryParam(value="currentFolder") String currentFolder, @QueryParam(value="currentPortal") String currentPortal, @QueryParam(value="language") String language, @QueryParam(value="fileName") String fileName) throws Exception {
        try {
            Node currentFolderNode = this.getParentFolderNode(workspaceName, Text.escapeIllegalJcrChars((String)driverName), Text.escapeIllegalJcrChars((String)currentFolder));
            return this.fileUploadHandler.checkExistence(currentFolderNode, fileName);
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"Error when perform processUpload: ", (Throwable)e);
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
            return Response.ok().header("Last-Modified", (Object)dateFormat.format(new Date())).build();
        }
    }

    @GET
    @Path(value="/uploadFile/control/")
    @RolesAllowed(value={"users"})
    public Response processUpload(@QueryParam(value="repositoryName") String repositoryName, @QueryParam(value="workspaceName") String workspaceName, @QueryParam(value="driverName") String driverName, @QueryParam(value="currentFolder") String currentFolder, @QueryParam(value="currentPortal") String currentPortal, @QueryParam(value="userId") String userId, @QueryParam(value="jcrPath") String jcrPath, @QueryParam(value="action") String action, @QueryParam(value="language") String language, @QueryParam(value="fileName") String fileName, @QueryParam(value="uploadId") String uploadId, @QueryParam(value="existenceAction") String existenceAction) throws Exception {
        block4: {
            try {
                Response msgResponse = this.fileUploadHandler.checkStatus(uploadId, language);
                if (msgResponse != null) {
                    return msgResponse;
                }
                if (repositoryName != null && workspaceName != null && driverName != null && currentFolder != null) {
                    ManageDriveService manageDriveService = (ManageDriveService)WCMCoreUtils.getService(ManageDriveService.class);
                    workspaceName = workspaceName != null ? workspaceName : manageDriveService.getDriveByName(Text.escapeIllegalJcrChars((String)driverName)).getWorkspace();
                    Node currentFolderNode = this.getParentFolderNode(workspaceName, Text.escapeIllegalJcrChars((String)driverName), Text.escapeIllegalJcrChars((String)currentFolder));
                    fileName = Text.escapeIllegalJcrChars((String)fileName);
                    return this.createProcessUploadResponse(workspaceName, currentFolderNode, currentPortal, userId, Text.escapeIllegalJcrChars((String)jcrPath), action, language, fileName, uploadId, existenceAction);
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block4;
                LOG.error((Object)"Error when perform processUpload: ", (Throwable)e);
            }
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
        return Response.ok().header("Last-Modified", (Object)dateFormat.format(new Date())).build();
    }

    private List<DriveData> getDriversByUserId(String userId) throws Exception {
        ManageDriveService driveService = (ManageDriveService)WCMCoreUtils.getService(ManageDriveService.class);
        List<String> userRoles = this.getMemberships(userId);
        return driveService.getDriveByUserRoles(userId, userRoles);
    }

    private Element appendDrivers(Document document, List<DriveData> driversList, String groupName, String lang) throws Exception {
        Element folders = document.createElement("Folders");
        folders.setAttribute("name", this.resolveDriveLabel(groupName, lang));
        folders.setAttribute("isUpload", "false");
        for (DriveData driver : driversList) {
            String repository = WCMCoreUtils.getRepository().getConfiguration().getName();
            String workspace = driver.getWorkspace();
            String path = driver.getHomePath();
            String name = driver.getName();
            Element folder = document.createElement("Folder");
            NodeLocation nodeLocation = new NodeLocation(repository, workspace, path);
            Node driveNode = NodeLocation.getNodeByLocation((NodeLocation)nodeLocation);
            if (driveNode == null) continue;
            folder.setAttribute("name", name);
            folder.setAttribute("label", this.resolveDriveLabel(name, lang));
            folder.setAttribute("url", FCKUtils.createWebdavURL(driveNode));
            folder.setAttribute("folderType", "exo:drive");
            folder.setAttribute("path", path);
            folder.setAttribute("repository", repository);
            folder.setAttribute("workspace", workspace);
            folder.setAttribute("isUpload", "true");
            folder.setAttribute("hasFolderChild", String.valueOf(this.hasFolderChild(driveNode)));
            folder.setAttribute("nodeTypeCssClass", Utils.getNodeTypeIcon((Node)driveNode, (String)"uiIcon16x16"));
            folders.appendChild(folder);
        }
        return folders;
    }

    private String resolveDriveLabel(String name, String lang) {
        if (this.resourceBundleService == null) {
            this.resourceBundleService = (ResourceBundleService)WCMCoreUtils.getService(ResourceBundleService.class);
            this.resourceBundleNames = this.resourceBundleService.getSharedResourceBundleNames();
            this.sharedResourceBundle = this.resourceBundleService.getResourceBundle(this.resourceBundleNames, this.lang);
        }
        try {
            if (!this.lang.getLanguage().equals(lang)) {
                this.lang = new Locale(lang);
                this.sharedResourceBundle = this.resourceBundleService.getResourceBundle(this.resourceBundleNames, this.lang);
            }
            return this.sharedResourceBundle.getString("ContentSelector.title." + name.replaceAll(" ", ""));
        }
        catch (MissingResourceException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)e.getMessage());
            }
            return name;
        }
    }

    private List<DriveData> personalDrivers(List<DriveData> driveList, String userId) throws Exception {
        ArrayList<DriveData> personalDrivers = new ArrayList<DriveData>();
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)WCMCoreUtils.getService(NodeHierarchyCreator.class);
        SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
        Node userNode = nodeHierarchyCreator.getUserNode(sessionProvider, userId);
        for (DriveData drive : driveList) {
            String driveHomePath = Utils.getPersonalDrivePath((String)drive.getHomePath(), (String)userId);
            if (!driveHomePath.startsWith(userNode.getPath())) continue;
            drive.setHomePath(driveHomePath);
            personalDrivers.add(drive);
        }
        Collections.sort(personalDrivers);
        return personalDrivers;
    }

    private List<DriveData> groupDrivers(List<DriveData> driverList) throws Exception {
        ManageDriveService driveService = (ManageDriveService)WCMCoreUtils.getService(ManageDriveService.class);
        String currentUserId = ConversationState.getCurrent().getIdentity().getUserId();
        List<String> userRoles = this.getMemberships(currentUserId);
        return driveService.getGroupDrives(currentUserId, userRoles);
    }

    private List<DriveData> generalDrivers(List<DriveData> driverList) throws Exception {
        ArrayList<DriveData> generalDrivers = new ArrayList<DriveData>();
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)WCMCoreUtils.getService(NodeHierarchyCreator.class);
        String userPath = nodeHierarchyCreator.getJcrPath("usersPath");
        String groupPath = nodeHierarchyCreator.getJcrPath("groupsPath");
        for (DriveData drive : driverList) {
            if ((drive.getHomePath().startsWith(userPath) || drive.getHomePath().startsWith(groupPath)) && !drive.getHomePath().equals(userPath)) continue;
            generalDrivers.add(drive);
        }
        return generalDrivers;
    }

    private List<String> getMemberships(String userId) throws Exception {
        ArrayList<String> userMemberships = new ArrayList<String>();
        userMemberships.add(userId);
        Collection<MembershipEntry> memberships = DriverConnector.getUserMembershipsFromIdentityRegistry(userId);
        if (memberships != null) {
            for (MembershipEntry membership : memberships) {
                String role = membership.getMembershipType() + ":" + membership.getGroup();
                userMemberships.add(role);
            }
        }
        return userMemberships;
    }

    private static Collection<MembershipEntry> getUserMembershipsFromIdentityRegistry(String authenticatedUser) {
        IdentityRegistry identityRegistry = (IdentityRegistry)WCMCoreUtils.getService(IdentityRegistry.class);
        Identity currentUserIdentity = identityRegistry.getIdentity(authenticatedUser);
        return currentUserIdentity.getMemberships();
    }

    private Response buildXMLResponseForChildren(Node node, String command, String filterBy, Session session, String currentPortal, String nodeDriveName) throws Exception {
        Element rootElement = FCKUtils.createRootElement(command, node, this.folderHandler.getFolderType(node));
        NodeList nodeList = rootElement.getElementsByTagName("CurrentFolder");
        Element currentFolder = (Element)nodeList.item(0);
        currentFolder.setAttribute("isUpload", "true");
        Document document = rootElement.getOwnerDocument();
        Element folders = document.createElement("Folders");
        folders.setAttribute("isUpload", "true");
        Element files = document.createElement("Files");
        files.setAttribute("isUpload", "true");
        Node sourceNode = null;
        Node checkNode = null;
        ArrayList<Node> childList = new ArrayList<Node>();
        NodeIterator iterator = node.getNodes();
        while (iterator.hasNext()) {
            childList.add(iterator.nextNode());
        }
        Collections.sort(childList, new NodeTitleComparator());
        for (Node child : childList) {
            String fileType = null;
            if (child.isNodeType("exo:hiddenable")) continue;
            if (child.isNodeType("exo:symlink") && child.hasProperty("exo:uuid")) {
                LinkManager linkManager = (LinkManager)WCMCoreUtils.getService(LinkManager.class);
                sourceNode = linkManager.getTarget(child);
            } else {
                sourceNode = child;
            }
            Node node2 = checkNode = sourceNode != null ? sourceNode : child;
            if (this.isFolder(checkNode)) {
                String nodePath = child.getPath();
                Element folder = this.createFolderElement(document, checkNode, checkNode.getPrimaryNodeType().getName(), nodePath.substring(nodePath.lastIndexOf("/") + 1, nodePath.length()), nodeDriveName);
                folders.appendChild(folder);
            }
            if (FILE_TYPE_ALL.equals(filterBy) && (checkNode.isNodeType("exo:webContent") || !this.isFolder(checkNode))) {
                fileType = FILE_TYPE_ALL;
            }
            if (FILE_TYPE_WEBCONTENT.equals(filterBy) && checkNode.isNodeType("exo:webContent")) {
                fileType = FILE_TYPE_WEBCONTENT;
            }
            if (FILE_TYPE_MEDIAS.equals(filterBy) && this.isMediaType(checkNode)) {
                fileType = FILE_TYPE_MEDIAS;
            }
            if (FILE_TYPE_DMSDOC.equals(filterBy) && this.isDMSDocument(checkNode)) {
                fileType = FILE_TYPE_DMSDOC;
            }
            if (FILE_TYPE_IMAGE.equals(filterBy) && this.isImageType(checkNode)) {
                fileType = FILE_TYPE_IMAGE;
            }
            if (fileType == null) continue;
            Element file = FCKFileHandler.createFileElement(document, fileType, checkNode, child, currentPortal, this.linkManager);
            files.appendChild(file);
        }
        rootElement.appendChild(folders);
        rootElement.appendChild(files);
        return this.getResponse(document);
    }

    private boolean isFolder(Node checkNode) throws RepositoryException {
        block3: {
            try {
                if (this.isDocument(checkNode)) {
                    return false;
                }
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) break block3;
                LOG.warn((Object)e.getMessage());
            }
        }
        return checkNode.isNodeType("nt:unstructured") || checkNode.isNodeType("nt:folder") || checkNode.isNodeType("exo:taxonomy");
    }

    private boolean hasFolderChild(Node checkNode) throws Exception {
        return Utils.hasChild((Node)checkNode, (String)"nt:unstructured") || Utils.hasChild((Node)checkNode, (String)"nt:folder");
    }

    private boolean isDMSDocument(Node node) throws Exception {
        TemplateService templateService = (TemplateService)WCMCoreUtils.getService(TemplateService.class);
        List dmsDocumentListTmp = templateService.getDocumentTemplates();
        ArrayList dmsDocumentList = new ArrayList();
        dmsDocumentList.addAll(dmsDocumentListTmp);
        dmsDocumentList.remove("exo:webContent");
        for (String documentType : dmsDocumentList) {
            if (!node.getPrimaryNodeType().isNodeType(documentType) || this.isMediaType(node) || node.isNodeType("exo:webContent")) continue;
            return true;
        }
        return false;
    }

    private boolean isDocument(Node node) throws Exception {
        TemplateService templateService = (TemplateService)WCMCoreUtils.getService(TemplateService.class);
        List documentTypeList = templateService.getDocumentTemplates();
        documentTypeList.remove("exo:webContent");
        for (String documentType : documentTypeList) {
            if (!node.getPrimaryNodeType().isNodeType(documentType)) continue;
            return true;
        }
        return false;
    }

    private boolean isMediaType(Node node) {
        String mimeType = "";
        try {
            mimeType = node.getNode("jcr:content").getProperty("jcr:mimeType").getString();
        }
        catch (Exception e) {
            return false;
        }
        for (String type : MEDIA_MIMETYPE) {
            if (!mimeType.contains(type)) continue;
            return true;
        }
        return false;
    }

    private boolean isImageType(Node node) {
        String mimeType = "";
        try {
            mimeType = node.getNode("jcr:content").getProperty("jcr:mimeType").getString();
        }
        catch (Exception e) {
            return false;
        }
        for (String type : IMAGE_MIMETYPE) {
            if (!mimeType.contains(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected String getContentStorageType() throws Exception {
        return null;
    }

    @Override
    protected Node getRootContentStorage(Node node) throws Exception {
        try {
            PortalFolderSchemaHandler folderSchemaHandler = (PortalFolderSchemaHandler)this.webSchemaConfigService.getWebSchemaHandlerByType(PortalFolderSchemaHandler.class);
            return folderSchemaHandler.getImagesFolder(node);
        }
        catch (Exception e) {
            WebContentSchemaHandler webContentSchemaHandler = (WebContentSchemaHandler)this.webSchemaConfigService.getWebSchemaHandlerByType(WebContentSchemaHandler.class);
            return webContentSchemaHandler.getImagesFolders(node);
        }
    }

    protected Response createProcessUploadResponse(String workspaceName, Node currentFolderNode, String siteName, String userId, String jcrPath, String action, String language, String fileName, String uploadId, String existenceAction) throws Exception {
        if ("save".equals(action)) {
            CacheControl cacheControl = new CacheControl();
            cacheControl.setNoCache(true);
            return this.fileUploadHandler.saveAsNTFile(currentFolderNode, uploadId, fileName, language, siteName, userId, existenceAction);
        }
        return this.fileUploadHandler.control(uploadId, action);
    }

    private Node getParentFolderNode(String workspaceName, String driverName, String currentFolder) throws Exception {
        SessionProvider sessionProvider = WCMCoreUtils.getUserSessionProvider();
        ManageableRepository manageableRepository = WCMCoreUtils.getRepository();
        Session session = sessionProvider.getSession(workspaceName, manageableRepository);
        ManageDriveService manageDriveService = (ManageDriveService)WCMCoreUtils.getService(ManageDriveService.class);
        try {
            DriveData driveData = manageDriveService.getDriveByName(driverName);
            String parentPath = driveData != null ? driveData.getHomePath() : "";
            NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)WCMCoreUtils.getService(NodeHierarchyCreator.class);
            if (driveData != null && driveData.getHomePath().startsWith(nodeHierarchyCreator.getJcrPath("usersPath") + "/${userId}")) {
                parentPath = Utils.getPersonalDrivePath((String)driveData.getHomePath(), (String)ConversationState.getCurrent().getIdentity().getUserId());
            }
            parentPath = parentPath + (currentFolder != null && currentFolder.length() != 0 ? "/" : "") + currentFolder;
            parentPath = parentPath.replace("//", "/");
            return this.getTargetNode(session, parentPath);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Node getTargetNode(Session session, String path) {
        try {
            Node node = null;
            if (this.linkManager_ == null) {
                this.linkManager_ = (LinkManager)WCMCoreUtils.getService(LinkManager.class);
            }
            if (this.nodeFinder_ == null) {
                this.nodeFinder_ = (NodeFinder)WCMCoreUtils.getService(NodeFinder.class);
            }
            node = (Node)this.nodeFinder_.getItem(session, path, true);
            return node;
        }
        catch (Exception e) {
            return null;
        }
    }

    private Element createFolderElement(Document document, Node child, String folderType, String childName, String nodeDriveName) throws Exception {
        Element folder = document.createElement("Folder");
        folder.setAttribute("name", childName.replaceAll("%", "%25"));
        folder.setAttribute("title", Utils.getTitle((Node)child).replaceAll("%", "%25"));
        folder.setAttribute("url", FCKUtils.createWebdavURL(child));
        folder.setAttribute("folderType", folderType);
        folder.setAttribute("path", child.getPath());
        folder.setAttribute("isUpload", "true");
        folder.setAttribute("hasFolderChild", String.valueOf(this.hasFolderChild(child)));
        folder.setAttribute("nodeTypeCssClass", Utils.getNodeTypeIcon((Node)child, (String)"uiIcon16x16"));
        if (nodeDriveName != null && nodeDriveName.length() > 0) {
            folder.setAttribute("nodeDriveName", nodeDriveName);
        }
        return folder;
    }

    private DOMSource createDOMResponse(String message) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        Element rootElement = doc.createElement(message);
        doc.appendChild(rootElement);
        return new DOMSource(doc);
    }

    private static class NodeTitleComparator
    implements Comparator<Node> {
        private NodeTitleComparator() {
        }

        @Override
        public int compare(Node node1, Node node2) {
            try {
                String titleNode1 = Utils.getTitle((Node)node1);
                String titleNode2 = Utils.getTitle((Node)node2);
                return titleNode1.compareToIgnoreCase(titleNode2);
            }
            catch (Exception e) {
                return 0;
            }
        }
    }
}

