/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.htmlparser.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import nu.validator.htmlparser.annotation.Inline;
import nu.validator.htmlparser.annotation.Literal;
import nu.validator.htmlparser.annotation.Local;
import nu.validator.htmlparser.annotation.NoLength;
import nu.validator.htmlparser.annotation.NsUri;
import nu.validator.htmlparser.common.DoctypeExpectation;
import nu.validator.htmlparser.common.DocumentMode;
import nu.validator.htmlparser.common.DocumentModeHandler;
import nu.validator.htmlparser.common.TokenHandler;
import nu.validator.htmlparser.common.XmlViolationPolicy;
import nu.validator.htmlparser.impl.AttributeName;
import nu.validator.htmlparser.impl.ElementName;
import nu.validator.htmlparser.impl.HtmlAttributes;
import nu.validator.htmlparser.impl.LocatorImpl;
import nu.validator.htmlparser.impl.NCName;
import nu.validator.htmlparser.impl.Portability;
import nu.validator.htmlparser.impl.StackNode;
import nu.validator.htmlparser.impl.StateSnapshot;
import nu.validator.htmlparser.impl.Tokenizer;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TreeBuilder<T>
implements TokenHandler {
    static final int OTHER = 0;
    static final int A = 1;
    static final int BASE = 2;
    static final int BODY = 3;
    static final int BR = 4;
    static final int BUTTON = 5;
    static final int CAPTION = 6;
    static final int COL = 7;
    static final int COLGROUP = 8;
    static final int FORM = 9;
    static final int FRAME = 10;
    static final int FRAMESET = 11;
    static final int IMAGE = 12;
    static final int INPUT = 13;
    static final int ISINDEX = 14;
    static final int LI = 15;
    static final int LINK = 16;
    static final int MATH = 17;
    static final int META = 18;
    static final int SVG = 19;
    static final int HEAD = 20;
    static final int HR = 22;
    static final int HTML = 23;
    static final int NOBR = 24;
    static final int NOFRAMES = 25;
    static final int NOSCRIPT = 26;
    static final int OPTGROUP = 27;
    static final int OPTION = 28;
    static final int P = 29;
    static final int PLAINTEXT = 30;
    static final int SCRIPT = 31;
    static final int SELECT = 32;
    static final int STYLE = 33;
    static final int TABLE = 34;
    static final int TEXTAREA = 35;
    static final int TITLE = 36;
    static final int TR = 37;
    static final int XMP = 38;
    static final int TBODY_OR_THEAD_OR_TFOOT = 39;
    static final int TD_OR_TH = 40;
    static final int DD_OR_DT = 41;
    static final int H1_OR_H2_OR_H3_OR_H4_OR_H5_OR_H6 = 42;
    static final int MARQUEE_OR_APPLET = 43;
    static final int PRE_OR_LISTING = 44;
    static final int B_OR_BIG_OR_CODE_OR_EM_OR_I_OR_S_OR_SMALL_OR_STRIKE_OR_STRONG_OR_TT_OR_U = 45;
    static final int UL_OR_OL_OR_DL = 46;
    static final int IFRAME = 47;
    static final int EMBED_OR_IMG = 48;
    static final int AREA_OR_BASEFONT_OR_BGSOUND_OR_SPACER_OR_WBR = 49;
    static final int DIV_OR_BLOCKQUOTE_OR_CENTER_OR_MENU = 50;
    static final int ADDRESS_OR_DIR_OR_ARTICLE_OR_ASIDE_OR_DATAGRID_OR_DETAILS_OR_DIALOG_OR_FIGURE_OR_FOOTER_OR_HEADER_OR_NAV_OR_SECTION = 51;
    static final int RUBY_OR_SPAN_OR_SUB_OR_SUP_OR_VAR = 52;
    static final int RT_OR_RP = 53;
    static final int COMMAND_OR_EVENT_SOURCE = 54;
    static final int PARAM_OR_SOURCE = 55;
    static final int MGLYPH_OR_MALIGNMARK = 56;
    static final int MI_MO_MN_MS_MTEXT = 57;
    static final int ANNOTATION_XML = 58;
    static final int FOREIGNOBJECT_OR_DESC = 59;
    static final int NOEMBED = 60;
    static final int FIELDSET = 61;
    static final int OUTPUT_OR_LABEL = 62;
    static final int OBJECT = 63;
    static final int FONT = 64;
    static final int KEYGEN = 65;
    private static final int INITIAL = 0;
    private static final int BEFORE_HTML = 1;
    private static final int BEFORE_HEAD = 2;
    private static final int IN_HEAD = 3;
    private static final int IN_HEAD_NOSCRIPT = 4;
    private static final int AFTER_HEAD = 5;
    private static final int IN_BODY = 6;
    private static final int IN_TABLE = 7;
    private static final int IN_CAPTION = 8;
    private static final int IN_COLUMN_GROUP = 9;
    private static final int IN_TABLE_BODY = 10;
    private static final int IN_ROW = 11;
    private static final int IN_CELL = 12;
    private static final int IN_SELECT = 13;
    private static final int IN_SELECT_IN_TABLE = 14;
    private static final int AFTER_BODY = 15;
    private static final int IN_FRAMESET = 16;
    private static final int AFTER_FRAMESET = 17;
    private static final int AFTER_AFTER_BODY = 18;
    private static final int AFTER_AFTER_FRAMESET = 19;
    private static final int IN_CDATA_RCDATA = 20;
    private static final int FRAMESET_OK = 21;
    private static final int CHARSET_INITIAL = 0;
    private static final int CHARSET_C = 1;
    private static final int CHARSET_H = 2;
    private static final int CHARSET_A = 3;
    private static final int CHARSET_R = 4;
    private static final int CHARSET_S = 5;
    private static final int CHARSET_E = 6;
    private static final int CHARSET_T = 7;
    private static final int CHARSET_EQUALS = 8;
    private static final int CHARSET_SINGLE_QUOTED = 9;
    private static final int CHARSET_DOUBLE_QUOTED = 10;
    private static final int CHARSET_UNQUOTED = 11;
    private static final char[] ISINDEX_PROMPT = Portability.isIndexPrompt();
    private static final String[] HTML4_PUBLIC_IDS = new String[]{"-//W3C//DTD HTML 4.0 Frameset//EN", "-//W3C//DTD HTML 4.0 Transitional//EN", "-//W3C//DTD HTML 4.0//EN", "-//W3C//DTD HTML 4.01 Frameset//EN", "-//W3C//DTD HTML 4.01 Transitional//EN", "-//W3C//DTD HTML 4.01//EN"};
    @Literal
    private static final String[] QUIRKY_PUBLIC_IDS = new String[]{"+//silmaril//dtd html pro v0r11 19970101//", "-//advasoft ltd//dtd html 3.0 aswedit + extensions//", "-//as//dtd html 3.0 aswedit + extensions//", "-//ietf//dtd html 2.0 level 1//", "-//ietf//dtd html 2.0 level 2//", "-//ietf//dtd html 2.0 strict level 1//", "-//ietf//dtd html 2.0 strict level 2//", "-//ietf//dtd html 2.0 strict//", "-//ietf//dtd html 2.0//", "-//ietf//dtd html 2.1e//", "-//ietf//dtd html 3.0//", "-//ietf//dtd html 3.2 final//", "-//ietf//dtd html 3.2//", "-//ietf//dtd html 3//", "-//ietf//dtd html level 0//", "-//ietf//dtd html level 1//", "-//ietf//dtd html level 2//", "-//ietf//dtd html level 3//", "-//ietf//dtd html strict level 0//", "-//ietf//dtd html strict level 1//", "-//ietf//dtd html strict level 2//", "-//ietf//dtd html strict level 3//", "-//ietf//dtd html strict//", "-//ietf//dtd html//", "-//metrius//dtd metrius presentational//", "-//microsoft//dtd internet explorer 2.0 html strict//", "-//microsoft//dtd internet explorer 2.0 html//", "-//microsoft//dtd internet explorer 2.0 tables//", "-//microsoft//dtd internet explorer 3.0 html strict//", "-//microsoft//dtd internet explorer 3.0 html//", "-//microsoft//dtd internet explorer 3.0 tables//", "-//netscape comm. corp.//dtd html//", "-//netscape comm. corp.//dtd strict html//", "-//o'reilly and associates//dtd html 2.0//", "-//o'reilly and associates//dtd html extended 1.0//", "-//o'reilly and associates//dtd html extended relaxed 1.0//", "-//softquad software//dtd hotmetal pro 6.0::19990601::extensions to html 4.0//", "-//softquad//dtd hotmetal pro 4.0::19971010::extensions to html 4.0//", "-//spyglass//dtd html 2.0 extended//", "-//sq//dtd html 2.0 hotmetal + extensions//", "-//sun microsystems corp.//dtd hotjava html//", "-//sun microsystems corp.//dtd hotjava strict html//", "-//w3c//dtd html 3 1995-03-24//", "-//w3c//dtd html 3.2 draft//", "-//w3c//dtd html 3.2 final//", "-//w3c//dtd html 3.2//", "-//w3c//dtd html 3.2s draft//", "-//w3c//dtd html 4.0 frameset//", "-//w3c//dtd html 4.0 transitional//", "-//w3c//dtd html experimental 19960712//", "-//w3c//dtd html experimental 970421//", "-//w3c//dtd w3 html//", "-//w3o//dtd w3 html 3.0//", "-//webtechs//dtd mozilla html 2.0//", "-//webtechs//dtd mozilla html//"};
    private static final int NOT_FOUND_ON_STACK = Integer.MAX_VALUE;
    private static final int IN_FOREIGN = 0;
    private static final int NOT_IN_FOREIGN = 1;
    @Local
    private static final String HTML_LOCAL = "html";
    private int mode = 0;
    private int originalMode = 0;
    private int foreignFlag = 1;
    protected Tokenizer tokenizer;
    protected ErrorHandler errorHandler;
    private DocumentModeHandler documentModeHandler;
    private DoctypeExpectation doctypeExpectation = DoctypeExpectation.HTML;
    private boolean scriptingEnabled = false;
    private boolean needToDropLF;
    private boolean wantingComments;
    private boolean fragment = false;
    @Local
    private String contextName;
    @NsUri
    private String contextNamespace;
    private T contextNode;
    private StackNode<T>[] stack;
    private int currentPtr = -1;
    private StackNode<T>[] listOfActiveFormattingElements;
    private int listPtr = -1;
    private T formPointer;
    private T headPointer;
    protected char[] charBuffer;
    protected int charBufferLen = 0;
    private boolean quirks = false;
    private boolean reportingDoctype = true;
    private XmlViolationPolicy namePolicy = XmlViolationPolicy.ALTER_INFOSET;
    private final Map<String, LocatorImpl> idLocations = new HashMap<String, LocatorImpl>();
    private boolean html4;

    protected TreeBuilder() {
    }

    protected void fatal() throws SAXException {
    }

    protected final void fatal(Exception e) throws SAXException {
        SAXParseException spe = new SAXParseException(e.getMessage(), this.tokenizer, e);
        if (this.errorHandler != null) {
            this.errorHandler.fatalError(spe);
        }
        throw spe;
    }

    final void fatal(String s) throws SAXException {
        SAXParseException spe = new SAXParseException(s, this.tokenizer);
        if (this.errorHandler != null) {
            this.errorHandler.fatalError(spe);
        }
        throw spe;
    }

    final void err(String message) throws SAXException {
        if (this.errorHandler == null) {
            return;
        }
        SAXParseException spe = new SAXParseException(message, this.tokenizer);
        this.errorHandler.error(spe);
    }

    final void warn(String message) throws SAXException {
        if (this.errorHandler == null) {
            return;
        }
        SAXParseException spe = new SAXParseException(message, this.tokenizer);
        this.errorHandler.warning(spe);
    }

    @Override
    public final void startTokenization(Tokenizer self) throws SAXException {
        this.tokenizer = self;
        this.stack = new StackNode[64];
        this.listOfActiveFormattingElements = new StackNode[64];
        this.needToDropLF = false;
        this.originalMode = 0;
        this.currentPtr = -1;
        this.listPtr = -1;
        Portability.releaseElement(this.formPointer);
        this.formPointer = null;
        Portability.releaseElement(this.headPointer);
        this.headPointer = null;
        this.html4 = false;
        this.idLocations.clear();
        this.wantingComments = this.wantsComments();
        this.start(this.fragment);
        this.charBufferLen = 0;
        this.charBuffer = new char[1024];
        if (this.fragment) {
            T elt;
            if (this.contextNode != null) {
                elt = this.contextNode;
                Portability.retainElement(elt);
            } else {
                elt = this.createHtmlElementSetAsRoot(this.tokenizer.emptyAttributes());
            }
            StackNode<T> node = new StackNode<T>("http://www.w3.org/1999/xhtml", ElementName.HTML, elt);
            ++this.currentPtr;
            this.stack[this.currentPtr] = node;
            this.resetTheInsertionMode();
            if ("title" == this.contextName || "textarea" == this.contextName) {
                this.tokenizer.setContentModelFlag(1, this.contextName);
            } else if ("style" == this.contextName || "script" == this.contextName || "xmp" == this.contextName || "iframe" == this.contextName || "noembed" == this.contextName || "noframes" == this.contextName || this.scriptingEnabled && "noscript" == this.contextName) {
                this.tokenizer.setContentModelFlag(2, this.contextName);
            } else if ("plaintext" == this.contextName) {
                this.tokenizer.setContentModelFlag(3, this.contextName);
            } else {
                this.tokenizer.setContentModelFlag(0, this.contextName);
            }
            Portability.releaseLocal(this.contextName);
            this.contextName = null;
            Portability.releaseElement(this.contextNode);
            this.contextNode = null;
            Portability.releaseElement(elt);
        } else {
            this.mode = 0;
            this.foreignFlag = 1;
        }
    }

    @Override
    public final void doctype(@Local String name, String publicIdentifier, String systemIdentifier, boolean forceQuirks) throws SAXException {
        this.needToDropLF = false;
        switch (this.foreignFlag) {
            case 0: {
                break;
            }
            default: {
                switch (this.mode) {
                    case 0: {
                        if (this.reportingDoctype) {
                            String emptyString = Portability.newEmptyString();
                            this.appendDoctypeToDocument(name == null ? "" : name, publicIdentifier == null ? emptyString : publicIdentifier, systemIdentifier == null ? emptyString : systemIdentifier);
                            Portability.releaseString(emptyString);
                        }
                        switch (this.doctypeExpectation) {
                            case HTML: {
                                if (this.isQuirky(name, publicIdentifier, systemIdentifier, forceQuirks)) {
                                    this.err("Quirky doctype. Expected \u201c<!DOCTYPE html>\u201d.");
                                    this.documentModeInternal(DocumentMode.QUIRKS_MODE, publicIdentifier, systemIdentifier, false);
                                    break;
                                }
                                if (this.isAlmostStandards(publicIdentifier, systemIdentifier)) {
                                    this.err("Almost standards mode doctype. Expected \u201c<!DOCTYPE html>\u201d.");
                                    this.documentModeInternal(DocumentMode.ALMOST_STANDARDS_MODE, publicIdentifier, systemIdentifier, false);
                                    break;
                                }
                                if (systemIdentifier != null && !Portability.literalEqualsString("about:legacy-compat", systemIdentifier) || publicIdentifier != null) {
                                    this.err("Legacy doctype. Expected \u201c<!DOCTYPE html>\u201d.");
                                }
                                this.documentModeInternal(DocumentMode.STANDARDS_MODE, publicIdentifier, systemIdentifier, false);
                                break;
                            }
                            case HTML401_STRICT: {
                                this.html4 = true;
                                this.tokenizer.turnOnAdditionalHtml4Errors();
                                if (this.isQuirky(name, publicIdentifier, systemIdentifier, forceQuirks)) {
                                    this.err("Quirky doctype. Expected \u201c<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">\u201d.");
                                    this.documentModeInternal(DocumentMode.QUIRKS_MODE, publicIdentifier, systemIdentifier, true);
                                    break;
                                }
                                if (this.isAlmostStandards(publicIdentifier, systemIdentifier)) {
                                    this.err("Almost standards mode doctype. Expected \u201c<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">\u201d.");
                                    this.documentModeInternal(DocumentMode.ALMOST_STANDARDS_MODE, publicIdentifier, systemIdentifier, true);
                                    break;
                                }
                                if ("-//W3C//DTD HTML 4.01//EN".equals(publicIdentifier)) {
                                    if (!"http://www.w3.org/TR/html4/strict.dtd".equals(systemIdentifier)) {
                                        this.warn("The doctype did not contain the system identifier prescribed by the HTML 4.01 specification. Expected \u201c<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">\u201d.");
                                    }
                                } else {
                                    this.err("The doctype was not the HTML 4.01 Strict doctype. Expected \u201c<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">\u201d.");
                                }
                                this.documentModeInternal(DocumentMode.STANDARDS_MODE, publicIdentifier, systemIdentifier, true);
                                break;
                            }
                            case HTML401_TRANSITIONAL: {
                                this.html4 = true;
                                this.tokenizer.turnOnAdditionalHtml4Errors();
                                if (this.isQuirky(name, publicIdentifier, systemIdentifier, forceQuirks)) {
                                    this.err("Quirky doctype. Expected \u201c<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\u201d.");
                                    this.documentModeInternal(DocumentMode.QUIRKS_MODE, publicIdentifier, systemIdentifier, true);
                                    break;
                                }
                                if (this.isAlmostStandards(publicIdentifier, systemIdentifier)) {
                                    if ("-//W3C//DTD HTML 4.01 Transitional//EN".equals(publicIdentifier) && systemIdentifier != null) {
                                        if (!"http://www.w3.org/TR/html4/loose.dtd".equals(systemIdentifier)) {
                                            this.warn("The doctype did not contain the system identifier prescribed by the HTML 4.01 specification. Expected \u201c<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\u201d.");
                                        }
                                    } else {
                                        this.err("The doctype was not a non-quirky HTML 4.01 Transitional doctype. Expected \u201c<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\u201d.");
                                    }
                                    this.documentModeInternal(DocumentMode.ALMOST_STANDARDS_MODE, publicIdentifier, systemIdentifier, true);
                                    break;
                                }
                                this.err("The doctype was not the HTML 4.01 Transitional doctype. Expected \u201c<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\u201d.");
                                this.documentModeInternal(DocumentMode.STANDARDS_MODE, publicIdentifier, systemIdentifier, true);
                                break;
                            }
                            case AUTO: {
                                this.html4 = this.isHtml4Doctype(publicIdentifier);
                                if (this.html4) {
                                    this.tokenizer.turnOnAdditionalHtml4Errors();
                                }
                                if (this.isQuirky(name, publicIdentifier, systemIdentifier, forceQuirks)) {
                                    this.err("Quirky doctype. Expected e.g. \u201c<!DOCTYPE html>\u201d.");
                                    this.documentModeInternal(DocumentMode.QUIRKS_MODE, publicIdentifier, systemIdentifier, this.html4);
                                    break;
                                }
                                if (this.isAlmostStandards(publicIdentifier, systemIdentifier)) {
                                    if ("-//W3C//DTD HTML 4.01 Transitional//EN".equals(publicIdentifier)) {
                                        if (!"http://www.w3.org/TR/html4/loose.dtd".equals(systemIdentifier)) {
                                            this.warn("The doctype did not contain the system identifier prescribed by the HTML 4.01 specification. Expected \u201c<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\u201d.");
                                        }
                                    } else {
                                        this.err("Almost standards mode doctype. Expected e.g. \u201c<!DOCTYPE html>\u201d.");
                                    }
                                    this.documentModeInternal(DocumentMode.ALMOST_STANDARDS_MODE, publicIdentifier, systemIdentifier, this.html4);
                                    break;
                                }
                                if ("-//W3C//DTD HTML 4.01//EN".equals(publicIdentifier)) {
                                    if (!"http://www.w3.org/TR/html4/strict.dtd".equals(systemIdentifier)) {
                                        this.warn("The doctype did not contain the system identifier prescribed by the HTML 4.01 specification. Expected \u201c<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">\u201d.");
                                    }
                                } else if (publicIdentifier != null || systemIdentifier != null) {
                                    this.err("Legacy doctype. Expected e.g. \u201c<!DOCTYPE html>\u201d.");
                                }
                                this.documentModeInternal(DocumentMode.STANDARDS_MODE, publicIdentifier, systemIdentifier, this.html4);
                                break;
                            }
                            case NO_DOCTYPE_ERRORS: {
                                if (this.isQuirky(name, publicIdentifier, systemIdentifier, forceQuirks)) {
                                    this.documentModeInternal(DocumentMode.QUIRKS_MODE, publicIdentifier, systemIdentifier, false);
                                    break;
                                }
                                if (this.isAlmostStandards(publicIdentifier, systemIdentifier)) {
                                    this.documentModeInternal(DocumentMode.ALMOST_STANDARDS_MODE, publicIdentifier, systemIdentifier, false);
                                    break;
                                }
                                this.documentModeInternal(DocumentMode.STANDARDS_MODE, publicIdentifier, systemIdentifier, false);
                            }
                        }
                        this.mode = 1;
                        return;
                    }
                }
            }
        }
        this.err("Stray doctype.");
    }

    private boolean isHtml4Doctype(String publicIdentifier) {
        return publicIdentifier != null && Arrays.binarySearch(HTML4_PUBLIC_IDS, publicIdentifier) > -1;
    }

    @Override
    public final void comment(@NoLength char[] buf, int start, int length) throws SAXException {
        this.needToDropLF = false;
        if (!this.wantingComments) {
            return;
        }
        switch (this.foreignFlag) {
            case 0: {
                break;
            }
            default: {
                switch (this.mode) {
                    case 0: 
                    case 1: 
                    case 18: 
                    case 19: {
                        this.appendCommentToDocument(buf, start, length);
                        return;
                    }
                    case 15: {
                        this.flushCharacters();
                        this.appendComment(this.stack[0].node, buf, start, length);
                        return;
                    }
                }
            }
        }
        this.flushCharacters();
        this.appendComment(this.stack[this.currentPtr].node, buf, start, length);
    }

    /*
     * Exception decompiling
     */
    @Override
    public final void characters(@NoLength char[] buf, int start, int length) throws SAXException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CASE]], but top level block is 7[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public final void eof() throws SAXException {
        this.flushCharacters();
        switch (this.foreignFlag) {
            case 0: {
                this.err("End of file in a foreign namespace context.");
                while (this.stack[this.currentPtr].ns != "http://www.w3.org/1999/xhtml") {
                    this.pop();
                }
                this.foreignFlag = 1;
            }
        }
        block25: while (true) {
            switch (this.mode) {
                case 0: {
                    switch (this.doctypeExpectation) {
                        case AUTO: {
                            this.err("End of file seen without seeing a doctype first. Expected e.g. \u201c<!DOCTYPE html>\u201d.");
                            break;
                        }
                        case HTML: {
                            this.err("End of file seen without seeing a doctype first. Expected \u201c<!DOCTYPE html>\u201d.");
                            break;
                        }
                        case HTML401_STRICT: {
                            this.err("End of file seen without seeing a doctype first. Expected \u201c<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">\u201d.");
                            break;
                        }
                        case HTML401_TRANSITIONAL: {
                            this.err("End of file seen without seeing a doctype first. Expected \u201c<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\u201d.");
                            break;
                        }
                    }
                    this.documentModeInternal(DocumentMode.QUIRKS_MODE, null, null, false);
                    this.mode = 1;
                    continue block25;
                }
                case 1: {
                    this.appendHtmlElementToDocumentAndPush();
                    this.mode = 2;
                    continue block25;
                }
                case 2: {
                    this.appendToCurrentNodeAndPushHeadElement(HtmlAttributes.EMPTY_ATTRIBUTES);
                    this.mode = 3;
                    continue block25;
                }
                case 3: {
                    if (this.currentPtr > 1) {
                        this.err("End of file seen and there were open elements.");
                    }
                    while (this.currentPtr > 0) {
                        this.pop();
                    }
                    this.mode = 5;
                    continue block25;
                }
                case 4: {
                    this.err("End of file seen and there were open elements.");
                    while (this.currentPtr > 1) {
                        this.pop();
                    }
                    this.mode = 3;
                    continue block25;
                }
                case 5: {
                    this.appendToCurrentNodeAndPushBodyElement();
                    this.mode = 6;
                    continue block25;
                }
                case 9: {
                    if (this.currentPtr == 0) {
                        assert (this.fragment);
                        break block25;
                    }
                    this.pop();
                    this.mode = 7;
                    continue block25;
                }
                case 6: 
                case 8: 
                case 12: 
                case 21: {
                    block28: for (int i = this.currentPtr; i >= 0; --i) {
                        int group = this.stack[i].group;
                        switch (group) {
                            case 3: 
                            case 15: 
                            case 23: 
                            case 29: 
                            case 39: 
                            case 40: 
                            case 41: {
                                continue block28;
                            }
                            default: {
                                this.err("End of file seen and there were open elements.");
                                break block25;
                            }
                        }
                    }
                    break block25;
                }
                case 20: {
                    this.err("End of file seen inside an [R]CDATA element.");
                    if (this.originalMode == 5) {
                        this.pop();
                    }
                    this.pop();
                    this.mode = this.originalMode;
                    continue block25;
                }
                case 7: 
                case 10: 
                case 11: 
                case 13: 
                case 14: 
                case 16: {
                    if (this.currentPtr <= 0) break block25;
                    this.err("End of file seen and there were open elements.");
                    break block25;
                }
                default: {
                    if (this.currentPtr != 0) break block25;
                    System.currentTimeMillis();
                    break block25;
                }
            }
            break;
        }
        while (this.currentPtr > 0) {
            this.pop();
        }
        if (!this.fragment) {
            this.pop();
        }
    }

    @Override
    public final void endTokenization() throws SAXException {
        Portability.releaseElement(this.formPointer);
        this.formPointer = null;
        Portability.releaseElement(this.headPointer);
        this.headPointer = null;
        while (this.currentPtr > -1) {
            this.stack[this.currentPtr].release();
            --this.currentPtr;
        }
        Portability.releaseArray(this.stack);
        this.stack = null;
        while (this.listPtr > -1) {
            if (this.listOfActiveFormattingElements[this.listPtr] != null) {
                this.listOfActiveFormattingElements[this.listPtr].release();
            }
            --this.listPtr;
        }
        Portability.releaseArray(this.listOfActiveFormattingElements);
        this.listOfActiveFormattingElements = null;
        this.idLocations.clear();
        Portability.releaseArray(this.charBuffer);
        this.charBuffer = null;
        this.end();
    }

    /*
     * Exception decompiling
     */
    @Override
    public final void startTag(ElementName elementName, HtmlAttributes attributes, boolean selfClosing) throws SAXException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[CASE]], but top level block is 50[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     */
    public static String extractCharsetFromContent(String attributeValue) {
        charsetState = 0;
        start = -1;
        end = -1;
        buffer = Portability.newCharArrayFromString(attributeValue);
        block53: for (i = 0; i < buffer.length; ++i) {
            c = buffer[i];
            switch (charsetState) {
                case 0: {
                    switch (c) {
                        case 'C': 
                        case 'c': {
                            charsetState = 1;
                            break;
                        }
                    }
                    ** GOTO lbl111
                }
                case 1: {
                    switch (c) {
                        case 'H': 
                        case 'h': {
                            charsetState = 2;
                            break;
                        }
                        default: {
                            charsetState = 0;
                            break;
                        }
                    }
                    ** GOTO lbl111
                }
                case 2: {
                    switch (c) {
                        case 'A': 
                        case 'a': {
                            charsetState = 3;
                            break;
                        }
                        default: {
                            charsetState = 0;
                            break;
                        }
                    }
                    ** GOTO lbl111
                }
                case 3: {
                    switch (c) {
                        case 'R': 
                        case 'r': {
                            charsetState = 4;
                            break;
                        }
                        default: {
                            charsetState = 0;
                            break;
                        }
                    }
                    ** GOTO lbl111
                }
                case 4: {
                    switch (c) {
                        case 'S': 
                        case 's': {
                            charsetState = 5;
                            break;
                        }
                        default: {
                            charsetState = 0;
                            break;
                        }
                    }
                    ** GOTO lbl111
                }
                case 5: {
                    switch (c) {
                        case 'E': 
                        case 'e': {
                            charsetState = 6;
                            break;
                        }
                        default: {
                            charsetState = 0;
                            break;
                        }
                    }
                    ** GOTO lbl111
                }
                case 6: {
                    switch (c) {
                        case 'T': 
                        case 't': {
                            charsetState = 7;
                            break;
                        }
                        default: {
                            charsetState = 0;
                            break;
                        }
                    }
                    ** GOTO lbl111
                }
                case 7: {
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            ** GOTO lbl111
                        }
                        case '=': {
                            charsetState = 8;
                            ** GOTO lbl111
                        }
                        default: {
                            return null;
                        }
                    }
                }
                case 8: {
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            break;
                        }
                        case '\'': {
                            start = i + 1;
                            charsetState = 9;
                            break;
                        }
                        case '\"': {
                            start = i + 1;
                            charsetState = 10;
                            break;
                        }
                        default: {
                            start = i;
                            charsetState = 11;
                            break;
                        }
                    }
                    ** GOTO lbl111
                }
                case 9: {
                    switch (c) {
                        case '\'': {
                            end = i;
                            break block53;
                        }
                    }
                    ** GOTO lbl111
                }
                case 10: {
                    switch (c) {
                        case '\"': {
                            end = i;
                            break block53;
                        }
                    }
                    ** GOTO lbl111
                }
                case 11: {
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': 
                        case ';': {
                            end = i;
                            break block53;
                        }
                    }
                }
lbl111:
                // 14 sources

                default: {
                    continue block53;
                }
            }
        }
        rv = null;
        if (start != -1) {
            if (end == -1) {
                end = buffer.length;
            }
            rv = Portability.newStringFromBuffer(buffer, start, end - start);
        }
        Portability.releaseArray(buffer);
        return rv;
    }

    private void checkMetaCharset(HtmlAttributes attributes) throws SAXException {
        String content = attributes.getValue(AttributeName.CONTENT);
        String internalCharsetLegacy = null;
        if (content != null) {
            internalCharsetLegacy = TreeBuilder.extractCharsetFromContent(content);
            if (this.errorHandler != null && internalCharsetLegacy != null && !Portability.lowerCaseLiteralEqualsIgnoreAsciiCaseString("content-type", attributes.getValue(AttributeName.HTTP_EQUIV))) {
                this.warn("Attribute \u201ccontent\u201d would be sniffed as an internal character encoding declaration but there was no matching \u201chttp-equiv='Content-Type'\u201d attribute.");
            }
        }
        if (internalCharsetLegacy == null) {
            String internalCharsetHtml5 = attributes.getValue(AttributeName.CHARSET);
            if (internalCharsetHtml5 != null) {
                this.tokenizer.internalEncodingDeclaration(internalCharsetHtml5);
                this.requestSuspension();
            }
        } else {
            this.tokenizer.internalEncodingDeclaration(internalCharsetLegacy);
            Portability.releaseString(internalCharsetLegacy);
            this.requestSuspension();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public final void endTag(ElementName elementName) throws SAXException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CASE]], but top level block is 38[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void endSelect() throws SAXException {
        int eltPos = this.findLastInTableScope("select");
        if (eltPos == Integer.MAX_VALUE) {
            assert (this.fragment);
            this.err("Stray end tag \u201cselect\u201d");
            return;
        }
        while (this.currentPtr >= eltPos) {
            this.pop();
        }
        this.resetTheInsertionMode();
    }

    private int findLastInTableScopeOrRootTbodyTheadTfoot() {
        for (int i = this.currentPtr; i > 0; --i) {
            if (this.stack[i].group != 39) continue;
            return i;
        }
        return 0;
    }

    private int findLast(@Local String name) {
        for (int i = this.currentPtr; i > 0; --i) {
            if (this.stack[i].name != name) continue;
            return i;
        }
        return Integer.MAX_VALUE;
    }

    private int findLastInTableScope(@Local String name) {
        for (int i = this.currentPtr; i > 0; --i) {
            if (this.stack[i].name == name) {
                return i;
            }
            if (this.stack[i].name != "table") continue;
            return Integer.MAX_VALUE;
        }
        return Integer.MAX_VALUE;
    }

    private int findLastInScope(@Local String name) {
        for (int i = this.currentPtr; i > 0; --i) {
            if (this.stack[i].name == name) {
                return i;
            }
            if (!this.stack[i].scoping) continue;
            return Integer.MAX_VALUE;
        }
        return Integer.MAX_VALUE;
    }

    private int findLastInScopeHn() {
        for (int i = this.currentPtr; i > 0; --i) {
            if (this.stack[i].group == 42) {
                return i;
            }
            if (!this.stack[i].scoping) continue;
            return Integer.MAX_VALUE;
        }
        return Integer.MAX_VALUE;
    }

    private boolean hasForeignInScope() {
        for (int i = this.currentPtr; i > 0; --i) {
            if (this.stack[i].ns != "http://www.w3.org/1999/xhtml") {
                return true;
            }
            if (!this.stack[i].scoping) continue;
            return false;
        }
        return false;
    }

    private void generateImpliedEndTagsExceptFor(@Local String name) throws SAXException {
        block3: while (true) {
            StackNode<T> node = this.stack[this.currentPtr];
            switch (node.group) {
                case 15: 
                case 27: 
                case 28: 
                case 29: 
                case 41: 
                case 53: {
                    if (node.name == name) {
                        return;
                    }
                    this.pop();
                    continue block3;
                }
            }
            break;
        }
    }

    private void generateImpliedEndTags() throws SAXException {
        block3: while (true) {
            switch (this.stack[this.currentPtr].group) {
                case 15: 
                case 27: 
                case 28: 
                case 29: 
                case 41: 
                case 53: {
                    this.pop();
                    continue block3;
                }
            }
            break;
        }
    }

    private boolean isSecondOnStackBody() {
        return this.currentPtr >= 1 && this.stack[1].group == 3;
    }

    private void documentModeInternal(DocumentMode m, String publicIdentifier, String systemIdentifier, boolean html4SpecificAdditionalErrorChecks) throws SAXException {
        boolean bl = this.quirks = m == DocumentMode.QUIRKS_MODE;
        if (this.documentModeHandler != null) {
            this.documentModeHandler.documentMode(m, publicIdentifier, systemIdentifier, html4SpecificAdditionalErrorChecks);
        }
        this.documentMode(m, publicIdentifier, systemIdentifier, html4SpecificAdditionalErrorChecks);
    }

    private boolean isAlmostStandards(String publicIdentifier, String systemIdentifier) {
        if (Portability.lowerCaseLiteralEqualsIgnoreAsciiCaseString("-//w3c//dtd xhtml 1.0 transitional//en", publicIdentifier)) {
            return true;
        }
        if (Portability.lowerCaseLiteralEqualsIgnoreAsciiCaseString("-//w3c//dtd xhtml 1.0 frameset//en", publicIdentifier)) {
            return true;
        }
        if (systemIdentifier != null) {
            if (Portability.lowerCaseLiteralEqualsIgnoreAsciiCaseString("-//w3c//dtd html 4.01 transitional//en", publicIdentifier)) {
                return true;
            }
            if (Portability.lowerCaseLiteralEqualsIgnoreAsciiCaseString("-//w3c//dtd html 4.01 frameset//en", publicIdentifier)) {
                return true;
            }
        }
        return false;
    }

    private boolean isQuirky(@Local String name, String publicIdentifier, String systemIdentifier, boolean forceQuirks) {
        if (forceQuirks) {
            return true;
        }
        if (name != HTML_LOCAL) {
            return true;
        }
        if (publicIdentifier != null) {
            for (int i = 0; i < QUIRKY_PUBLIC_IDS.length; ++i) {
                if (!Portability.lowerCaseLiteralIsPrefixOfIgnoreAsciiCaseString(QUIRKY_PUBLIC_IDS[i], publicIdentifier)) continue;
                return true;
            }
            if (Portability.lowerCaseLiteralEqualsIgnoreAsciiCaseString("-//w3o//dtd w3 html strict 3.0//en//", publicIdentifier) || Portability.lowerCaseLiteralEqualsIgnoreAsciiCaseString("-/w3c/dtd html 4.0 transitional/en", publicIdentifier) || Portability.lowerCaseLiteralEqualsIgnoreAsciiCaseString(HTML_LOCAL, publicIdentifier)) {
                return true;
            }
        }
        if (systemIdentifier == null) {
            if (Portability.lowerCaseLiteralEqualsIgnoreAsciiCaseString("-//w3c//dtd html 4.01 transitional//en", publicIdentifier)) {
                return true;
            }
            if (Portability.lowerCaseLiteralEqualsIgnoreAsciiCaseString("-//w3c//dtd html 4.01 frameset//en", publicIdentifier)) {
                return true;
            }
        } else if (Portability.lowerCaseLiteralEqualsIgnoreAsciiCaseString("http://www.ibm.com/data/dtd/v11/ibmxhtml1-transitional.dtd", systemIdentifier)) {
            return true;
        }
        return false;
    }

    private void closeTheCell(int eltPos) throws SAXException {
        this.generateImpliedEndTags();
        if (eltPos != this.currentPtr) {
            this.err("Unclosed elements.");
        }
        while (this.currentPtr >= eltPos) {
            this.pop();
        }
        this.clearTheListOfActiveFormattingElementsUpToTheLastMarker();
        this.mode = 11;
    }

    private int findLastInTableScopeTdTh() {
        for (int i = this.currentPtr; i > 0; --i) {
            String name = this.stack[i].name;
            if ("td" == name || "th" == name) {
                return i;
            }
            if (name != "table") continue;
            return Integer.MAX_VALUE;
        }
        return Integer.MAX_VALUE;
    }

    private void clearStackBackTo(int eltPos) throws SAXException {
        while (this.currentPtr > eltPos) {
            this.pop();
        }
    }

    private void resetTheInsertionMode() {
        this.foreignFlag = 1;
        for (int i = this.currentPtr; i >= 0; --i) {
            StackNode<T> node = this.stack[i];
            String name = node.name;
            String ns = node.ns;
            if (i == 0) {
                if (this.contextNamespace != "http://www.w3.org/1999/xhtml" || this.contextName != "td" && this.contextName != "th") {
                    name = this.contextName;
                    ns = this.contextNamespace;
                } else {
                    this.mode = 6;
                    return;
                }
            }
            if ("select" == name) {
                this.mode = 13;
                return;
            }
            if ("td" == name || "th" == name) {
                this.mode = 12;
                return;
            }
            if ("tr" == name) {
                this.mode = 11;
                return;
            }
            if ("tbody" == name || "thead" == name || "tfoot" == name) {
                this.mode = 10;
                return;
            }
            if ("caption" == name) {
                this.mode = 8;
                return;
            }
            if ("colgroup" == name) {
                this.mode = 9;
                return;
            }
            if ("table" == name) {
                this.mode = 7;
                return;
            }
            if ("http://www.w3.org/1999/xhtml" != node.ns) {
                this.foreignFlag = 0;
                this.mode = 6;
                return;
            }
            if ("head" == name) {
                this.mode = 6;
                return;
            }
            if ("body" == name) {
                this.mode = 6;
                return;
            }
            if ("frameset" == name) {
                this.mode = 16;
                return;
            }
            if (HTML_LOCAL == name) {
                this.mode = this.headPointer == null ? 2 : 5;
                return;
            }
            if (i != 0) continue;
            this.mode = 6;
            return;
        }
    }

    private void implicitlyCloseP() throws SAXException {
        int eltPos = this.findLastInScope("p");
        if (eltPos == Integer.MAX_VALUE) {
            return;
        }
        this.generateImpliedEndTagsExceptFor("p");
        if (eltPos != this.currentPtr) {
            this.err("Unclosed elements.");
        }
        while (this.currentPtr >= eltPos) {
            this.pop();
        }
    }

    private boolean clearLastStackSlot() {
        this.stack[this.currentPtr] = null;
        return true;
    }

    private boolean clearLastListSlot() {
        this.listOfActiveFormattingElements[this.listPtr] = null;
        return true;
    }

    private void push(StackNode<T> node) throws SAXException {
        ++this.currentPtr;
        if (this.currentPtr == this.stack.length) {
            StackNode[] newStack = new StackNode[this.stack.length + 64];
            System.arraycopy(this.stack, 0, newStack, 0, this.stack.length);
            Portability.releaseArray(this.stack);
            this.stack = newStack;
        }
        this.stack[this.currentPtr] = node;
        this.elementPushed(node.ns, node.popName, node.node);
    }

    private void append(StackNode<T> node) {
        ++this.listPtr;
        if (this.listPtr == this.listOfActiveFormattingElements.length) {
            StackNode[] newList = new StackNode[this.listOfActiveFormattingElements.length + 64];
            System.arraycopy(this.listOfActiveFormattingElements, 0, newList, 0, this.listOfActiveFormattingElements.length);
            Portability.releaseArray(this.listOfActiveFormattingElements);
            this.listOfActiveFormattingElements = newList;
        }
        this.listOfActiveFormattingElements[this.listPtr] = node;
    }

    @Inline
    private void insertMarker() {
        this.append(null);
    }

    private void clearTheListOfActiveFormattingElementsUpToTheLastMarker() {
        while (this.listPtr > -1) {
            if (this.listOfActiveFormattingElements[this.listPtr] == null) {
                --this.listPtr;
                return;
            }
            this.listOfActiveFormattingElements[this.listPtr].release();
            --this.listPtr;
        }
    }

    @Inline
    private boolean isCurrent(@Local String name) {
        return name == this.stack[this.currentPtr].name;
    }

    private void removeFromStack(int pos) throws SAXException {
        if (this.currentPtr == pos) {
            this.pop();
        } else {
            this.fatal();
            this.stack[pos].release();
            System.arraycopy(this.stack, pos + 1, this.stack, pos, this.currentPtr - pos);
            assert (this.clearLastStackSlot());
            --this.currentPtr;
        }
    }

    private void removeFromStack(StackNode<T> node) throws SAXException {
        if (this.stack[this.currentPtr] == node) {
            this.pop();
        } else {
            int pos;
            for (pos = this.currentPtr - 1; pos >= 0 && this.stack[pos] != node; --pos) {
            }
            if (pos == -1) {
                return;
            }
            this.fatal();
            node.release();
            System.arraycopy(this.stack, pos + 1, this.stack, pos, this.currentPtr - pos);
            --this.currentPtr;
        }
    }

    private void removeFromListOfActiveFormattingElements(int pos) {
        assert (this.listOfActiveFormattingElements[pos] != null);
        this.listOfActiveFormattingElements[pos].release();
        if (pos == this.listPtr) {
            assert (this.clearLastListSlot());
            --this.listPtr;
            return;
        }
        assert (pos < this.listPtr);
        System.arraycopy(this.listOfActiveFormattingElements, pos + 1, this.listOfActiveFormattingElements, pos, this.listPtr - pos);
        assert (this.clearLastListSlot());
        --this.listPtr;
    }

    private void adoptionAgencyEndTag(@Local String name) throws SAXException {
        this.flushCharacters();
        while (true) {
            int furthestBlockPos;
            StackNode<T> node;
            int formattingEltStackPos;
            int formattingEltListPos;
            for (formattingEltListPos = this.listPtr; formattingEltListPos > -1; --formattingEltListPos) {
                StackNode<T> listNode = this.listOfActiveFormattingElements[formattingEltListPos];
                if (listNode == null) {
                    formattingEltListPos = -1;
                    break;
                }
                if (listNode.name == name) break;
            }
            if (formattingEltListPos == -1) {
                this.err("No element \u201c" + name + "\u201d to close.");
                return;
            }
            StackNode<T> formattingElt = this.listOfActiveFormattingElements[formattingEltListPos];
            boolean inScope = true;
            for (formattingEltStackPos = this.currentPtr; formattingEltStackPos > -1 && (node = this.stack[formattingEltStackPos]) != formattingElt; --formattingEltStackPos) {
                if (!node.scoping) continue;
                inScope = false;
            }
            if (formattingEltStackPos == -1) {
                this.err("No element \u201c" + name + "\u201d to close.");
                this.removeFromListOfActiveFormattingElements(formattingEltListPos);
                return;
            }
            if (!inScope) {
                this.err("No element \u201c" + name + "\u201d to close.");
                return;
            }
            if (formattingEltStackPos != this.currentPtr) {
                this.err("End tag \u201c" + name + "\u201d violates nesting rules.");
            }
            for (furthestBlockPos = formattingEltStackPos + 1; furthestBlockPos <= this.currentPtr; ++furthestBlockPos) {
                StackNode<T> node2 = this.stack[furthestBlockPos];
                if (node2.scoping || node2.special) break;
            }
            if (furthestBlockPos > this.currentPtr) {
                while (this.currentPtr >= formattingEltStackPos) {
                    this.pop();
                }
                this.removeFromListOfActiveFormattingElements(formattingEltListPos);
                return;
            }
            StackNode<T> commonAncestor = this.stack[formattingEltStackPos - 1];
            StackNode<T> furthestBlock = this.stack[furthestBlockPos];
            int bookmark = formattingEltListPos;
            int nodePos = furthestBlockPos;
            StackNode<T> lastNode = furthestBlock;
            while (true) {
                StackNode<T> node3;
                int nodeListPos;
                if ((nodeListPos = this.findInListOfActiveFormattingElements(node3 = this.stack[--nodePos])) == -1) {
                    assert (formattingEltStackPos < nodePos);
                    assert (bookmark < nodePos);
                    assert (furthestBlockPos > nodePos);
                    this.removeFromStack(nodePos);
                    --furthestBlockPos;
                    continue;
                }
                if (nodePos == formattingEltStackPos) break;
                if (nodePos == furthestBlockPos) {
                    bookmark = nodeListPos + 1;
                }
                assert (node3 == this.listOfActiveFormattingElements[nodeListPos]);
                assert (node3 == this.stack[nodePos]);
                Object clone = this.shallowClone(node3.node);
                StackNode newNode = new StackNode(node3.group, node3.ns, node3.name, clone, node3.scoping, node3.special, node3.fosterParenting, node3.popName);
                this.stack[nodePos] = newNode;
                newNode.retain();
                this.listOfActiveFormattingElements[nodeListPos] = newNode;
                node3.release();
                node3.release();
                node3 = newNode;
                Portability.releaseElement(clone);
                this.detachFromParent(lastNode.node);
                this.appendElement(lastNode.node, node3.node);
                lastNode = node3;
            }
            if (commonAncestor.fosterParenting) {
                this.fatal();
                this.detachFromParent(lastNode.node);
                this.insertIntoFosterParent(lastNode.node);
            } else {
                this.detachFromParent(lastNode.node);
                this.appendElement(lastNode.node, commonAncestor.node);
            }
            Object clone = this.shallowClone(formattingElt.node);
            StackNode formattingClone = new StackNode(formattingElt.group, formattingElt.ns, formattingElt.name, clone, formattingElt.scoping, formattingElt.special, formattingElt.fosterParenting, formattingElt.popName);
            this.appendChildrenToNewParent(furthestBlock.node, clone);
            this.appendElement(clone, furthestBlock.node);
            this.removeFromListOfActiveFormattingElements(formattingEltListPos);
            this.insertIntoListOfActiveFormattingElements(formattingClone, bookmark);
            assert (formattingEltStackPos < furthestBlockPos);
            this.removeFromStack(formattingEltStackPos);
            this.insertIntoStack(formattingClone, furthestBlockPos);
            Portability.releaseElement(clone);
        }
    }

    private void insertIntoStack(StackNode<T> node, int position) throws SAXException {
        assert (this.currentPtr + 1 < this.stack.length);
        assert (position <= this.currentPtr + 1);
        if (position == this.currentPtr + 1) {
            this.flushCharacters();
            this.push(node);
        } else {
            System.arraycopy(this.stack, position, this.stack, position + 1, this.currentPtr - position + 1);
            ++this.currentPtr;
            this.stack[position] = node;
        }
    }

    private void insertIntoListOfActiveFormattingElements(StackNode<T> formattingClone, int bookmark) {
        formattingClone.retain();
        assert (this.listPtr + 1 < this.listOfActiveFormattingElements.length);
        if (bookmark <= this.listPtr) {
            System.arraycopy(this.listOfActiveFormattingElements, bookmark, this.listOfActiveFormattingElements, bookmark + 1, this.listPtr - bookmark + 1);
        }
        ++this.listPtr;
        this.listOfActiveFormattingElements[bookmark] = formattingClone;
    }

    private int findInListOfActiveFormattingElements(StackNode<T> node) {
        for (int i = this.listPtr; i >= 0; --i) {
            if (node != this.listOfActiveFormattingElements[i]) continue;
            return i;
        }
        return -1;
    }

    private int findInListOfActiveFormattingElementsContainsBetweenEndAndLastMarker(@Local String name) {
        for (int i = this.listPtr; i >= 0; --i) {
            StackNode<T> node = this.listOfActiveFormattingElements[i];
            if (node == null) {
                return -1;
            }
            if (node.name != name) continue;
            return i;
        }
        return -1;
    }

    private int findLastOrRoot(@Local String name) {
        for (int i = this.currentPtr; i > 0; --i) {
            if (this.stack[i].name != name) continue;
            return i;
        }
        return 0;
    }

    private int findLastOrRoot(int group) {
        for (int i = this.currentPtr; i > 0; --i) {
            if (this.stack[i].group != group) continue;
            return i;
        }
        return 0;
    }

    private void addAttributesToBody(HtmlAttributes attributes) throws SAXException {
        this.checkAttributes(attributes, "http://www.w3.org/1999/xhtml");
        if (this.currentPtr >= 1) {
            StackNode<T> body = this.stack[1];
            if (body.group == 3) {
                this.addAttributesToElement(body.node, attributes);
            }
        }
    }

    private void addAttributesToHtml(HtmlAttributes attributes) throws SAXException {
        this.checkAttributes(attributes, "http://www.w3.org/1999/xhtml");
        this.addAttributesToElement(this.stack[0].node, attributes);
    }

    private void pushHeadPointerOntoStack() throws SAXException {
        this.flushCharacters();
        this.fatal();
        if (this.headPointer == null) {
            assert (this.fragment);
            this.push(this.stack[this.currentPtr]);
        } else {
            this.push(new StackNode<T>("http://www.w3.org/1999/xhtml", ElementName.HEAD, this.headPointer));
        }
    }

    private void reconstructTheActiveFormattingElements() throws SAXException {
        if (this.listPtr == -1) {
            return;
        }
        StackNode<T> mostRecent = this.listOfActiveFormattingElements[this.listPtr];
        if (mostRecent == null || this.isInStack(mostRecent)) {
            return;
        }
        int entryPos = this.listPtr;
        while (--entryPos != -1 && this.listOfActiveFormattingElements[entryPos] != null && !this.isInStack(this.listOfActiveFormattingElements[entryPos])) {
        }
        if (entryPos < this.listPtr) {
            this.flushCharacters();
        }
        while (entryPos < this.listPtr) {
            StackNode<T> entry = this.listOfActiveFormattingElements[++entryPos];
            Object clone = this.shallowClone(entry.node);
            StackNode entryClone = new StackNode(entry.group, entry.ns, entry.name, clone, entry.scoping, entry.special, entry.fosterParenting, entry.popName);
            StackNode<T> currentNode = this.stack[this.currentPtr];
            if (currentNode.fosterParenting) {
                this.insertIntoFosterParent(clone);
            } else {
                this.appendElement(clone, currentNode.node);
            }
            this.push(entryClone);
            this.listOfActiveFormattingElements[entryPos] = entryClone;
            entry.release();
            entryClone.retain();
        }
    }

    private void insertIntoFosterParent(T child) throws SAXException {
        int eltPos = this.findLastOrRoot(34);
        StackNode<T> node = this.stack[eltPos];
        Object elt = node.node;
        if (eltPos == 0) {
            this.appendElement(child, elt);
            return;
        }
        this.insertFosterParentedChild(child, elt, this.stack[eltPos - 1].node);
    }

    private boolean isInStack(StackNode<T> node) {
        for (int i = this.currentPtr; i >= 0; --i) {
            if (this.stack[i] != node) continue;
            return true;
        }
        return false;
    }

    private void pop() throws SAXException {
        this.flushCharacters();
        StackNode<T> node = this.stack[this.currentPtr];
        assert (this.clearLastStackSlot());
        --this.currentPtr;
        this.elementPopped(node.ns, node.popName, node.node);
        node.release();
    }

    private void checkAttributes(HtmlAttributes attributes, @NsUri String ns) throws SAXException {
        if (this.errorHandler != null) {
            int len = attributes.getXmlnsLength();
            block12: for (int i = 0; i < len; ++i) {
                String xmlns;
                AttributeName name = attributes.getXmlnsAttributeName(i);
                if (name == AttributeName.XMLNS) {
                    if (this.html4) {
                        this.err("Attribute \u201cxmlns\u201d not allowed here. (HTML4-only error.)");
                        continue;
                    }
                    xmlns = attributes.getXmlnsValue(i);
                    if (ns.equals(xmlns)) continue;
                    this.err("Bad value \u201c" + xmlns + "\u201d for the attribute \u201cxmlns\u201d (only \u201c" + ns + "\u201d permitted here).");
                    switch (this.namePolicy) {
                        case ALTER_INFOSET: 
                        case ALLOW: {
                            this.warn("Attribute \u201cxmlns\u201d is not serializable as XML 1.0.");
                            break;
                        }
                        case FATAL: {
                            this.fatal("Attribute \u201cxmlns\u201d is not serializable as XML 1.0.");
                        }
                    }
                    continue;
                }
                if (ns != "http://www.w3.org/1999/xhtml" && name == AttributeName.XMLNS_XLINK) {
                    xmlns = attributes.getXmlnsValue(i);
                    if ("http://www.w3org/1999/xlink".equals(xmlns)) continue;
                    this.err("Bad value \u201c" + xmlns + "\u201d for the attribute \u201cxmlns:link\u201d (only \u201chttp://www.w3org/1999/xlink\u201d permitted here).");
                    switch (this.namePolicy) {
                        case ALTER_INFOSET: 
                        case ALLOW: {
                            this.warn("Attribute \u201cxmlns:xlink\u201d with the value \u201chttp://www.w3org/1999/xlink\u201d is not serializable as XML 1.0 without changing document semantics.");
                            break;
                        }
                        case FATAL: {
                            this.fatal("Attribute \u201cxmlns:xlink\u201d with the value \u201chttp://www.w3org/1999/xlink\u201d is not serializable as XML 1.0 without changing document semantics.");
                        }
                    }
                    continue;
                }
                this.err("Attribute \u201c" + attributes.getLocalName(i) + "\u201d not allowed here.");
                switch (this.namePolicy) {
                    case ALTER_INFOSET: 
                    case ALLOW: {
                        this.warn("Attribute with the local name \u201c" + attributes.getLocalName(i) + "\u201d is not serializable as XML 1.0.");
                        continue block12;
                    }
                    case FATAL: {
                        this.fatal("Attribute with the local name \u201c" + attributes.getLocalName(i) + "\u201d is not serializable as XML 1.0.");
                    }
                }
            }
        }
        attributes.processNonNcNames(this, this.namePolicy);
    }

    private String checkPopName(@Local String name) throws SAXException {
        if (NCName.isNCName(name)) {
            return name;
        }
        switch (this.namePolicy) {
            case ALLOW: {
                this.warn("Element name \u201c" + name + "\u201d cannot be represented as XML 1.0.");
                return name;
            }
            case ALTER_INFOSET: {
                this.warn("Element name \u201c" + name + "\u201d cannot be represented as XML 1.0.");
                return NCName.escapeName(name);
            }
            case FATAL: {
                this.fatal("Element name \u201c" + name + "\u201d cannot be represented as XML 1.0.");
            }
        }
        return null;
    }

    private void appendHtmlElementToDocumentAndPush(HtmlAttributes attributes) throws SAXException {
        this.checkAttributes(attributes, "http://www.w3.org/1999/xhtml");
        T elt = this.createHtmlElementSetAsRoot(attributes);
        StackNode<T> node = new StackNode<T>("http://www.w3.org/1999/xhtml", ElementName.HTML, elt);
        this.push(node);
        Portability.releaseElement(elt);
    }

    private void appendHtmlElementToDocumentAndPush() throws SAXException {
        this.appendHtmlElementToDocumentAndPush(this.tokenizer.emptyAttributes());
    }

    private void appendToCurrentNodeAndPushHeadElement(HtmlAttributes attributes) throws SAXException {
        this.flushCharacters();
        this.checkAttributes(attributes, "http://www.w3.org/1999/xhtml");
        T elt = this.createElement("http://www.w3.org/1999/xhtml", "head", attributes);
        this.appendElement(elt, this.stack[this.currentPtr].node);
        this.headPointer = elt;
        Portability.retainElement(this.headPointer);
        StackNode<T> node = new StackNode<T>("http://www.w3.org/1999/xhtml", ElementName.HEAD, elt);
        this.push(node);
        Portability.releaseElement(elt);
    }

    private void appendToCurrentNodeAndPushBodyElement(HtmlAttributes attributes) throws SAXException {
        this.appendToCurrentNodeAndPushElement("http://www.w3.org/1999/xhtml", ElementName.BODY, attributes);
    }

    private void appendToCurrentNodeAndPushBodyElement() throws SAXException {
        this.appendToCurrentNodeAndPushBodyElement(this.tokenizer.emptyAttributes());
    }

    private void appendToCurrentNodeAndPushFormElementMayFoster(HtmlAttributes attributes) throws SAXException {
        this.flushCharacters();
        this.checkAttributes(attributes, "http://www.w3.org/1999/xhtml");
        T elt = this.createElement("http://www.w3.org/1999/xhtml", "form", attributes);
        this.formPointer = elt;
        Portability.retainElement(this.formPointer);
        StackNode<T> current = this.stack[this.currentPtr];
        if (current.fosterParenting) {
            this.fatal();
            this.insertIntoFosterParent(elt);
        } else {
            this.appendElement(elt, current.node);
        }
        StackNode<T> node = new StackNode<T>("http://www.w3.org/1999/xhtml", ElementName.FORM, elt);
        this.push(node);
        Portability.releaseElement(elt);
    }

    private void appendToCurrentNodeAndPushFormattingElementMayFoster(@NsUri String ns, ElementName elementName, HtmlAttributes attributes) throws SAXException {
        this.flushCharacters();
        this.checkAttributes(attributes, ns);
        T elt = this.createElement(ns, elementName.name, attributes);
        StackNode<T> current = this.stack[this.currentPtr];
        if (current.fosterParenting) {
            this.fatal();
            this.insertIntoFosterParent(elt);
        } else {
            this.appendElement(elt, current.node);
        }
        StackNode<T> node = new StackNode<T>(ns, elementName, elt);
        this.push(node);
        this.append(node);
        node.retain();
        Portability.releaseElement(elt);
    }

    private void appendToCurrentNodeAndPushElement(@NsUri String ns, ElementName elementName, HtmlAttributes attributes) throws SAXException {
        this.flushCharacters();
        this.checkAttributes(attributes, ns);
        T elt = this.createElement(ns, elementName.name, attributes);
        this.appendElement(elt, this.stack[this.currentPtr].node);
        StackNode<T> node = new StackNode<T>(ns, elementName, elt);
        this.push(node);
        Portability.releaseElement(elt);
    }

    private void appendToCurrentNodeAndPushElementMayFoster(@NsUri String ns, ElementName elementName, HtmlAttributes attributes) throws SAXException {
        this.flushCharacters();
        String popName = elementName.name;
        this.checkAttributes(attributes, ns);
        if (elementName.custom) {
            popName = this.checkPopName(popName);
        }
        T elt = this.createElement(ns, popName, attributes);
        StackNode<T> current = this.stack[this.currentPtr];
        if (current.fosterParenting) {
            this.fatal();
            this.insertIntoFosterParent(elt);
        } else {
            this.appendElement(elt, current.node);
        }
        StackNode<T> node = new StackNode<T>(ns, elementName, elt, popName);
        this.push(node);
        Portability.releaseElement(elt);
    }

    private void appendToCurrentNodeAndPushElementMayFosterNoScoping(@NsUri String ns, ElementName elementName, HtmlAttributes attributes) throws SAXException {
        this.flushCharacters();
        String popName = elementName.name;
        this.checkAttributes(attributes, ns);
        if (elementName.custom) {
            popName = this.checkPopName(popName);
        }
        T elt = this.createElement(ns, popName, attributes);
        StackNode<T> current = this.stack[this.currentPtr];
        if (current.fosterParenting) {
            this.fatal();
            this.insertIntoFosterParent(elt);
        } else {
            this.appendElement(elt, current.node);
        }
        StackNode<T> node = new StackNode<T>(ns, elementName, elt, popName, false);
        this.push(node);
        Portability.releaseElement(elt);
    }

    private void appendToCurrentNodeAndPushElementMayFosterCamelCase(@NsUri String ns, ElementName elementName, HtmlAttributes attributes) throws SAXException {
        this.flushCharacters();
        String popName = elementName.camelCaseName;
        this.checkAttributes(attributes, ns);
        if (elementName.custom) {
            popName = this.checkPopName(popName);
        }
        T elt = this.createElement(ns, popName, attributes);
        StackNode<T> current = this.stack[this.currentPtr];
        if (current.fosterParenting) {
            this.fatal();
            this.insertIntoFosterParent(elt);
        } else {
            this.appendElement(elt, current.node);
        }
        StackNode<T> node = new StackNode<T>(ns, elementName, elt, popName, ElementName.FOREIGNOBJECT == elementName);
        this.push(node);
        Portability.releaseElement(elt);
    }

    private void appendToCurrentNodeAndPushElementMayFoster(@NsUri String ns, ElementName elementName, HtmlAttributes attributes, T form) throws SAXException {
        this.flushCharacters();
        this.checkAttributes(attributes, ns);
        T elt = this.createElement(ns, elementName.name, attributes, form);
        StackNode<T> current = this.stack[this.currentPtr];
        if (current.fosterParenting) {
            this.fatal();
            this.insertIntoFosterParent(elt);
        } else {
            this.appendElement(elt, current.node);
        }
        StackNode<T> node = new StackNode<T>(ns, elementName, elt);
        this.push(node);
        Portability.releaseElement(elt);
    }

    private void appendVoidElementToCurrentMayFoster(@NsUri String ns, @Local String name, HtmlAttributes attributes, T form) throws SAXException {
        this.flushCharacters();
        this.checkAttributes(attributes, ns);
        T elt = this.createElement(ns, name, attributes, form);
        StackNode<T> current = this.stack[this.currentPtr];
        if (current.fosterParenting) {
            this.fatal();
            this.insertIntoFosterParent(elt);
        } else {
            this.appendElement(elt, current.node);
        }
        this.elementPushed(ns, name, elt);
        this.elementPopped(ns, name, elt);
        Portability.releaseElement(elt);
    }

    private void appendVoidElementToCurrentMayFoster(@NsUri String ns, ElementName elementName, HtmlAttributes attributes) throws SAXException {
        this.flushCharacters();
        String popName = elementName.name;
        this.checkAttributes(attributes, ns);
        if (elementName.custom) {
            popName = this.checkPopName(popName);
        }
        T elt = this.createElement(ns, popName, attributes);
        StackNode<T> current = this.stack[this.currentPtr];
        if (current.fosterParenting) {
            this.fatal();
            this.insertIntoFosterParent(elt);
        } else {
            this.appendElement(elt, current.node);
        }
        this.elementPushed(ns, popName, elt);
        this.elementPopped(ns, popName, elt);
        Portability.releaseElement(elt);
    }

    private void appendVoidElementToCurrentMayFosterCamelCase(@NsUri String ns, ElementName elementName, HtmlAttributes attributes) throws SAXException {
        this.flushCharacters();
        String popName = elementName.camelCaseName;
        this.checkAttributes(attributes, ns);
        if (elementName.custom) {
            popName = this.checkPopName(popName);
        }
        T elt = this.createElement(ns, popName, attributes);
        StackNode<T> current = this.stack[this.currentPtr];
        if (current.fosterParenting) {
            this.fatal();
            this.insertIntoFosterParent(elt);
        } else {
            this.appendElement(elt, current.node);
        }
        this.elementPushed(ns, popName, elt);
        this.elementPopped(ns, popName, elt);
        Portability.releaseElement(elt);
    }

    private void appendVoidElementToCurrent(@NsUri String ns, @Local String name, HtmlAttributes attributes, T form) throws SAXException {
        this.flushCharacters();
        this.checkAttributes(attributes, ns);
        T elt = this.createElement(ns, name, attributes, form);
        StackNode<T> current = this.stack[this.currentPtr];
        this.appendElement(elt, current.node);
        this.elementPushed(ns, name, elt);
        this.elementPopped(ns, name, elt);
        Portability.releaseElement(elt);
    }

    protected void accumulateCharacters(@NoLength char[] buf, int start, int length) throws SAXException {
        this.appendCharacters(this.stack[this.currentPtr].node, buf, start, length);
    }

    protected final void accumulateCharacter(char c) throws SAXException {
        int newLen = this.charBufferLen + 1;
        if (newLen > this.charBuffer.length) {
            char[] newBuf = new char[newLen];
            System.arraycopy(this.charBuffer, 0, newBuf, 0, this.charBufferLen);
            Portability.releaseArray(this.charBuffer);
            this.charBuffer = newBuf;
        }
        this.charBuffer[this.charBufferLen] = c;
        this.charBufferLen = newLen;
    }

    protected final void requestSuspension() {
        this.tokenizer.requestSuspension();
    }

    protected abstract T createElement(@NsUri String var1, @Local String var2, HtmlAttributes var3) throws SAXException;

    protected T createElement(@NsUri String ns, @Local String name, HtmlAttributes attributes, T form) throws SAXException {
        return this.createElement("http://www.w3.org/1999/xhtml", name, attributes);
    }

    protected abstract T createHtmlElementSetAsRoot(HtmlAttributes var1) throws SAXException;

    protected abstract void detachFromParent(T var1) throws SAXException;

    protected abstract boolean hasChildren(T var1) throws SAXException;

    protected abstract T shallowClone(T var1) throws SAXException;

    protected abstract void appendElement(T var1, T var2) throws SAXException;

    protected abstract void appendChildrenToNewParent(T var1, T var2) throws SAXException;

    protected abstract void insertFosterParentedChild(T var1, T var2, T var3) throws SAXException;

    protected abstract void insertFosterParentedCharacters(@NoLength char[] var1, int var2, int var3, T var4, T var5) throws SAXException;

    protected abstract void appendCharacters(T var1, @NoLength char[] var2, int var3, int var4) throws SAXException;

    protected abstract void appendComment(T var1, @NoLength char[] var2, int var3, int var4) throws SAXException;

    protected abstract void appendCommentToDocument(@NoLength char[] var1, int var2, int var3) throws SAXException;

    protected abstract void addAttributesToElement(T var1, HtmlAttributes var2) throws SAXException;

    protected void start(boolean fragment) throws SAXException {
    }

    protected void end() throws SAXException {
    }

    protected void appendDoctypeToDocument(@Local String name, String publicIdentifier, String systemIdentifier) throws SAXException {
    }

    protected void elementPushed(@NsUri String ns, @Local String name, T node) throws SAXException {
    }

    protected void elementPopped(@NsUri String ns, @Local String name, T node) throws SAXException {
    }

    protected void documentMode(DocumentMode m, String publicIdentifier, String systemIdentifier, boolean html4SpecificAdditionalErrorChecks) throws SAXException {
    }

    @Override
    public boolean wantsComments() {
        return this.wantingComments;
    }

    public void setIgnoringComments(boolean ignoreComments) {
        this.wantingComments = !ignoreComments;
    }

    public final void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public final void setFragmentContext(@Local String context) {
        this.contextName = context;
        this.contextNamespace = "http://www.w3.org/1999/xhtml";
        this.contextNode = null;
        this.fragment = this.contextName != null;
        this.quirks = false;
    }

    public final void setFragmentContext(@Local String context, @NsUri String ns, T node, boolean quirks) {
        this.contextName = context;
        Portability.retainLocal(context);
        this.contextNamespace = ns;
        this.contextNode = node;
        Portability.retainElement(node);
        this.fragment = this.contextName != null;
        this.quirks = quirks;
    }

    protected final T currentNode() {
        return this.stack[this.currentPtr].node;
    }

    public boolean isScriptingEnabled() {
        return this.scriptingEnabled;
    }

    public void setScriptingEnabled(boolean scriptingEnabled) {
        this.scriptingEnabled = scriptingEnabled;
    }

    public void setDoctypeExpectation(DoctypeExpectation doctypeExpectation) {
        this.doctypeExpectation = doctypeExpectation;
    }

    public void setNamePolicy(XmlViolationPolicy namePolicy) {
        this.namePolicy = namePolicy;
    }

    public void setDocumentModeHandler(DocumentModeHandler documentModeHandler) {
        this.documentModeHandler = documentModeHandler;
    }

    public void setReportingDoctype(boolean reportingDoctype) {
        this.reportingDoctype = reportingDoctype;
    }

    @Override
    public boolean inForeign() throws SAXException {
        return this.foreignFlag == 0;
    }

    private final void flushCharacters() throws SAXException {
        if (this.charBufferLen > 0) {
            StackNode<T> current = this.stack[this.currentPtr];
            if (current.fosterParenting && this.charBufferContainsNonWhitespace()) {
                this.err("Misplaced non-space characters insided a table.");
                int eltPos = this.findLastOrRoot(34);
                StackNode<T> node = this.stack[eltPos];
                Object elt = node.node;
                if (eltPos == 0) {
                    this.appendCharacters(elt, this.charBuffer, 0, this.charBufferLen);
                    this.charBufferLen = 0;
                    return;
                }
                this.insertFosterParentedCharacters(this.charBuffer, 0, this.charBufferLen, elt, this.stack[eltPos - 1].node);
                this.charBufferLen = 0;
                return;
            }
            this.appendCharacters(this.currentNode(), this.charBuffer, 0, this.charBufferLen);
            this.charBufferLen = 0;
        }
    }

    private boolean charBufferContainsNonWhitespace() {
        block3: for (int i = 0; i < this.charBufferLen; ++i) {
            switch (this.charBuffer[i]) {
                case '\t': 
                case '\n': 
                case '\f': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return true;
                }
            }
        }
        return false;
    }

    public StateSnapshot<T> newSnapshot() {
        StackNode[] stackCopy = new StackNode[this.currentPtr + 1];
        for (int i = 0; i < stackCopy.length; ++i) {
            stackCopy[i] = this.stack[i];
            stackCopy[i].retain();
        }
        StackNode[] listCopy = new StackNode[this.listPtr + 1];
        for (int i = 0; i < listCopy.length; ++i) {
            StackNode<T> node = this.listOfActiveFormattingElements[i];
            if (node != null) {
                node.retain();
            }
            listCopy[i] = node;
        }
        Portability.retainElement(this.formPointer);
        return new StateSnapshot<T>(stackCopy, listCopy, this.formPointer);
    }

    public boolean snapshotMatches(StateSnapshot<T> snapshot) {
        int i;
        StackNode<T>[] stackCopy = snapshot.stack;
        StackNode<T>[] listCopy = snapshot.listOfActiveFormattingElements;
        if (stackCopy.length != this.currentPtr + 1 || listCopy.length != this.listPtr + 1 || this.formPointer != snapshot.formPointer) {
            return false;
        }
        for (i = listCopy.length - 1; i >= 0; --i) {
            if (listCopy[i] == this.listOfActiveFormattingElements[i]) continue;
            return false;
        }
        for (i = listCopy.length - 1; i >= 0; --i) {
            if (listCopy[i] == this.listOfActiveFormattingElements[i]) continue;
            return false;
        }
        return true;
    }
}

