/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.metamodel.type;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.chromattic.api.TypeConversionException;
import org.chromattic.spi.type.SimpleTypeProvider;

public class SimpleTypeProviders {
    private SimpleTypeProviders() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class TIMESTAMP
    extends SimpleTypeProvider.DATE<Long> {
        public Class<Long> getExternalType() {
            return Long.class;
        }

        public Calendar getInternal(Long l) throws TypeConversionException {
            Calendar c = Calendar.getInstance();
            c.setTimeInMillis(l);
            return c;
        }

        public Long getExternal(Calendar calendar) throws TypeConversionException {
            return calendar.getTimeInMillis();
        }

        public Long fromString(String s) throws TypeConversionException {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                Calendar c = Calendar.getInstance();
                c.setTime(sdf.parse(s));
                return c.getTimeInMillis();
            }
            catch (ParseException e) {
                throw new TypeConversionException((Throwable)e);
            }
        }

        public String toString(Long l) throws TypeConversionException {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            Calendar c = Calendar.getInstance();
            c.setTimeInMillis(l);
            return sdf.format(c);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CALENDAR
    extends SimpleTypeProvider.DATE<Calendar> {
        public Class<Calendar> getExternalType() {
            return Calendar.class;
        }

        public Calendar getInternal(Calendar calendar) throws TypeConversionException {
            return calendar;
        }

        public Calendar getExternal(Calendar calendar) throws TypeConversionException {
            return calendar;
        }

        public Calendar fromString(String s) throws TypeConversionException {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                Calendar c = Calendar.getInstance();
                c.setTime(sdf.parse(s));
                return c;
            }
            catch (ParseException e) {
                throw new TypeConversionException((Throwable)e);
            }
        }

        public String toString(Calendar calendar) throws TypeConversionException {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            return sdf.format(calendar.getTime());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DATE
    extends SimpleTypeProvider.DATE<Date> {
        public Calendar getInternal(Date date) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            return calendar;
        }

        public Date getExternal(Calendar calendar) {
            return calendar.getTime();
        }

        public Date fromString(String s) throws TypeConversionException {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                return sdf.parse(s);
            }
            catch (ParseException e) {
                throw new TypeConversionException((Throwable)e);
            }
        }

        public String toString(Date date) throws TypeConversionException {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            return sdf.format(date);
        }

        public Class<Date> getExternalType() {
            return Date.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class BYTE_ARRAY
    extends SimpleTypeProvider.BINARY<byte[]> {
        public Class<byte[]> getExternalType() {
            return byte[].class;
        }

        public InputStream getInternal(byte[] bytes) throws TypeConversionException {
            return new ByteArrayInputStream(bytes);
        }

        public byte[] getExternal(InputStream inputStream) throws TypeConversionException {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[256];
                int l = inputStream.read(buffer);
                while (l != -1) {
                    baos.write(buffer, 0, l);
                    l = inputStream.read(buffer);
                }
                return baos.toByteArray();
            }
            catch (IOException e) {
                throw new TypeConversionException((Throwable)e);
            }
        }

        public byte[] fromString(String s) throws TypeConversionException {
            throw new UnsupportedOperationException();
        }

        public String toString(byte[] bytes) throws TypeConversionException {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class BINARY
    extends SimpleTypeProvider.BINARY<InputStream> {
        public InputStream getInternal(InputStream inputStream) {
            return inputStream;
        }

        public InputStream getExternal(InputStream inputStream) {
            return inputStream;
        }

        public InputStream fromString(String s) {
            throw new UnsupportedOperationException();
        }

        public String toString(InputStream inputStream) throws TypeConversionException {
            throw new UnsupportedOperationException();
        }

        public Class<InputStream> getExternalType() {
            return InputStream.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class BOOLEAN
    extends SimpleTypeProvider.BOOLEAN<Boolean> {
        public Boolean getInternal(Boolean external) {
            return external;
        }

        public Boolean getExternal(Boolean internal) {
            return internal;
        }

        public Boolean fromString(String s) {
            return Boolean.parseBoolean(s);
        }

        public String toString(Boolean aBoolean) throws TypeConversionException {
            return aBoolean.toString();
        }

        public Class<Boolean> getExternalType() {
            return Boolean.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class FLOAT
    extends SimpleTypeProvider.DOUBLE<Float> {
        public Double getInternal(Float external) {
            return external.floatValue();
        }

        public Float getExternal(Double internal) {
            return Float.valueOf((float)internal.doubleValue());
        }

        public Float fromString(String s) {
            return Float.valueOf(Float.parseFloat(s));
        }

        public String toString(Float aFloat) throws TypeConversionException {
            return aFloat.toString();
        }

        public Class<Float> getExternalType() {
            return Float.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DOUBLE
    extends SimpleTypeProvider.DOUBLE<Double> {
        public Double getInternal(Double external) {
            return external;
        }

        public Double getExternal(Double internal) {
            return internal;
        }

        public Double fromString(String s) {
            return Double.parseDouble(s);
        }

        public String toString(Double aDouble) throws TypeConversionException {
            return aDouble.toString();
        }

        public Class<Double> getExternalType() {
            return Double.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class LONG
    extends SimpleTypeProvider.LONG<Long> {
        public Long getInternal(Long external) {
            return external;
        }

        public Long getExternal(Long internal) {
            return internal;
        }

        public Long fromString(String s) {
            return Long.parseLong(s);
        }

        public String toString(Long aLong) throws TypeConversionException {
            return aLong.toString();
        }

        public Class<Long> getExternalType() {
            return Long.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class INTEGER
    extends SimpleTypeProvider.LONG<Integer> {
        public Long getInternal(Integer external) {
            return (long)external;
        }

        public Integer getExternal(Long internal) {
            return (int)internal.longValue();
        }

        public Integer fromString(String s) {
            return Integer.parseInt(s);
        }

        public String toString(Integer integer) throws TypeConversionException {
            return integer.toString();
        }

        public Class<Integer> getExternalType() {
            return Integer.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class NAME
    extends SimpleTypeProvider.NAME<String> {
        public String getInternal(String s) {
            return s;
        }

        public String getExternal(String s) {
            return s;
        }

        public String fromString(String s) {
            return s;
        }

        public String toString(String s) throws TypeConversionException {
            return s;
        }

        public Class<String> getExternalType() {
            return String.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PATH
    extends SimpleTypeProvider.PATH<String> {
        public String getInternal(String s) {
            return s;
        }

        public String getExternal(String s) {
            return s;
        }

        public String fromString(String s) {
            return s;
        }

        public String toString(String s) throws TypeConversionException {
            return s;
        }

        public Class<String> getExternalType() {
            return String.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class STRING
    extends SimpleTypeProvider.STRING<String> {
        public String getInternal(String s) {
            return s;
        }

        public String getExternal(String s) {
            return s;
        }

        public String fromString(String s) {
            return s;
        }

        public String toString(String s) throws TypeConversionException {
            return s;
        }

        public Class<String> getExternalType() {
            return String.class;
        }
    }
}

