/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.util;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XmlUtils {
    private static final Log LOG = LogFactory.getLog(XmlUtils.class);

    public static XMLReader getXmlReader() {
        try {
            return XMLReaderFactory.createXMLReader();
        }
        catch (SAXException e) {
            throw new RuntimeException("Unable to create XMLReader", e);
        }
    }

    public static List<String> getTextForElements(String xmlAsString, final String element) {
        final ArrayList<String> elements = new ArrayList<String>(2);
        XMLReader reader = XmlUtils.getXmlReader();
        DefaultHandler handler = new DefaultHandler(){
            private boolean foundElement = false;
            private StringBuilder buffer = new StringBuilder();

            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if (localName.equals(element)) {
                    this.foundElement = true;
                }
            }

            public void endElement(String uri, String localName, String qName) throws SAXException {
                if (localName.equals(element)) {
                    this.foundElement = false;
                    elements.add(this.buffer.toString());
                    this.buffer = new StringBuilder();
                }
            }

            public void characters(char[] ch, int start, int length) throws SAXException {
                if (this.foundElement) {
                    this.buffer.append(ch, start, length);
                }
            }
        };
        reader.setContentHandler(handler);
        reader.setErrorHandler(handler);
        try {
            reader.parse(new InputSource(new StringReader(xmlAsString)));
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            return null;
        }
        return elements;
    }

    public static String getTextForElement(String xmlAsString, final String element) {
        XMLReader reader = XmlUtils.getXmlReader();
        final StringBuilder builder = new StringBuilder();
        DefaultHandler handler = new DefaultHandler(){
            private boolean foundElement = false;

            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if (localName.equals(element)) {
                    this.foundElement = true;
                }
            }

            public void endElement(String uri, String localName, String qName) throws SAXException {
                if (localName.equals(element)) {
                    this.foundElement = false;
                }
            }

            public void characters(char[] ch, int start, int length) throws SAXException {
                if (this.foundElement) {
                    builder.append(ch, start, length);
                }
            }
        };
        reader.setContentHandler(handler);
        reader.setErrorHandler(handler);
        try {
            reader.parse(new InputSource(new StringReader(xmlAsString)));
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            return null;
        }
        return builder.toString();
    }
}

