/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.spi.portlet;

import java.io.IOException;
import java.util.Map;
import javax.portlet.ClientDataRequest;
import javax.portlet.PortletConfig;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import juzu.PropertyType;
import juzu.Response;
import juzu.impl.bridge.Bridge;
import juzu.impl.bridge.spi.ResourceBridge;
import juzu.impl.bridge.spi.portlet.PortletClientContext;
import juzu.impl.bridge.spi.portlet.PortletMimeBridge;
import juzu.request.ClientContext;
import juzu.request.Phase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletResourceBridge
extends PortletMimeBridge<ResourceRequest, ResourceResponse>
implements ResourceBridge {
    private final PortletClientContext clientContext;

    public PortletResourceBridge(Bridge bridge, ResourceRequest request, ResourceResponse response, PortletConfig config) {
        super(bridge, request, response, config);
        this.clientContext = new PortletClientContext((ClientDataRequest)request);
    }

    @Override
    protected Phase getPhase() {
        return Phase.RESOURCE;
    }

    @Override
    public ClientContext getClientContext() {
        return this.clientContext;
    }

    @Override
    protected void sendProperties() throws IOException {
        if (this.response instanceof Response.Content) {
            Iterable<Map.Entry<String, String[]>> headers;
            Response.Content resource = (Response.Content)this.response;
            int status = resource.getStatus();
            if (status != 200) {
                ((ResourceResponse)this.resp).setProperty("portlet.http-status-code", Integer.toString(status));
            }
            if ((headers = resource.getProperties().getValues(PropertyType.HEADER)) != null) {
                for (Map.Entry<String, String[]> header : headers) {
                    String[] values = header.getValue();
                    if (values.length <= 0) continue;
                    ((ResourceResponse)this.resp).setProperty(header.getKey(), values[0]);
                }
            }
            super.setResponse(this.response);
        }
    }
}

