/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import juzu.impl.common.Tools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTrie<K, T extends AbstractTrie<K, T>>
implements Iterable<K> {
    final T parent;
    final List<K> path;
    final K key;
    private Map<K, T> entries;

    protected AbstractTrie() {
        this.parent = null;
        this.path = Collections.emptyList();
        this.key = null;
    }

    protected AbstractTrie(T parent, K key) {
        ArrayList<K> path = new ArrayList<K>(((AbstractTrie)parent).path.size() + 1);
        path.addAll(((AbstractTrie)parent).path);
        path.add(key);
        this.parent = parent;
        this.path = Collections.unmodifiableList(path);
        this.key = key;
    }

    protected abstract T create(T var1, K var2);

    public final T getParent() {
        return this.parent;
    }

    public final K getKey() {
        return this.key;
    }

    @Override
    public final Iterator<K> iterator() {
        return this.entries != null ? this.entries.keySet().iterator() : Tools.emptyIterator();
    }

    public final Iterable<K> getPath() {
        return this.path;
    }

    public final Iterator<T> getEntries() {
        return this.entries.values().iterator();
    }

    public final T get(K ... keys) {
        return this.get(keys, 0, keys.length);
    }

    public final T get(K key) {
        if (this.entries != null) {
            return (T)((AbstractTrie)this.entries.get(key));
        }
        return null;
    }

    public final T get(K[] keys, int from, int to) {
        K key;
        T entry;
        AbstractTrie<K, T> ret = from == to ? this : ((entry = this.get(key = keys[from])) != null ? ((AbstractTrie)entry).get(keys, from + 1, to) : null);
        return (T)ret;
    }

    public final T get(Iterator<K> keys) {
        K key;
        T entry;
        AbstractTrie<K, T> ret = keys.hasNext() ? ((entry = this.get(key = keys.next())) != null ? ((AbstractTrie)entry).get(keys) : null) : this;
        return (T)ret;
    }

    public final T add(K key) {
        AbstractTrie entry;
        if (this.entries == null) {
            this.entries = new HashMap<K, T>();
            entry = null;
        } else {
            entry = (AbstractTrie)this.entries.get(key);
        }
        if (entry == null) {
            entry = this.create(this, key);
            this.entries.put(key, entry);
        }
        return (T)entry;
    }

    public final T add(K ... keys) {
        return this.add(keys, 0, keys.length);
    }

    public final T add(K[] keys, int from, int to) {
        if (from == to) {
            return (T)this;
        }
        K key = keys[from];
        T entry = this.add(key);
        return ((AbstractTrie)entry).add(keys, from + 1, to);
    }

    public final T add(Iterator<K> keys) {
        if (keys.hasNext()) {
            K key = keys.next();
            T entry = this.add(key);
            return ((AbstractTrie)entry).add(keys);
        }
        return (T)this;
    }
}

