/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.tree;

import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import org.exoplatform.ecm.webui.comparator.NodeTitleComparator;
import org.exoplatform.ecm.webui.tree.UIBaseNodeTreeSelector;
import org.exoplatform.ecm.webui.tree.UINodeTree;
import org.exoplatform.ecm.webui.tree.selectone.UIOneNodePathSelector;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.services.cms.link.NodeFinder;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIBreadcumbs;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UITree;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(events={@EventConfig(listeners={ChangeNodeActionListener.class})})
public class UINodeTreeBuilder
extends UIContainer {
    private boolean allowPublish = false;
    private PublicationService publicationService_ = null;
    private List<String> templates_ = null;
    private String[] acceptedNodeTypes = new String[0];
    private String[] defaultExceptedNodeTypes = new String[0];
    protected NodeLocation rootTreeNode;
    protected NodeLocation currentNode;

    public boolean isAllowPublish() {
        return this.allowPublish;
    }

    public void setAllowPublish(boolean allowPublish, PublicationService publicationService, List<String> templates) {
        this.allowPublish = allowPublish;
        this.publicationService_ = publicationService;
        this.templates_ = templates;
    }

    public UINodeTreeBuilder() throws Exception {
        UITree tree = (UITree)this.addChild(UINodeTree.class, null, UINodeTree.class.getSimpleName() + ((Object)((Object)this)).hashCode());
        tree.setBeanLabelField("name");
        tree.setBeanIdField("path");
    }

    public Node getRootTreeNode() {
        return NodeLocation.getNodeByLocation((NodeLocation)this.rootTreeNode);
    }

    public final void setRootTreeNode(Node node) throws Exception {
        this.rootTreeNode = NodeLocation.getNodeLocationByNode((Node)node);
        this.currentNode = NodeLocation.getNodeLocationByNode((Node)node);
        this.broadcastOnChange(node, null);
    }

    public Node getCurrentNode() {
        return NodeLocation.getNodeByLocation((NodeLocation)this.currentNode);
    }

    public void setCurrentNode(Node currentNode) {
        this.currentNode = NodeLocation.getNodeLocationByNode((Node)currentNode);
    }

    public String[] getAcceptedNodeTypes() {
        return this.acceptedNodeTypes;
    }

    public void setAcceptedNodeTypes(String[] acceptedNodeTypes) {
        this.acceptedNodeTypes = acceptedNodeTypes;
    }

    public String[] getDefaultExceptedNodeTypes() {
        return this.defaultExceptedNodeTypes;
    }

    public void setDefaultExceptedNodeTypes(String[] defaultExceptedNodeTypes) {
        this.defaultExceptedNodeTypes = defaultExceptedNodeTypes;
    }

    public boolean isExceptedNodeType(Node node) throws RepositoryException {
        if (this.defaultExceptedNodeTypes.length > 0) {
            for (String nodeType : this.defaultExceptedNodeTypes) {
                if (!node.isNodeType(nodeType)) continue;
                return true;
            }
        }
        return false;
    }

    public void buildTree() throws Exception {
        NodeIterator sibbling = null;
        NodeIterator children = null;
        UINodeTree tree = (UINodeTree)this.getChild(UINodeTree.class);
        Node selectedNode = this.getNodeByPathBreadcumbs();
        tree.setSelected(selectedNode);
        if (Utils.getNodeSymLink(selectedNode).getDepth() > 0) {
            tree.setParentSelected(selectedNode.getParent());
            sibbling = Utils.getNodeSymLink(selectedNode).getNodes();
            children = Utils.getNodeSymLink(selectedNode).getNodes();
        } else {
            tree.setParentSelected(selectedNode);
            sibbling = Utils.getNodeSymLink(selectedNode).getNodes();
            children = null;
        }
        if (sibbling != null) {
            tree.setSibbling(this.filfer(sibbling));
        }
        if (children != null) {
            tree.setChildren(this.filfer(children));
        }
    }

    private Node getNodeByPathBreadcumbs() throws PathNotFoundException, RepositoryException {
        UIOneNodePathSelector uiOneNodePathSelector = (UIOneNodePathSelector)this.getParent();
        UIBreadcumbs uiBreadcumbs = (UIBreadcumbs)uiOneNodePathSelector.getChildById("BreadcumbCategoriesOne");
        List listLocalPath = uiBreadcumbs.getPath();
        StringBuilder buffer = new StringBuilder(1024);
        String rootPath = this.rootTreeNode.getPath();
        for (UIBreadcumbs.LocalPath iterLocalPath : listLocalPath) {
            buffer.append("/").append(iterLocalPath.getId());
        }
        String path = buffer.toString();
        if (path.startsWith("//")) {
            path = path.substring(1);
        }
        if (!path.startsWith(rootPath)) {
            StringBuffer sb = new StringBuffer();
            sb.append(rootPath).append(path);
            path = sb.toString();
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.length() == 0) {
            path = "/";
        }
        if (buffer.length() == 0) {
            return NodeLocation.getNodeByLocation((NodeLocation)this.currentNode);
        }
        NodeFinder nodeFinder_ = (NodeFinder)this.getApplicationComponent(NodeFinder.class);
        return (Node)nodeFinder_.getItem(uiOneNodePathSelector.getWorkspaceName(), path);
    }

    private void addNodePublish(List<Node> listNode, Node node, PublicationService publicationService) throws Exception {
        if (this.isAllowPublish()) {
            NodeType nt = node.getPrimaryNodeType();
            if (this.templates_.contains(nt.getName())) {
                Node nodecheck = publicationService.getNodePublish(node, null);
                if (nodecheck != null) {
                    listNode.add(nodecheck);
                }
            } else {
                listNode.add(node);
            }
        } else {
            listNode.add(node);
        }
    }

    private List<Node> filfer(NodeIterator iterator) throws Exception {
        ArrayList<Node> list = new ArrayList<Node>();
        if (this.acceptedNodeTypes.length > 0) {
            block0: while (iterator.hasNext()) {
                Node sibbling = iterator.nextNode();
                if (sibbling.isNodeType("exo:hiddenable")) continue;
                for (String nodetype : this.acceptedNodeTypes) {
                    if (!sibbling.isNodeType(nodetype)) continue;
                    list.add(sibbling);
                    continue block0;
                }
            }
            Collections.sort(list, new NodeTitleComparator("Ascending"));
            ArrayList<Node> listNodeCheck = new ArrayList<Node>();
            for (Node node : list) {
                this.addNodePublish(listNodeCheck, node, this.publicationService_);
            }
            return listNodeCheck;
        }
        while (iterator.hasNext()) {
            Node sibbling = iterator.nextNode();
            if (sibbling.isNodeType("exo:hiddenable") || this.isExceptedNodeType(sibbling)) continue;
            list.add(sibbling);
        }
        Collections.sort(list, new NodeTitleComparator("Ascending"));
        ArrayList<Node> listNodeCheck = new ArrayList<Node>();
        for (Node node : list) {
            this.addNodePublish(listNodeCheck, node, this.publicationService_);
        }
        return listNodeCheck;
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        Writer writer = context.getWriter();
        writer.write("<div class=\"explorerTree\">");
        this.buildTree();
        super.renderChildren();
        writer.write("</div>");
    }

    public void changeNode(String path, Object context) throws Exception {
        NodeFinder nodeFinder_ = (NodeFinder)this.getApplicationComponent(NodeFinder.class);
        String rootPath = this.rootTreeNode.getPath();
        if (rootPath.equals(path) || !path.startsWith(rootPath)) {
            this.currentNode = this.rootTreeNode;
        } else {
            if (path.startsWith(rootPath)) {
                path = path.substring(rootPath.length());
            }
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            this.currentNode = NodeLocation.getNodeLocationByNode((Node)nodeFinder_.getNode(NodeLocation.getNodeByLocation((NodeLocation)this.rootTreeNode), path));
        }
        this.broadcastOnChange(NodeLocation.getNodeByLocation((NodeLocation)this.currentNode), context);
    }

    public void broadcastOnChange(Node node, Object context) throws Exception {
        UIBaseNodeTreeSelector nodeTreeSelector = (UIBaseNodeTreeSelector)this.getAncestorOfType(UIBaseNodeTreeSelector.class);
        nodeTreeSelector.onChange(node, context);
    }

    public static class ChangeNodeActionListener
    extends EventListener<UITree> {
        public void execute(Event<UITree> event) throws Exception {
            UINodeTreeBuilder builder = (UINodeTreeBuilder)((UITree)event.getSource()).getParent();
            String uri = event.getRequestContext().getRequestParameter("objectId");
            builder.changeNode(uri, event.getRequestContext());
            UIBaseNodeTreeSelector nodeTreeSelector = (UIBaseNodeTreeSelector)builder.getAncestorOfType(UIBaseNodeTreeSelector.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)nodeTreeSelector);
        }
    }
}

