/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.linter;

import com.google.caja.ancillary.linter.ExitModes;
import com.google.caja.ancillary.linter.LiveSet;
import com.google.caja.lexer.FilePosition;
import com.google.caja.parser.js.BreakStmt;
import com.google.caja.parser.js.Declaration;
import com.google.caja.parser.js.Identifier;
import junit.framework.TestCase;

public class ExitModesTest
extends TestCase {
    public final void testUnion() {
        ExitModesTest.assertEquals((Object)ExitModes.COMPLETES, (Object)ExitModes.COMPLETES.union(ExitModes.COMPLETES));
        LiveSet x = LiveSet.EMPTY.with(ExitModesTest.decl("x"));
        LiveSet y = LiveSet.EMPTY.with(ExitModesTest.decl("y"));
        ExitModes foo = ExitModes.COMPLETES.withBreak(ExitModesTest.b("foo"), x);
        ExitModes bar = ExitModes.COMPLETES.withBreak(ExitModesTest.b("bar"), y);
        ExitModes foobar = foo.withBreak(ExitModesTest.b("bar"), y);
        ExitModesTest.assertEquals((String)"{bfoo=((x@-1) always)}", (String)foo.toString());
        ExitModesTest.assertEquals((String)"{bbar=((y@-1) always)}", (String)bar.toString());
        ExitModesTest.assertEquals((String)"{bfoo=((x@-1) always), bbar=((y@-1) always)}", (String)foobar.toString());
        ExitModesTest.assertEquals((Object)foo, (Object)ExitModes.COMPLETES.union(foo));
        ExitModesTest.assertEquals((Object)foo, (Object)foo.union(ExitModes.COMPLETES));
        ExitModesTest.assertEquals((Object)bar, (Object)ExitModes.COMPLETES.union(bar));
        ExitModesTest.assertEquals((Object)bar, (Object)bar.union(ExitModes.COMPLETES));
        ExitModesTest.assertEquals((Object)foobar, (Object)bar.union(foo));
        ExitModesTest.assertEquals((Object)foobar, (Object)foo.union(bar));
    }

    public final void testIntersection() {
        ExitModesTest.assertEquals((Object)ExitModes.COMPLETES, (Object)ExitModes.COMPLETES.intersection(ExitModes.COMPLETES));
        LiveSet x = LiveSet.EMPTY.with(ExitModesTest.decl("x"));
        LiveSet y = LiveSet.EMPTY.with(ExitModesTest.decl("y"));
        LiveSet xy = x.with(ExitModesTest.decl("y"));
        ExitModes foo = ExitModes.COMPLETES.withBreak(ExitModesTest.b("foo"), x);
        ExitModes bar = ExitModes.COMPLETES.withBreak(ExitModesTest.b("bar"), y);
        ExitModes baz = ExitModes.COMPLETES.withBreak(ExitModesTest.b("baz"), xy);
        ExitModes foobar = foo.withBreak(ExitModesTest.b("bar"), y);
        ExitModes foobaz = foo.withBreak(ExitModesTest.b("baz"), xy);
        ExitModes barbaz = bar.withBreak(ExitModesTest.b("baz"), xy);
        ExitModes foobarbaz = foobar.withBreak(ExitModesTest.b("baz"), xy);
        ExitModes fooS = ExitModes.COMPLETES.intersection(foo);
        ExitModes barS = ExitModes.COMPLETES.intersection(bar);
        ExitModes bazS = ExitModes.COMPLETES.intersection(baz);
        ExitModes fooSbarS = ExitModes.COMPLETES.intersection(foobar);
        ExitModes fooSbarSbaz = fooSbarS.union(baz);
        ExitModes fooSbarSbazS = fooSbarS.intersection(bazS);
        ExitModesTest.assertEquals((String)"{bfoo=((x@-1) always)}", (String)foo.toString());
        ExitModesTest.assertEquals((String)"{bbar=((y@-1) always)}", (String)bar.toString());
        ExitModesTest.assertEquals((String)"{bbaz=((x@-1 y@-1) always)}", (String)baz.toString());
        ExitModesTest.assertEquals((String)"{bfoo=((x@-1))}", (String)fooS.toString());
        ExitModesTest.assertEquals((String)"{bbar=((y@-1))}", (String)barS.toString());
        ExitModesTest.assertEquals((String)"{bbaz=((x@-1 y@-1))}", (String)bazS.toString());
        ExitModesTest.assertEquals((String)"{bfoo=((x@-1)), bbar=((y@-1))}", (String)fooSbarS.toString());
        ExitModesTest.assertEquals((String)"{bbaz=((x@-1 y@-1) always), bfoo=((x@-1)), bbar=((y@-1))}", (String)fooSbarSbaz.toString());
        ExitModesTest.assertFalse((boolean)foo.equals(fooS));
        ExitModesTest.assertFalse((boolean)bar.equals(barS));
        ExitModesTest.assertFalse((boolean)foobar.equals(fooSbarS));
        ExitModesTest.assertEquals((Object)foo, (Object)foo.intersection(foo));
        ExitModesTest.assertEquals((Object)fooS, (Object)ExitModes.COMPLETES.intersection(foo));
        ExitModesTest.assertEquals((Object)fooS, (Object)foo.intersection(ExitModes.COMPLETES));
        ExitModesTest.assertEquals((Object)bar, (Object)bar.intersection(bar));
        ExitModesTest.assertEquals((Object)barS, (Object)ExitModes.COMPLETES.intersection(bar));
        ExitModesTest.assertEquals((Object)barS, (Object)bar.intersection(ExitModes.COMPLETES));
        ExitModesTest.assertEquals((Object)foobar, (Object)bar.intersection(foo));
        ExitModesTest.assertEquals((Object)foobar, (Object)foo.intersection(bar));
        ExitModesTest.assertEquals((Object)foobarbaz, (Object)foobaz.intersection(barbaz));
        ExitModesTest.assertEquals((Object)foobarbaz, (Object)foobaz.intersection(barbaz));
        ExitModesTest.assertEquals((Object)foobarbaz, (Object)barbaz.intersection(foobaz));
        ExitModesTest.assertEquals((Object)fooSbarSbazS, (Object)fooSbarS.intersection(barbaz));
        ExitModesTest.assertEquals((Object)fooSbarSbazS, (Object)barbaz.intersection(fooSbarS));
    }

    private static BreakStmt b(String label) {
        return new BreakStmt(FilePosition.UNKNOWN, label);
    }

    private static Declaration decl(String name) {
        return new Declaration(FilePosition.UNKNOWN, new Identifier(FilePosition.UNKNOWN, name), null);
    }
}

