/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin;

import com.google.caja.config.ConfigUtil;
import com.google.caja.config.WhiteList;
import com.google.caja.lang.css.CssSchema;
import com.google.caja.lang.html.HtmlSchema;
import com.google.caja.lexer.InputSource;
import com.google.caja.plugin.PipelineMaker;
import com.google.caja.plugin.Planner;
import com.google.caja.reporting.BuildInfo;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageType;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.util.Join;
import com.google.caja.util.Lists;
import com.google.caja.util.Pair;
import com.google.caja.util.Sets;
import com.google.caja.util.Strings;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Config {
    private final Options options = new Options();
    private final Option INPUT = this.defineOption("i", "input", "Input URI containing HTML (with optional script and style blocks)", true);
    private final Option OUTPUT_HTML = this.defineOption("h", "output_html", "Output file path for translated HTML (defaults to input with \".out.html\")", true);
    private final Option ONLY_JS_EMITTED = this.defineBooleanOption("s", "only_js_emitted", "Whether input HTML should be collapsed into one output JS file.");
    private final Option OUTPUT_JS = this.defineOption("j", "output_js", "Output file path for translated JS (defaults to input with \".out.js\")", true);
    private final Option OUTPUT_BASE = this.defineOption("o", "out", "Path to which the appropriate extension is added to form output files.", true);
    private final Option CSS_PROPERTY_WHITELIST = this.defineOption("cps", "css_prop_schema", "A file: or resource: URI of the CSS Property Whitelist to use.", true);
    private final Option HTML_ATTRIBUTE_WHITELIST = this.defineOption("has", "html_attrib_schema", "A file: or resource: URI of the HTML attribute Whitelist to use.", true);
    private final Option HTML_ELEMENT_WHITELIST = this.defineOption("hps", "html_property_schema", "A file: or resource: URI of the HTML element Whitelist to use.", true);
    private final Option BASE_URI = this.defineOption("base_uri", "The URI relative to which URIs in the inputs are resolved.", true);
    private final Option FETCHER_BASE = this.defineOption("fetcher_base", "An ancestor of all files which the URI fetcher is allowed to resolve.", true);
    private final Option F_URI = this.defineOption("fu", "f_uri", "A URI which the URI fetcher is allowed to fetch.", true);
    private final Option L_URI = this.defineOption("lu", "l_uri", "A URI which the URI policy is allowed to link to.", true);
    private final Option SERVICE_PORT = this.defineOption("port", "The port on which cajoling service is run.", true);
    private final Option VIEW = this.defineOption("v", "view", "Gadget view to render (default is 'canvas')", true);
    private final Option ID_CLASS = this.defineOption("c", "id_class", "The module ID if it is statically known", true);
    private final Option DEBUG_MODE = this.defineBooleanOption("g", "debug", "Set to add debugging info to cajoled output.");
    private final Option RENDERER = this.defineOption("r", "renderer", "The output renderer " + Strings.toLowerCase(Arrays.toString((Object[])SourceRenderMode.values())) + "", true);
    private final Option PIPELINE_PRECONDITIONS = this.defineOption("ppc", "preconds", "Space separated properties as described in help text.", true);
    private final Option PIPELINE_GOALS = this.defineOption("pg", "goals", "Space separated properties as described in help text.", true);
    private final Option ES53 = this.defineBooleanOption("es53", "es53", "Set to use ES5/3 translation instead of valija/cajita.");
    private final Class<?> mainClass;
    private final PrintWriter stderr;
    private final String usageText;
    private List<URI> inputUris;
    private File outputBase;
    private File outputJsFile;
    private File outputHtmlFile;
    private URI cssPropertyWhitelistUri;
    private URI htmlAttributeWhitelistUri;
    private URI htmlElementWhitelistUri;
    private URI baseUri;
    private File fetcherBase;
    private String gadgetView;
    private SourceRenderMode renderer;
    private Set<String> fUris;
    private Set<String> lUris;
    private int servicePort;
    private String idClass;
    private Planner.PlanState negGoals = Planner.EMPTY;
    private Planner.PlanState posGoals = Planner.EMPTY;
    private Planner.PlanState negPreconds = Planner.EMPTY;
    private Planner.PlanState posPreconds = Planner.EMPTY;
    private boolean es53;

    public Config(Class<?> mainClass, PrintStream stderr, String usageText) {
        this(mainClass, new PrintWriter(stderr), usageText);
    }

    public Config(Class<?> mainClass, PrintWriter stderr, String usageText) {
        this.mainClass = mainClass;
        this.stderr = stderr;
        this.usageText = usageText;
    }

    public Collection<URI> getInputUris() {
        return this.inputUris;
    }

    public File getOutputJsFile() {
        return this.outputJsFile;
    }

    public File getOutputHtmlFile() {
        return this.outputHtmlFile;
    }

    public File getOutputBase() {
        return this.outputBase;
    }

    public int getServicePort() {
        return this.servicePort;
    }

    public URI getCssPropertyWhitelistUri() {
        return this.cssPropertyWhitelistUri;
    }

    public URI getHtmlAttributeWhitelistUri() {
        return this.htmlAttributeWhitelistUri;
    }

    public URI getHtmlElementWhitelistUri() {
        return this.htmlElementWhitelistUri;
    }

    public URI getBaseUri() {
        return this.baseUri;
    }

    public File getFetcherBase() {
        return this.fetcherBase;
    }

    public CssSchema getCssSchema(MessageQueue mq) {
        return new CssSchema(Config.whitelist(this.cssPropertyWhitelistUri, mq), Config.whitelist(URI.create("resource:///com/google/caja/lang/css/css-extensions-fns.json"), mq));
    }

    public HtmlSchema getHtmlSchema(MessageQueue mq) {
        return new HtmlSchema(Config.whitelist(this.htmlElementWhitelistUri, mq), Config.whitelist(this.htmlAttributeWhitelistUri, mq));
    }

    public String getGadgetView() {
        return this.gadgetView;
    }

    public String getIdClass() {
        return this.idClass;
    }

    public Set<String> getFetchableUris() {
        return this.fUris;
    }

    public Set<String> getLinkableUris() {
        return this.lUris;
    }

    public SourceRenderMode renderer() {
        return this.renderer;
    }

    public Planner.PlanState goals(Planner.PlanState ps) {
        return ps.without(this.negGoals).with(this.posGoals);
    }

    public Planner.PlanState preconditions(Planner.PlanState ps) {
        return ps.without(this.negPreconds).with(this.posPreconds);
    }

    public boolean getES53() {
        return this.es53;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processArguments(String[] argv) {
        try {
            String goals;
            String preconds;
            int i$;
            CommandLine cl;
            try {
                cl = new BasicParser().parse(this.options, argv, false);
            }
            catch (ParseException e) {
                this.usage(e.getMessage(), this.stderr);
                boolean bl = false;
                this.stderr.flush();
                return bl;
            }
            this.inputUris = Lists.newArrayList();
            for (String input : Config.getOptionValues(cl, this.INPUT)) {
                URI inputUri;
                block42: {
                    File inputFile;
                    block43: {
                        try {
                            if (input.indexOf(58) >= 0) {
                                inputUri = new URI(input);
                                break block42;
                            }
                            inputFile = new File(input);
                            if (!inputFile.exists()) {
                                this.usage("File \"" + input + "\" does not exist", this.stderr);
                                boolean bl = false;
                                return bl;
                            }
                            if (inputFile.canRead() && !inputFile.isDirectory()) break block43;
                            this.usage("File \"" + input + "\" is not a regular file", this.stderr);
                            boolean bl = false;
                            return bl;
                        }
                        catch (URISyntaxException ex) {
                            this.usage("Input \"" + input + "\" is not a valid URI", this.stderr);
                            boolean bl = false;
                            return bl;
                        }
                    }
                    inputUri = inputFile.getAbsoluteFile().toURI();
                }
                this.inputUris.add(inputUri);
            }
            if (this.inputUris.isEmpty()) {
                this.usage("Option \"--" + this.INPUT.getLongOpt() + "\" missing", this.stderr);
                boolean arr$ = false;
                return arr$;
            }
            if (cl.getOptionValue(this.OUTPUT_BASE.getOpt()) != null) {
                this.outputBase = new File(cl.getOptionValue(this.OUTPUT_BASE.getOpt()));
                this.outputJsFile = Config.substituteExtension(this.outputBase, ".out.js");
                this.outputHtmlFile = Config.substituteExtension(this.outputBase, ".out.html");
                if (cl.getOptionValue(this.OUTPUT_JS.getOpt()) != null) {
                    this.usage("Can't specify both --out and --output_js", this.stderr);
                    boolean arr$ = false;
                    return arr$;
                }
                if (cl.getOptionValue(this.OUTPUT_HTML.getOpt()) != null) {
                    this.usage("Can't specify both --out and --output_html", this.stderr);
                    boolean arr$ = false;
                    return arr$;
                }
            } else {
                this.outputJsFile = cl.getOptionValue(this.OUTPUT_JS.getOpt()) == null ? null : new File(cl.getOptionValue(this.OUTPUT_JS.getOpt()));
                File file = this.outputHtmlFile = cl.getOptionValue(this.OUTPUT_HTML.getOpt()) == null ? null : new File(cl.getOptionValue(this.OUTPUT_HTML.getOpt()));
                if (this.outputJsFile == null && this.outputHtmlFile == null) {
                    this.usage("Please specify js output via " + this.OUTPUT_JS.getLongOpt() + " &| html output via " + this.OUTPUT_HTML.getLongOpt(), this.stderr);
                    boolean arr$ = false;
                    return arr$;
                }
            }
            try {
                this.cssPropertyWhitelistUri = new URI(cl.getOptionValue(this.CSS_PROPERTY_WHITELIST.getOpt(), "resource:///com/google/caja/lang/css/css-extensions.json"));
                this.htmlAttributeWhitelistUri = new URI(cl.getOptionValue(this.HTML_ATTRIBUTE_WHITELIST.getOpt(), "resource:///com/google/caja/lang/html/html4-attributes-extensions.json"));
                this.htmlElementWhitelistUri = new URI(cl.getOptionValue(this.HTML_ELEMENT_WHITELIST.getOpt(), "resource:///com/google/caja/lang/html/html4-elements-extensions.json"));
                this.baseUri = cl.getOptionValue(this.BASE_URI.getOpt()) != null ? new URI(cl.getOptionValue(this.BASE_URI.getOpt())) : this.inputUris.get(0);
            }
            catch (URISyntaxException ex) {
                this.stderr.println("Invalid whitelist URI: " + ex.getInput() + "\n    " + ex.getReason());
                int len$ = 0;
                this.stderr.flush();
                return len$ != 0;
            }
            if (cl.getOptionValue(this.FETCHER_BASE.getOpt()) != null) {
                this.fetcherBase = new File(cl.getOptionValue(this.FETCHER_BASE.getOpt()));
            } else if (Strings.equalsIgnoreCase(this.baseUri.getScheme(), "file")) {
                this.fetcherBase = new File(this.baseUri).getParentFile();
            }
            this.gadgetView = cl.getOptionValue(this.VIEW.getOpt(), "canvas");
            this.idClass = cl.getOptionValue(this.ID_CLASS.getOpt(), null);
            try {
                String servicePortString = cl.getOptionValue(this.SERVICE_PORT.getOpt(), "8887");
                this.servicePort = Integer.parseInt(servicePortString);
            }
            catch (NumberFormatException e) {
                this.stderr.println("Invalid service port: " + this.SERVICE_PORT.getOpt() + "\n    " + e.getMessage());
                i$ = 0;
                this.stderr.flush();
                return i$ != 0;
            }
            this.fUris = Sets.immutableSet(Config.getOptionValues(cl, this.F_URI));
            this.lUris = Sets.immutableSet(Config.getOptionValues(cl, this.L_URI));
            String renderString = cl.getOptionValue(this.RENDERER.getOpt());
            if (renderString != null) {
                this.renderer = SourceRenderMode.valueOf(renderString.toUpperCase());
                if (this.renderer == null) {
                    this.stderr.println("Invalid renderer: " + renderString);
                    i$ = 0;
                    return i$ != 0;
                }
            } else {
                this.renderer = SourceRenderMode.PRETTY;
            }
            boolean debugMode = cl.hasOption(this.DEBUG_MODE.getOpt());
            this.es53 = cl.hasOption(this.ES53.getOpt());
            boolean onlyJsEmitted = cl.hasOption(this.ONLY_JS_EMITTED.getOpt());
            if (debugMode) {
                this.negGoals = this.negGoals.with(PipelineMaker.ONE_CAJOLED_MODULE);
                this.posGoals = this.posGoals.with(PipelineMaker.ONE_CAJOLED_MODULE_DEBUG);
            }
            if (onlyJsEmitted) {
                this.negGoals = this.negGoals.with(PipelineMaker.HTML_SAFE_STATIC);
            }
            if ((preconds = cl.getOptionValue(this.PIPELINE_PRECONDITIONS.getOpt())) != null) {
                Pair<Planner.PlanState, Planner.PlanState> deltas = this.planDeltas(preconds);
                this.negPreconds = this.negPreconds.with((Planner.PlanState)deltas.a);
                this.posPreconds = this.posPreconds.with((Planner.PlanState)deltas.b);
            }
            if ((goals = cl.getOptionValue(this.PIPELINE_GOALS.getOpt())) != null) {
                Pair<Planner.PlanState, Planner.PlanState> deltas = this.planDeltas(goals);
                this.negGoals = this.negGoals.with((Planner.PlanState)deltas.a);
                this.posGoals = this.posGoals.with((Planner.PlanState)deltas.b);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.stderr.flush();
        }
    }

    private Pair<Planner.PlanState, Planner.PlanState> planDeltas(String props) {
        props = props.trim();
        List<String> neg = Lists.newArrayList();
        List<String> pos = Lists.newArrayList();
        for (String part : props.split("\\s+")) {
            if ("".equals(part)) continue;
            if (part.startsWith("-")) {
                neg.add(part.substring(1));
                continue;
            }
            pos.add(part.substring(part.startsWith("+") ? 1 : 0));
        }
        try {
            return Pair.pair(PipelineMaker.planState(Join.join((CharSequence)"", neg)), PipelineMaker.planState(Join.join((CharSequence)"", pos)));
        }
        catch (IllegalArgumentException ex) {
            this.stderr.println("Bad prop in " + props + " : " + ex.getMessage());
            return Pair.pair(Planner.EMPTY, Planner.EMPTY);
        }
    }

    public void usage(String msg, PrintWriter out) {
        out.println(BuildInfo.getInstance().getBuildInfo());
        out.println();
        if (msg != null && !"".equals(msg)) {
            out.println(msg);
            out.println();
        }
        new HelpFormatter().printHelp(out, 74, this.mainClass.getSimpleName() + " --input <in.html> [--output_js <out.js> | --out <out>]", "\n", this.options, 1, 3, "\n" + this.usageText, false);
        out.println();
        int maxPlanStateWidth = 0;
        for (Pair<String, String> doc : PipelineMaker.getPreconditionDocumentation()) {
            maxPlanStateWidth = Math.max(maxPlanStateWidth, ((String)doc.a).length());
        }
        for (Pair<String, String> doc : PipelineMaker.getGoalDocumentation()) {
            maxPlanStateWidth = Math.max(maxPlanStateWidth, ((String)doc.a).length());
        }
        String fmtStr = "%" + maxPlanStateWidth + "s | %s";
        out.println("Preconditions (default to " + PipelineMaker.DEFAULT_PRECONDS + ")");
        for (Pair<String, String> doc : PipelineMaker.getPreconditionDocumentation()) {
            out.println(String.format(fmtStr, doc.a, doc.b));
        }
        out.println();
        out.println("Goals (default to " + PipelineMaker.DEFAULT_GOALS + ")");
        for (Pair<String, String> doc : PipelineMaker.getGoalDocumentation()) {
            out.println(String.format(fmtStr, doc.a, doc.b));
        }
    }

    private static File substituteExtension(File file, String extension) {
        String fileName = file.getName();
        int lastDot = fileName.lastIndexOf(46);
        if (lastDot < 0) {
            lastDot = fileName.length();
        }
        return new File(file.getParentFile(), fileName.substring(0, lastDot) + extension);
    }

    private static WhiteList whitelist(URI uri, MessageQueue mq) {
        InputSource src = new InputSource(uri);
        try {
            return ConfigUtil.loadWhiteListFromJson(uri, ConfigUtil.RESOURCE_RESOLVER, mq);
        }
        catch (IOException ex) {
            mq.addMessage((MessageTypeInt)MessageType.IO_ERROR, src);
        }
        catch (com.google.caja.lexer.ParseException ex) {
            ex.toMessageQueue(mq);
        }
        return new WhiteList(){

            @Override
            public Set<String> allowedItems() {
                return Collections.emptySet();
            }

            @Override
            public Map<String, WhiteList.TypeDefinition> typeDefinitions() {
                return Collections.emptyMap();
            }
        };
    }

    private Option defineOption(String shortFlag, String longFlag, String help, boolean optional) {
        Option opt = new Option(shortFlag, longFlag, true, help);
        opt.setOptionalArg(optional);
        this.options.addOption(opt);
        return opt;
    }

    private Option defineBooleanOption(String shortFlag, String longFlag, String help) {
        Option opt = new Option(shortFlag, longFlag, false, help);
        opt.setOptionalArg(true);
        this.options.addOption(opt);
        return opt;
    }

    private Option defineOption(String longFlag, String help, boolean optional) {
        return this.defineOption(longFlag, longFlag, help, optional);
    }

    private static String[] getOptionValues(CommandLine cl, Option opt) {
        String[] values = cl.getOptionValues(opt.getOpt());
        return values != null ? values : new String[]{};
    }

    public static void main(String[] argv) {
        Config config = new Config(Config.class, System.err, "Does some stuff.");
        System.err.println(config.processArguments(argv));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SourceRenderMode {
        MINIFY,
        PRETTY,
        SIDEBYSIDE,
        DEBUGGER;

    }
}

