/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin;

import com.google.caja.lexer.ParseException;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.css.CssTree;
import com.google.caja.parser.js.ArrayConstructor;
import com.google.caja.plugin.CssRuleRewriter;
import com.google.caja.plugin.PluginMeta;
import com.google.caja.render.Concatenator;
import com.google.caja.render.JsPrettyPrinter;
import com.google.caja.reporting.RenderContext;
import com.google.caja.util.CajaTestCase;

public class CssRuleRewriterTest
extends CajaTestCase {
    public final void testSimpleRule() {
        this.assertCompiledCss("p {color:purple}", "[ '.', ' p {\\n  color: purple\\n}' ]");
    }

    public final void testClassRule() {
        this.assertCompiledCss(".foo .bar {color:blue}", "[ '.', ' .foo .bar {\\n  color: blue\\n}' ]");
        this.assertCompiledCss(".foo.bar {color:blue}", "[ '.', ' .foo.bar {\\n  color: blue\\n}' ]");
    }

    public final void testIdRule() {
        this.assertCompiledCss("#foo {color:blue}", "[ '.', ' #foo-', ' {\\n  color: blue\\n}' ]");
        this.assertCompiledCss("p#foo #baz{color:blue}", "[ '.', ' p#foo-', ' #baz-', ' {\\n  color: blue\\n}' ]");
    }

    public final void testBodyMarker() {
        this.assertCompiledCss("body.ie6 p {color:blue}", "[ '.vdoc-body___.ie6.', ' p {\\n  color: blue\\n}' ]");
        this.assertCompiledCss("body.ie6#zoicks p {color:blue}", "[ '.vdoc-body___.ie6#zoicks-', '.', ' p {\\n  color: blue\\n}' ]");
        this.assertCompiledCss("body.ie6 {color:blue}", "[ '.vdoc-body___.ie6.', ' {\\n  color: blue\\n}' ]");
        this.assertCompiledCss("body { font-size: 12pt }", "[ '.vdoc-body___.', ' {\\n  font-size: 12pt\\n}' ]");
    }

    public final void testCompoundRule() {
        this.assertCompiledCss("a, b {color:blue}", "[ '.', ' a, .', ' b {\\n  color: blue\\n}' ]");
    }

    public final void testDescendentRule() {
        this.assertCompiledCss("#foo > #bar { color: blue }", "[ '.', ' #foo-', ' > #bar-', ' {\\n  color: blue\\n}' ]");
    }

    public final void testWildcardSelectors() {
        this.assertCompiledCss("div * { margin: 0; }", "[ '.', ' div * {\\n  margin: 0;\\n}' ]");
    }

    public final void testStaticIdClass() {
        this.assertCompiledCss("#a > #b, .c { color: blue }", "[ '.xyz___ #a-xyz___ > #b-xyz___, .xyz___ .c {\\n  color: blue\\n}' ]", false);
    }

    private void assertCompiledCss(String input, String golden) {
        this.assertCompiledCss(input, golden, true);
    }

    private void assertCompiledCss(String input, String golden, boolean dynamic) {
        try {
            PluginMeta pm = new PluginMeta();
            if (!dynamic) {
                pm.setIdClass("xyz___");
            }
            CssTree.StyleSheet css = this.css(this.fromString(input));
            new CssRuleRewriter(pm).rewriteCss(css);
            ArrayConstructor ac = CssRuleRewriter.cssToJs(css);
            CssRuleRewriterTest.assertEquals((String)golden, (String)CssRuleRewriterTest.render(ac, 160));
        }
        catch (ParseException ex) {
            CssRuleRewriterTest.fail((String)input);
        }
    }

    private static String render(ParseTreeNode node, int limit) {
        StringBuilder sb = new StringBuilder();
        JsPrettyPrinter pp = new JsPrettyPrinter(new Concatenator(sb));
        pp.setLineLengthLimit(limit);
        node.render(new RenderContext(pp));
        pp.noMoreTokens();
        return sb.toString();
    }
}

