/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.clean.rdbms.scripts;

import java.util.ArrayList;
import java.util.Collection;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.impl.clean.rdbms.DBCleanException;
import org.exoplatform.services.jcr.impl.clean.rdbms.scripts.DBCleaningScripts;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySQLCleaningScipts
extends DBCleaningScripts {
    public MySQLCleaningScipts(String dialect, RepositoryEntry rEntry) throws DBCleanException {
        super(dialect, rEntry);
        this.prepareRenamingApproachScripts();
    }

    public MySQLCleaningScipts(String dialect, WorkspaceEntry wEntry) throws DBCleanException {
        super(dialect, wEntry);
        if (this.multiDb) {
            this.prepareRenamingApproachScripts();
        } else {
            this.prepareSimpleCleaningApproachScripts();
        }
    }

    @Override
    protected void prepareRenamingApproachScripts() throws DBCleanException {
        super.prepareRenamingApproachScripts();
        this.cleaningScripts.clear();
        this.cleaningScripts.addAll(this.getTablesRenamingScripts());
        this.cleaningScripts.addAll(this.getDBInitializationScripts());
        this.cleaningScripts.addAll(this.getIndexesDroppingScripts());
        String constraintName = "JCR_FK_" + this.valueTableSuffix + "_PROPERTY FOREIGN KEY(PROPERTY_ID) REFERENCES " + this.itemTableName + "(ID)";
        this.committingScripts.add("ALTER TABLE " + this.valueTableName + " ADD CONSTRAINT " + constraintName);
    }

    @Override
    protected String constraintDroppingSyntax() {
        return "DROP FOREIGN KEY";
    }

    @Override
    protected Collection<String> getDBInitializationScripts() throws DBCleanException {
        Collection<String> scripts = super.getDBInitializationScripts();
        return this.filter(scripts);
    }

    private Collection<String> filter(Collection<String> scripts) {
        String JCR_ITEM_PRIMARY_KEY = "CONSTRAINT JCR_PK_" + this.itemTableSuffix + " PRIMARY KEY(ID)";
        String JCR_ITEM_FOREIGN_KEY = "CONSTRAINT JCR_FK_" + this.itemTableSuffix + "_PARENT FOREIGN KEY(PARENT_ID) REFERENCES " + this.itemTableName + "(ID)";
        String JCR_VALUE_PRIMARY_KEY = "CONSTRAINT JCR_PK_" + this.valueTableSuffix + " PRIMARY KEY(ID)";
        String JCR_VALUE_FOREIGN_KEY = "CONSTRAINT JCR_FK_" + this.valueTableSuffix + "_PROPERTY FOREIGN KEY(PROPERTY_ID) REFERENCES " + this.itemTableName + "(ID)";
        ArrayList<String> filteredScripts = new ArrayList<String>();
        for (String script : scripts) {
            if (script.contains(JCR_ITEM_PRIMARY_KEY + ",")) {
                script = script.replace(JCR_ITEM_PRIMARY_KEY + ",", JCR_ITEM_PRIMARY_KEY);
                script = script.replace(JCR_ITEM_FOREIGN_KEY, "");
            } else if (script.contains(JCR_VALUE_PRIMARY_KEY + ",")) {
                script = script.replace(JCR_VALUE_PRIMARY_KEY + ",", JCR_VALUE_PRIMARY_KEY);
                script = script.replace(JCR_VALUE_FOREIGN_KEY, "");
            }
            filteredScripts.add(script);
        }
        return filteredScripts;
    }

    @Override
    protected Collection<String> getTablesRenamingScripts() {
        ArrayList<String> scripts = new ArrayList<String>();
        scripts.add("ALTER TABLE " + this.valueTableName + " RENAME TO " + this.valueTableName + "_OLD");
        scripts.add("ALTER TABLE " + this.itemTableName + " RENAME TO " + this.itemTableName + "_OLD");
        scripts.add("ALTER TABLE " + this.refTableName + " RENAME TO " + this.refTableName + "_OLD");
        return scripts;
    }

    @Override
    protected Collection<String> getOldTablesRenamingScripts() {
        ArrayList<String> scripts = new ArrayList<String>();
        scripts.add("ALTER TABLE " + this.itemTableName + "_OLD RENAME TO " + this.itemTableName);
        scripts.add("ALTER TABLE " + this.valueTableName + "_OLD RENAME TO " + this.valueTableName);
        scripts.add("ALTER TABLE " + this.refTableName + "_OLD RENAME TO " + this.refTableName);
        return scripts;
    }
}

