/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.config;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.database.utils.DialectDetecter;
import org.exoplatform.services.database.utils.JDBCUtils;
import org.exoplatform.services.jcr.config.ConfigurationPersister;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class JDBCConfigurationPersister
implements ConfigurationPersister {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.JDBCConfigurationPersister");
    public static final String PARAM_SOURCE_NAME = "source-name";
    public static final String PARAM_DIALECT = "dialect";
    protected static final String CONFIGNAME = "REPOSITORY-SERVICE-WORKING-CONFIG";
    protected static final String C_DATA = "CONFIGDATA";
    protected String configTableName = "JCR_CONFIG";
    protected String sourceName;
    protected String initSQL;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void init(PropertiesParam params) throws RepositoryConfigurationException {
        String dialect;
        block21: {
            String sourceNameParam = params.getProperty(PARAM_SOURCE_NAME);
            if (sourceNameParam == null && (sourceNameParam = params.getProperty("sourceName")) == null) {
                throw new RepositoryConfigurationException("Repository service configuration. Source name (source-name) is expected");
            }
            this.sourceName = sourceNameParam;
            String dialectParam = params.getProperty(PARAM_DIALECT);
            String string = dialect = dialectParam == null ? "AUTO" : dialectParam.toUpperCase();
            if (dialect.startsWith("AUTO")) {
                Connection conn = null;
                try {
                    try {
                        conn = this.openConnection();
                        dialect = DialectDetecter.detect((DatabaseMetaData)conn.getMetaData());
                    }
                    catch (NamingException e) {
                        throw new RepositoryConfigurationException(e);
                    }
                    catch (SQLException e) {
                        throw new RepositoryConfigurationException(e);
                    }
                    Object var8_6 = null;
                    if (conn == null) break block21;
                }
                catch (Throwable throwable) {
                    Object var8_7 = null;
                    if (conn == null) throw throwable;
                    try {
                        conn.close();
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new RepositoryConfigurationException(e);
                    }
                }
                try {}
                catch (SQLException e) {
                    throw new RepositoryConfigurationException(e);
                }
                conn.close();
            }
        }
        String binType = "BLOB";
        if (dialect.startsWith("GENERIC") || dialect.startsWith("HSQLDB")) {
            binType = "VARBINARY(1000000)";
        } else if (dialect.startsWith("PGSQL")) {
            this.configTableName = this.configTableName.toUpperCase().toLowerCase();
            binType = "BYTEA";
        } else if (dialect.startsWith("MSSQL")) {
            binType = "VARBINARY(max)";
        } else if (dialect.startsWith("SYBASE")) {
            binType = "IMAGE";
        } else if (dialect.startsWith("INGRES")) {
            this.configTableName = this.configTableName.toUpperCase().toLowerCase();
            binType = "LONG BYTE";
        } else if (dialect.startsWith("MYSQL")) {
            binType = "LONGBLOB";
        }
        this.initSQL = "CREATE TABLE " + this.configTableName + " (" + "NAME VARCHAR(64) NOT NULL, " + "CONFIG " + binType + " NOT NULL, " + "CONSTRAINT JCR_CONFIG_PK PRIMARY KEY(NAME))";
    }

    protected void checkInitialized() throws RepositoryConfigurationException {
        if (this.sourceName == null) {
            throw new RepositoryConfigurationException("Repository service configuration persister isn not initialized. Call init() before.");
        }
    }

    protected Connection openConnection() throws NamingException, SQLException {
        final DataSource ds = (DataSource)new InitialContext().lookup(this.sourceName);
        return (Connection)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Connection>(){

            @Override
            public Connection run() throws Exception {
                return ds.getConnection();
            }
        });
    }

    protected boolean isDbInitialized(final Connection con) {
        return (Boolean)SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return JDBCUtils.tableExists((String)JDBCConfigurationPersister.this.configTableName, (Connection)con);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasConfig() throws RepositoryConfigurationException {
        this.checkInitialized();
        try {
            block27: {
                block26: {
                    block22: {
                        block25: {
                            block20: {
                                block21: {
                                    con = this.openConnection();
                                    res = null;
                                    ps = null;
                                    try {
                                        if (this.isDbInitialized(con)) {
                                            ps = con.prepareStatement("SELECT COUNT(*) FROM " + this.configTableName + " WHERE NAME=?");
                                            ps.setString(1, "REPOSITORY-SERVICE-WORKING-CONFIG");
                                            res = ps.executeQuery();
                                            if (res.next()) {
                                                var4_6 = res.getInt(1) > 0;
                                                var6_8 = null;
                                                if (res == null) break block20;
                                                break block21;
                                            }
                                        }
                                        var4_7 = false;
                                        break block22;
                                    }
                                    catch (Throwable var5_14) {
                                        var6_10 = null;
                                        if (res != null) {
                                            try {
                                                res.close();
                                            }
                                            catch (SQLException e) {
                                                JDBCConfigurationPersister.LOG.error((Object)("Can't close the ResultSet: " + e.getMessage()));
                                            }
                                        }
                                        if (ps != null) {
                                            try {
                                                ps.close();
                                            }
                                            catch (SQLException e) {
                                                JDBCConfigurationPersister.LOG.error((Object)("Can't close the Statement: " + e.getMessage()));
                                            }
                                        }
                                        con.close();
                                        throw var5_14;
                                    }
                                }
                                ** try [egrp 2[TRYBLOCK] [3 : 126->135)] { 
lbl41:
                                // 1 sources

                                res.close();
                                break block20;
lbl43:
                                // 1 sources

                                catch (SQLException e) {
                                    JDBCConfigurationPersister.LOG.error((Object)("Can't close the ResultSet: " + e.getMessage()));
                                }
                            }
                            if (ps != null) {
                                ** try [egrp 3[TRYBLOCK] [4 : 172->181)] { 
lbl48:
                                // 1 sources

                                ps.close();
                                break block25;
lbl50:
                                // 1 sources

                                catch (SQLException e) {
                                    JDBCConfigurationPersister.LOG.error((Object)("Can't close the Statement: " + e.getMessage()));
                                }
                            }
                        }
                        con.close();
                        return var4_6;
                    }
                    var6_9 = null;
                    if (res != null) {
                        ** try [egrp 2[TRYBLOCK] [3 : 126->135)] { 
lbl59:
                        // 1 sources

                        res.close();
                        break block26;
lbl61:
                        // 1 sources

                        catch (SQLException e) {
                            JDBCConfigurationPersister.LOG.error((Object)("Can't close the ResultSet: " + e.getMessage()));
                        }
                    }
                }
                if (ps != null) {
                    ** try [egrp 3[TRYBLOCK] [4 : 172->181)] { 
lbl66:
                    // 1 sources

                    ps.close();
                    break block27;
lbl68:
                    // 1 sources

                    catch (SQLException e) {
                        JDBCConfigurationPersister.LOG.error((Object)("Can't close the Statement: " + e.getMessage()));
                    }
                }
            }
            con.close();
            return var4_7;
        }
        catch (SQLException e) {
            throw new RepositoryConfigurationException("Database exception. " + e, e);
        }
        catch (NamingException e) {
            throw new RepositoryConfigurationException("JDNI exception. " + e, e);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream read() throws RepositoryConfigurationException {
        this.checkInitialized();
        try {
            block20: {
                block17: {
                    con = this.openConnection();
                    res = null;
                    ps = null;
                    try {
                        if (!this.isDbInitialized(con)) {
                            throw new ConfigurationNotInitializedException("Configuration table not is found in database. Source name " + this.sourceName);
                        }
                        ps = con.prepareStatement("SELECT * FROM " + this.configTableName + " WHERE NAME=?");
                        ps.setString(1, "REPOSITORY-SERVICE-WORKING-CONFIG");
                        res = ps.executeQuery();
                        if (!res.next()) {
                            throw new ConfigurationNotFoundException("No configuration data is found in database. Source name " + this.sourceName);
                        }
                        config = new ConfigDataHolder(res.getBinaryStream("config"));
                        var5_8 = config.getStream();
                        var7_9 = null;
                        if (res == null) break block17;
                    }
                    catch (Throwable var6_13) {
                        var7_10 = null;
                        if (res != null) {
                            try {
                                res.close();
                            }
                            catch (SQLException e) {
                                JDBCConfigurationPersister.LOG.error((Object)("Can't close the ResultSet: " + e.getMessage()));
                            }
                        }
                        if (ps != null) {
                            try {
                                ps.close();
                            }
                            catch (SQLException e) {
                                JDBCConfigurationPersister.LOG.error((Object)("Can't close the Statement: " + e.getMessage()));
                            }
                        }
                        con.close();
                        throw var6_13;
                    }
                    ** try [egrp 2[TRYBLOCK] [2 : 187->196)] { 
lbl40:
                    // 1 sources

                    res.close();
                    break block17;
lbl42:
                    // 1 sources

                    catch (SQLException e) {
                        JDBCConfigurationPersister.LOG.error((Object)("Can't close the ResultSet: " + e.getMessage()));
                    }
                }
                if (ps != null) {
                    ** try [egrp 3[TRYBLOCK] [3 : 233->242)] { 
lbl47:
                    // 1 sources

                    ps.close();
                    break block20;
lbl49:
                    // 1 sources

                    catch (SQLException e) {
                        JDBCConfigurationPersister.LOG.error((Object)("Can't close the Statement: " + e.getMessage()));
                    }
                }
            }
            con.close();
            return var5_8;
        }
        catch (IOException e) {
            throw new RepositoryConfigurationException("Configuration read exception. " + e, e);
        }
        catch (SQLException e) {
            throw new RepositoryConfigurationException("Database exception. " + e, e);
        }
        catch (NamingException e) {
            throw new RepositoryConfigurationException("JDNI exception. " + e, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(InputStream confData) throws RepositoryConfigurationException {
        this.checkInitialized();
        String sql = null;
        try {
            Connection con;
            block16: {
                con = this.openConnection();
                Statement ps = null;
                try {
                    if (!this.isDbInitialized(con)) {
                        con.setAutoCommit(true);
                        Statement st = con.createStatement();
                        sql = this.initSQL;
                        st.executeUpdate(sql);
                        st.close();
                        con.close();
                        con = this.openConnection();
                    }
                    con.setAutoCommit(false);
                    if (this.isDbInitialized(con)) {
                        ConfigDataHolder config = new ConfigDataHolder(confData);
                        if (this.hasConfig()) {
                            sql = "UPDATE " + this.configTableName + " SET CONFIG=? WHERE NAME=?";
                            ps = con.prepareStatement(sql);
                            ps.setBinaryStream(1, config.getStream(), config.getLength());
                            ps.setString(2, CONFIGNAME);
                        } else {
                            sql = "INSERT INTO " + this.configTableName + " (NAME, CONFIG) VALUES (?,?)";
                            ps = con.prepareStatement(sql);
                            ps.setString(1, CONFIGNAME);
                            ps.setBinaryStream(2, config.getStream(), config.getLength());
                        }
                        if (ps.executeUpdate() <= 0) {
                            LOG.warn((Object)("Repository service configuration doesn't stored ok. No rows was affected in JDBC operation. Datasource " + this.sourceName + ". SQL: " + sql));
                        }
                    } else {
                        throw new ConfigurationNotInitializedException("Configuration table can not be created in database. Source name " + this.sourceName + ". SQL: " + sql);
                    }
                    con.commit();
                    Object var7_9 = null;
                    if (ps == null) break block16;
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (SQLException e) {
                            LOG.error((Object)("Can't close the Statement: " + e.getMessage()));
                        }
                    }
                    con.close();
                    throw throwable;
                }
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)("Can't close the Statement: " + e.getMessage()));
                }
            }
            con.close();
            {
            }
        }
        catch (IOException e) {
            throw new RepositoryConfigurationException("Configuration read exception. " + e, e);
        }
        catch (SQLException e) {
            throw new RepositoryConfigurationException("Database exception. " + e + ". SQL: " + sql, e);
        }
        catch (NamingException e) {
            throw new RepositoryConfigurationException("JDNI exception. " + e, e);
        }
    }

    protected class ConfigDataHolder {
        private final byte[] config;

        ConfigDataHolder(InputStream source) throws IOException {
            ByteArrayOutputStream configOut = new ByteArrayOutputStream();
            byte[] b = new byte[1024];
            int read = 0;
            while ((read = source.read(b)) > 0) {
                configOut.write(b, 0, read);
            }
            this.config = configOut.toByteArray();
        }

        InputStream getStream() {
            return new ByteArrayInputStream(this.config);
        }

        int getLength() {
            return this.config.length;
        }
    }

    public class ConfigurationNotInitializedException
    extends RepositoryConfigurationException {
        ConfigurationNotInitializedException(String m) {
            super(m);
        }
    }

    public class ConfigurationNotFoundException
    extends RepositoryConfigurationException {
        ConfigurationNotFoundException(String m) {
            super(m);
        }
    }
}

