/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.jbosscache;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.impl.core.query.ChangesFilterListsWrapper;
import org.exoplatform.services.jcr.impl.core.query.Indexer;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoMode;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoModeHandler;
import org.exoplatform.services.jcr.impl.core.query.QueryHandler;
import org.exoplatform.services.jcr.impl.core.query.SearchManager;
import org.exoplatform.services.jcr.impl.core.query.jbosscache.JBossCacheIndexChangesFilter;
import org.exoplatform.services.jcr.impl.storage.jbosscache.AbstractWriteOnlyCacheLoader;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.jboss.cache.CacheStatus;
import org.jboss.cache.Fqn;
import org.jboss.cache.Modification;
import org.jboss.cache.config.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexerCacheLoader
extends AbstractWriteOnlyCacheLoader {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.IndexerCacheLoader");
    private final Map<Fqn<String>, Indexer> indexers = new HashMap<Fqn<String>, Indexer>();
    protected volatile IndexerIoModeHandler modeHandler;

    public void commit(Object tx) throws Exception {
    }

    public void register(SearchManager searchManager, SearchManager parentSearchManager, QueryHandler handler, QueryHandler parentHandler) throws RepositoryConfigurationException {
        this.indexers.put((Fqn<String>)Fqn.fromElements((Object[])new String[]{searchManager.getWsId()}), new Indexer(searchManager, parentSearchManager, handler, parentHandler));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Register " + searchManager.getWsId() + " " + (Object)((Object)this) + " in " + this.indexers));
        }
    }

    public void unregister(Fqn<String> fqn) {
        this.indexers.remove(fqn);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Unregister " + fqn.getLastElementAsString() + " " + (Object)((Object)this) + " in " + this.indexers));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Fqn name, Object key, Object value) throws Exception {
        if (key.equals(JBossCacheIndexChangesFilter.LISTWRAPPER) && value instanceof ChangesFilterListsWrapper) {
            Object v1;
            if (LOG.isDebugEnabled()) {
                LOG.info((Object)"Received list wrapper, start indexing...");
            }
            ChangesFilterListsWrapper wrapper = (ChangesFilterListsWrapper)value;
            try {
                Indexer indexer = this.indexers.get(name.getParent());
                if (indexer == null) {
                    LOG.warn((Object)("No indexer could be found for the fqn " + name.getParent()));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("The current content of the map of indexers is " + this.indexers));
                    }
                } else if (wrapper.withChanges()) {
                    indexer.updateIndex(wrapper.getChanges(), wrapper.getParentChanges());
                } else {
                    indexer.updateIndex(wrapper.getAddedNodes(), wrapper.getRemovedNodes(), wrapper.getParentAddedNodes(), wrapper.getParentRemovedNodes());
                }
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object v0;
                Object var7_7 = null;
                boolean cacheModeLocal = this.cache.getInvocationContext().getOptionOverrides().isCacheModeLocal();
                try {
                    this.cache.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
                    this.cache.removeNode(name);
                    v0 = null;
                }
                catch (Throwable throwable2) {
                    v0 = null;
                }
                Object var10_13 = v0;
                this.cache.getInvocationContext().getOptionOverrides().setCacheModeLocal(cacheModeLocal);
                throw throwable;
            }
            boolean cacheModeLocal = this.cache.getInvocationContext().getOptionOverrides().isCacheModeLocal();
            try {
                this.cache.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
                this.cache.removeNode(name);
                v1 = null;
            }
            catch (Throwable throwable) {
                v1 = null;
            }
            Object var10_12 = v1;
            this.cache.getInvocationContext().getOptionOverrides().setCacheModeLocal(cacheModeLocal);
            {
            }
        }
        return null;
    }

    public void put(Fqn arg0, Map<Object, Object> arg1) throws Exception {
    }

    @Override
    public void put(List<Modification> modifications) throws Exception {
    }

    public void remove(Fqn arg0) throws Exception {
    }

    void setMode(IndexerIoMode ioMode) {
        this.getModeHandler().setMode(ioMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IndexerIoModeHandler getModeHandler() {
        if (this.modeHandler == null) {
            if (this.cache.getCacheStatus() != CacheStatus.STARTED) {
                throw new IllegalStateException("The cache should be started first");
            }
            IndexerCacheLoader indexerCacheLoader = this;
            synchronized (indexerCacheLoader) {
                if (this.modeHandler == null) {
                    this.modeHandler = new IndexerIoModeHandler(this.cache.getRPCManager().isCoordinator() || this.cache.getConfiguration().getCacheMode() == Configuration.CacheMode.LOCAL ? IndexerIoMode.READ_WRITE : IndexerIoMode.READ_ONLY);
                }
            }
        }
        return this.modeHandler;
    }
}

