/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.persistent;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.exoplatform.services.jcr.impl.dataflow.StringValueData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.PersistedValueData;

public class StringPersistedValueData
extends StringValueData
implements PersistedValueData {
    public StringPersistedValueData() {
        super(0, null);
    }

    public StringPersistedValueData(int orderNumber, String value) {
        super(orderNumber, value);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.orderNumber = in.readInt();
        byte[] data = new byte[in.readInt()];
        if (data.length > 0) {
            in.readFully(data);
            this.value = new String(data, "UTF-8");
        } else {
            this.value = "";
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.orderNumber);
        byte[] data = this.value.getBytes("UTF-8");
        out.writeInt(data.length);
        if (data.length > 0) {
            out.write(data);
        }
    }
}

