/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.processor;

import java.util.Iterator;
import java.util.Map;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ActivityResourceBundlePlugin
extends BaseComponentPlugin {
    private static final Log LOG = ExoLogger.getLogger(ActivityResourceBundlePlugin.class);
    private String activityType;
    private Map<String, String> activityKeyTypeMapping;
    private String resourceBundleKeyFile;

    public ActivityResourceBundlePlugin() {
    }

    public ActivityResourceBundlePlugin(InitParams initParams) {
        if (initParams == null) {
            LOG.warn((Object)"Failed to register this plugin: initParams is null");
            return;
        }
        Iterator itr = initParams.getObjectParamIterator();
        if (!itr.hasNext()) {
            LOG.warn((Object)"Failed to register this plugin: no <object-param>");
            return;
        }
        ObjectParameter objectParameter = (ObjectParameter)itr.next();
        if (objectParameter.getName() == null || objectParameter.getName().isEmpty()) {
            LOG.warn((Object)"Failed to register this plugin: must set name with <object-param> as resource bundle key file");
            return;
        }
        this.resourceBundleKeyFile = objectParameter.getName();
        ActivityResourceBundlePlugin pluginConfig = (ActivityResourceBundlePlugin)((Object)objectParameter.getObject());
        if (pluginConfig.getActivityKeyTypeMapping() == null || pluginConfig.getActivityKeyTypeMapping().size() == 0) {
            LOG.warn((Object)"Failed to register this plugin: no <entry> found for <object-param> config");
            return;
        }
        this.activityKeyTypeMapping = pluginConfig.getActivityKeyTypeMapping();
    }

    public String getActivityType() {
        return this.activityType;
    }

    public void setActivityType(String activityType) {
        this.activityType = activityType;
    }

    public Map<String, String> getActivityKeyTypeMapping() {
        return this.activityKeyTypeMapping;
    }

    public void setActivityKeyTypeMapping(Map<String, String> mapping) {
        if (mapping == null || mapping.size() == 0) {
            LOG.warn((Object)"mapping is null or size = 0");
            return;
        }
        this.activityKeyTypeMapping = mapping;
    }

    public String getResourceBundleKeyFile() {
        return this.resourceBundleKeyFile;
    }

    public boolean hasMessageBundleKey(String activityTitleId) {
        if (this.activityKeyTypeMapping == null || this.activityKeyTypeMapping.size() == 0) {
            return false;
        }
        return this.activityKeyTypeMapping.containsKey(activityTitleId);
    }

    public String getMessageBundleKey(String activityTitleId) {
        if (this.hasMessageBundleKey(activityTitleId)) {
            return this.activityKeyTypeMapping.get(activityTitleId);
        }
        return null;
    }

    public boolean isValid() {
        return this.activityType != null && this.activityKeyTypeMapping != null && this.activityKeyTypeMapping.size() > 0 && this.resourceBundleKeyFile != null;
    }
}

